/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.controller;

import com.google.common.collect.Lists;
import eu.midnightdust.lib.util.PlatformFunctions;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.MidnightInput;
import eu.midnightdust.midnightcontrols.client.compat.InventoryTabsCompat;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.compat.SodiumCompat;
import eu.midnightdust.midnightcontrols.client.compat.YACLCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.controller.PressAction;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;
import eu.midnightdust.midnightcontrols.client.gui.RingScreen;
import eu.midnightdust.midnightcontrols.client.gui.TouchscreenOverlay;
import eu.midnightdust.midnightcontrols.client.mixin.AdvancementsScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.CreativeInventoryScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.MouseAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.RecipeBookWidgetAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.TabNavigationWidgetAccessor;
import eu.midnightdust.midnightcontrols.client.util.HandledScreenAccessor;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.impl.client.itemgroup.CreativeGuiExtensions;
import net.fabricmc.fabric.impl.client.itemgroup.FabricCreativeGuiComponents;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_3532;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_454;
import net.minecraft.class_457;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_481;
import net.minecraft.class_489;
import net.minecraft.class_490;
import net.minecraft.class_507;
import net.minecraft.class_512;
import net.minecraft.class_7706;
import net.minecraft.class_8089;
import org.aperlambda.lambdacommon.utils.Pair;
import org.jetbrains.annotations.NotNull;

public class InputHandlers {
    private InputHandlers() {
    }

    private static List<class_1761> getVisibleGroups(class_481 screen) {
        return class_7706.method_47341().stream().filter(itemGroup -> {
            if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(itemGroup)) {
                return true;
            }
            return ((CreativeGuiExtensions)screen).fabric_currentPage() == ((FabricItemGroup)itemGroup).getPage() && itemGroup.method_47311();
        }).toList();
    }

    public static PressAction handleHotbar(boolean next) {
        return (client, button, value, action) -> {
            if (action == ButtonState.RELEASE) {
                return false;
            }
            if (client.field_1755 == null && client.field_1724 != null) {
                if (!client.field_1724.method_7325()) {
                    if (next) {
                        client.field_1724.method_31548().method_7373(-1.0);
                    } else {
                        client.field_1724.method_31548().method_7373(1.0);
                    }
                } else if (client.field_1705.method_1739().method_1980()) {
                    client.field_1705.method_1739().method_1976(next ? -1 : 1);
                } else {
                    float g = class_3532.method_15363((float)(client.field_1724.method_31549().method_7252() + (float)(next ? 1 : -1) * 0.005f), (float)0.0f, (float)0.2f);
                    client.field_1724.method_31549().method_7248(g);
                }
                return true;
            }
            if (client.field_1755 instanceof RingScreen) {
                MidnightControlsClient.get().ring.cyclePage(next);
            } else {
                class_437 patt4288$temp = client.field_1755;
                if (patt4288$temp instanceof CreativeInventoryScreenAccessor) {
                    CreativeInventoryScreenAccessor inventory = (CreativeInventoryScreenAccessor)patt4288$temp;
                    if (PlatformFunctions.isModLoaded((String)"connectormod")) {
                        return true;
                    }
                    class_1761 currentTab = CreativeInventoryScreenAccessor.getSelectedTab();
                    int currentColumn = currentTab.method_7743();
                    class_1761.class_7915 currentRow = currentTab.method_47309();
                    class_1761 newTab = null;
                    List<class_1761> visibleTabs = InputHandlers.getVisibleGroups((class_481)client.field_1755);
                    for (class_1761 tab : visibleTabs) {
                        if (!tab.method_47309().equals((Object)currentRow) || !(newTab == null && (next && tab.method_7743() > currentColumn || !next && tab.method_7743() < currentColumn)) && (newTab == null || (!next || tab.method_7743() <= currentColumn || tab.method_7743() >= newTab.method_7743()) && (next || tab.method_7743() >= currentColumn || tab.method_7743() <= newTab.method_7743()))) continue;
                        newTab = tab;
                    }
                    if (newTab == null) {
                        for (class_1761 tab : visibleTabs) {
                            if (tab.method_47309().compareTo((Enum)currentRow) == 0 || !(next && newTab == null || next && newTab.method_7743() > tab.method_7743() || !next && newTab == null) && (next || newTab.method_7743() >= tab.method_7743())) continue;
                            newTab = tab;
                        }
                    }
                    if (newTab == null) {
                        for (class_1761 tab : visibleTabs) {
                            if ((!next || tab.method_47309() != class_1761.class_7915.field_41049 || tab.method_7743() != 0) && (next || tab.method_47309() != class_1761.class_7915.field_41050 || newTab != null && tab.method_7743() <= newTab.method_7743())) continue;
                            newTab = tab;
                        }
                    }
                    if (newTab == null || newTab.equals(currentTab)) {
                        newTab = class_7706.method_47328();
                    }
                    inventory.midnightcontrols$setSelectedTab(newTab);
                    return true;
                }
                if (client.field_1755 instanceof class_490 || client.field_1755 instanceof class_479 || client.field_1755 instanceof class_489) {
                    class_507 recipeBook;
                    class_437 patt6586$temp = client.field_1755;
                    if (patt6586$temp instanceof class_490) {
                        class_490 inventoryScreen = (class_490)patt6586$temp;
                        recipeBook = inventoryScreen.method_2659();
                    } else {
                        class_437 patt6728$temp = client.field_1755;
                        if (patt6728$temp instanceof class_479) {
                            class_479 craftingScreen = (class_479)patt6728$temp;
                            recipeBook = craftingScreen.method_2659();
                        } else {
                            recipeBook = ((class_489)client.field_1755).method_2659();
                        }
                    }
                    RecipeBookWidgetAccessor recipeBookAccessor = (RecipeBookWidgetAccessor)recipeBook;
                    List<class_512> tabs = recipeBookAccessor.getTabButtons();
                    class_512 currentTab = recipeBookAccessor.getCurrentTab();
                    if (currentTab == null || !recipeBook.method_2605()) {
                        if (MidnightControlsCompat.isInventoryTabsPresent()) {
                            InventoryTabsCompat.handleInventoryTabs(client.field_1755, next);
                        }
                        return false;
                    }
                    int nextTab = tabs.indexOf(currentTab) + (next ? 1 : -1);
                    if (nextTab < 0) {
                        nextTab = tabs.size() - 1;
                    } else if (nextTab >= tabs.size()) {
                        nextTab = 0;
                    }
                    currentTab.method_1964(false);
                    currentTab = tabs.get(nextTab);
                    recipeBookAccessor.setCurrentTab(currentTab);
                    currentTab.method_1964(true);
                    recipeBookAccessor.midnightcontrols$refreshResults(true);
                    return true;
                }
                class_437 patt7955$temp = client.field_1755;
                if (patt7955$temp instanceof AdvancementsScreenAccessor) {
                    AdvancementsScreenAccessor screen = (AdvancementsScreenAccessor)patt7955$temp;
                    List<class_454> tabs = screen.getTabs().values().stream().distinct().toList();
                    class_454 tab = screen.getSelectedTab();
                    if (tab == null) {
                        return false;
                    }
                    for (int i = 0; i < tabs.size(); ++i) {
                        if (!tabs.get(i).equals(tab)) continue;
                        int nextTab = i + (next ? 1 : -1);
                        if (nextTab < 0) {
                            nextTab = tabs.size() - 1;
                        } else if (nextTab >= tabs.size()) {
                            nextTab = 0;
                        }
                        screen.getAdvancementManager().method_2864(tabs.get(nextTab).method_53813().method_53649(), true);
                        break;
                    }
                    return true;
                }
                if (client.field_1755 != null && client.field_1755.method_25396().stream().anyMatch(e -> e instanceof class_8089)) {
                    return Lists.newCopyOnWriteArrayList((Iterable)client.field_1755.method_25396()).stream().anyMatch(e -> {
                        if (e instanceof class_8089) {
                            class_8089 tabs = (class_8089)e;
                            TabNavigationWidgetAccessor accessor = (TabNavigationWidgetAccessor)tabs;
                            int tabIndex = accessor.getTabs().indexOf((Object)accessor.getTabManager().method_48614());
                            if (next ? tabIndex + 1 < accessor.getTabs().size() : tabIndex > 0) {
                                if (next) {
                                    tabs.method_48987(tabIndex + 1, true);
                                } else {
                                    tabs.method_48987(tabIndex - 1, true);
                                }
                                return true;
                            }
                        }
                        return false;
                    });
                }
                if (FabricLoader.getInstance().isModLoaded("sodium")) {
                    SodiumCompat.handleTabs(client.field_1755, next);
                }
                if (FabricLoader.getInstance().isModLoaded("yet-another-config-lib") && YACLCompat.handleCategories(client.field_1755, next)) {
                    return true;
                }
            }
            if (MidnightControlsCompat.isInventoryTabsPresent()) {
                InventoryTabsCompat.handleInventoryTabs(client.field_1755, next);
            }
            return false;
        };
    }

    public static PressAction handlePage(boolean next) {
        return (client, button, value, action) -> {
            if (action == ButtonState.RELEASE) {
                return false;
            }
            if (client.field_1755 instanceof class_481) {
                try {
                    return client.field_1755.method_25396().stream().filter(element -> element instanceof class_4264).map(element -> (class_4264)element).filter(element -> element.method_25369() != null && element.method_25369().method_10851() != null).anyMatch(element -> {
                        if (next && element.method_25369().getString().equals(">")) {
                            element.method_25306();
                            return true;
                        }
                        if (element.method_25369().getString().equals("<")) {
                            element.method_25306();
                            return true;
                        }
                        return false;
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (MidnightControlsCompat.isInventoryTabsPresent()) {
                InventoryTabsCompat.handleInventoryPage(client.field_1755, next);
            }
            return false;
        };
    }

    public static PressAction handleExit() {
        return (client, button, value, action) -> {
            if (client.field_1755 != null && client.field_1755.getClass() != class_442.class) {
                if (!MidnightControlsCompat.handleMenuBack(client, client.field_1755) && !MidnightControlsClient.get().input.tryGoBack(client.field_1755)) {
                    client.field_1755.method_25419();
                }
                return true;
            }
            return false;
        };
    }

    public static PressAction handleActions() {
        return (client, button, value, action) -> {
            int slotId;
            class_437 patt12283$temp = client.field_1755;
            if (!(patt12283$temp instanceof class_465)) {
                return false;
            }
            class_465 screen = (class_465)patt12283$temp;
            if (client.field_1761 == null || client.field_1724 == null) {
                return false;
            }
            if (MidnightControlsClient.get().input.inventoryInteractionCooldown > 0) {
                return true;
            }
            double x = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
            double y = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
            HandledScreenAccessor accessor = (HandledScreenAccessor)screen;
            class_1735 slot = ((HandledScreenAccessor)screen).midnightcontrols$getSlotAt(x, y);
            if (slot == null) {
                if (button.getName().equals("take_all")) {
                    ((MouseAccessor)client.field_1729).setLeftButtonClicked(true);
                    return false;
                }
                slotId = accessor.midnightcontrols$isClickOutsideBounds(x, y, accessor.getX(), accessor.getY(), 0) ? -999 : -1;
            } else {
                slotId = slot.field_7874;
            }
            class_1713 actionType = class_1713.field_7790;
            int clickData = 0;
            MidnightControlsClient.get().input.inventoryInteractionCooldown = 5;
            switch (button.getName()) {
                case "take_all": {
                    if (!(screen instanceof class_481) || slot == null || !((CreativeInventoryScreenAccessor)((Object)accessor)).midnightcontrols$isCreativeInventorySlot(slot) && !MidnightControlsCompat.streamCompatHandlers().anyMatch(handler -> handler.isCreativeSlot(screen, slot))) break;
                    actionType = class_1713.field_7796;
                    break;
                }
                case "take": {
                    clickData = 1;
                    break;
                }
                case "quick_move": {
                    actionType = class_1713.field_7794;
                    break;
                }
                default: {
                    return false;
                }
            }
            accessor.midnightcontrols$onMouseClick(slot, slotId, clickData, actionType);
            return true;
        };
    }

    public static boolean handlePauseGame(@NotNull class_310 client, @NotNull ButtonBinding binding, float value, @NotNull ButtonState action) {
        if (action == ButtonState.PRESS) {
            if (client.field_1755 == null || client.field_1755 instanceof RingScreen) {
                client.method_20539(false);
            } else if (client.field_1755 instanceof class_465 && client.field_1724 != null) {
                client.field_1724.method_7346();
            } else {
                client.field_1755.method_25419();
            }
        }
        return true;
    }

    public static boolean handleScreenshot(@NotNull class_310 client, @NotNull ButtonBinding binding, float value, @NotNull ButtonState action) {
        if (action == ButtonState.RELEASE) {
            class_318.method_1659((File)client.field_1697, (class_276)client.method_1522(), text -> client.execute(() -> client.field_1705.method_1743().method_1812(text)));
        }
        return true;
    }

    public static boolean handleToggleSneak(@NotNull class_310 client, @NotNull ButtonBinding button, float value, @NotNull ButtonState action) {
        button.asKeyBinding().ifPresent(binding -> {
            boolean sneakToggled = (Boolean)client.field_1690.method_42449().method_41753();
            if (client.field_1724.method_31549().field_7479 && sneakToggled) {
                client.field_1690.method_42449().method_41748((Object)false);
            } else if (MidnightControlsConfig.controllerToggleSneak != sneakToggled) {
                client.field_1690.method_42449().method_41748((Object)(!sneakToggled ? 1 : 0));
            }
            binding.method_23481(button.pressed);
            if (client.field_1724.method_31549().field_7479 && sneakToggled) {
                client.field_1690.method_42449().method_41748((Object)true);
            } else if (MidnightControlsConfig.controllerToggleSneak != sneakToggled) {
                client.field_1690.method_42449().method_41748((Object)sneakToggled);
            }
        });
        return true;
    }

    public static boolean handleToggleSprint(@NotNull class_310 client, @NotNull ButtonBinding button, float value, @NotNull ButtonState action) {
        button.asKeyBinding().ifPresent(binding -> {
            boolean sprintToggled = (Boolean)client.field_1690.method_42450().method_41753();
            if (client.field_1724.method_31549().field_7479 && sprintToggled) {
                client.field_1690.method_42450().method_41748((Object)false);
            } else if (MidnightControlsConfig.controllerToggleSneak != sprintToggled) {
                client.field_1690.method_42450().method_41748((Object)(!sprintToggled ? 1 : 0));
            }
            binding.method_23481(button.pressed);
            if (client.field_1724.method_31549().field_7479 && sprintToggled) {
                client.field_1690.method_42450().method_41748((Object)true);
            } else if (MidnightControlsConfig.controllerToggleSneak != sprintToggled) {
                client.field_1690.method_42450().method_41748((Object)sprintToggled);
            }
        });
        return true;
    }

    public static PressAction handleInventorySlotPad(int direction) {
        return (client, binding, value, action) -> {
            class_465 inventory;
            block5: {
                block4: {
                    class_437 patt18035$temp = client.field_1755;
                    if (!(patt18035$temp instanceof class_465)) break block4;
                    inventory = (class_465)patt18035$temp;
                    if (action != ButtonState.RELEASE) break block5;
                }
                return false;
            }
            HandledScreenAccessor accessor = (HandledScreenAccessor)inventory;
            int guiLeft = accessor.getX();
            int guiTop = accessor.getY();
            double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
            double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
            class_1735 mouseSlot = accessor.midnightcontrols$getSlotAt(mouseX, mouseY);
            Optional<class_1735> closestSlot = inventory.method_17577().field_7761.parallelStream().filter(Predicate.isEqual(mouseSlot).negate()).map(slot -> {
                int posX = guiLeft + slot.field_7873 + 8;
                int posY = guiTop + slot.field_7872 + 8;
                int otherPosX = (int)mouseX;
                int otherPosY = (int)mouseY;
                if (mouseSlot != null) {
                    otherPosX = guiLeft + mouseSlot.field_7873 + 8;
                    otherPosY = guiTop + mouseSlot.field_7872 + 8;
                }
                double distance = Math.sqrt(Math.pow(posX - otherPosX, 2.0) + Math.pow(posY - otherPosY, 2.0));
                return Pair.of((Object)slot, (Object)distance);
            }).filter(entry -> {
                class_1735 slot = (class_1735)entry.key;
                int posX = guiLeft + slot.field_7873 + 8;
                int posY = guiTop + slot.field_7872 + 8;
                int otherPosX = (int)mouseX;
                int otherPosY = (int)mouseY;
                if (mouseSlot != null) {
                    otherPosX = guiLeft + mouseSlot.field_7873 + 8;
                    otherPosY = guiTop + mouseSlot.field_7872 + 8;
                }
                if (direction == 0) {
                    return posY < otherPosY;
                }
                if (direction == 1) {
                    return posY > otherPosY;
                }
                if (direction == 2) {
                    return posX > otherPosX;
                }
                if (direction == 3) {
                    return posX < otherPosX;
                }
                return false;
            }).min(Comparator.comparingDouble(p -> (Double)p.value)).map(p -> (class_1735)p.key);
            if (closestSlot.isPresent()) {
                class_1735 slot2 = closestSlot.get();
                int x = guiLeft + slot2.field_7873 + 8;
                int y = guiTop + slot2.field_7872 + 8;
                InputManager.queueMousePosition((double)x * (double)client.method_22683().method_4480() / (double)client.method_22683().method_4486(), (double)y * (double)client.method_22683().method_4507() / (double)client.method_22683().method_4502());
                return true;
            }
            return false;
        };
    }

    public static boolean always(@NotNull class_310 client, @NotNull ButtonBinding binding) {
        return true;
    }

    public static boolean inGame(@NotNull class_310 client, @NotNull ButtonBinding binding) {
        return client.field_1755 == null && MidnightControlsClient.get().input.screenCloseCooldown <= 0 || client.field_1755 instanceof TouchscreenOverlay || client.field_1755 instanceof RingScreen;
    }

    public static boolean inNonInteractiveScreens(@NotNull class_310 client, @NotNull ButtonBinding binding) {
        if (client.field_1755 == null) {
            return false;
        }
        return !MidnightInput.isScreenInteractive(client.field_1755);
    }

    public static boolean inInventory(@NotNull class_310 client, @NotNull ButtonBinding binding) {
        return client.field_1755 instanceof class_465;
    }

    public static boolean inAdvancements(@NotNull class_310 client, @NotNull ButtonBinding binding) {
        return client.field_1755 instanceof class_457;
    }
}

