/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols;

import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.MidnightControlsConstants;
import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import eu.midnightdust.midnightcontrols.event.PlayerChangeControlsModeCallback;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MidnightControls
implements ModInitializer {
    private static MidnightControls INSTANCE;
    public static final class_2960 CONTROLS_MODE_CHANNEL;
    public static final class_2960 FEATURE_CHANNEL;
    public static final class_2960 HELLO_CHANNEL;
    public static boolean isExtrasLoaded;
    public final Logger logger = LogManager.getLogger((String)"MidnightControls");

    public void onInitialize() {
        INSTANCE = this;
        isExtrasLoaded = FabricLoader.getInstance().isModLoaded("midnightcontrols-extra");
        this.log("Initializing MidnightControls...");
        ServerPlayNetworking.registerGlobalReceiver((class_2960)HELLO_CHANNEL, (server, player, handler, buf, responseSender) -> {
            String version = buf.method_10800(32);
            ControlsMode.byId(buf.method_10800(32)).ifPresent(controlsMode -> server.execute(() -> ((PlayerChangeControlsModeCallback)PlayerChangeControlsModeCallback.EVENT.invoker()).apply((class_1657)player, (ControlsMode)((Object)((Object)controlsMode)))));
            server.execute(() -> ServerPlayNetworking.send((class_3222)player, (class_2960)FEATURE_CHANNEL, (class_2540)this.makeFeatureBuffer(MidnightControlsFeature.HORIZONTAL_REACHAROUND)));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CONTROLS_MODE_CHANNEL, (server, player, handler, buf, responseSender) -> ControlsMode.byId(buf.method_10800(32)).ifPresent(controlsMode -> server.execute(() -> ((PlayerChangeControlsModeCallback)PlayerChangeControlsModeCallback.EVENT.invoker()).apply((class_1657)player, (ControlsMode)((Object)((Object)controlsMode))))));
    }

    public void log(String info) {
        this.logger.info("[MidnightControls] " + info);
    }

    public void warn(String warning) {
        this.logger.info("[MidnightControls] " + warning);
    }

    public class_2540 makeControlsModeBuffer(@NotNull ControlsMode controlsMode) {
        Objects.requireNonNull(controlsMode, "Controls mode cannot be null.");
        return new class_2540(Unpooled.buffer()).method_10788(controlsMode.getName(), 32);
    }

    public class_2540 makeFeatureBuffer(MidnightControlsFeature ... features) {
        if (features.length == 0) {
            throw new IllegalArgumentException("At least one feature must be provided.");
        }
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10804(features.length);
        for (MidnightControlsFeature feature : features) {
            buffer.method_10788(feature.getName(), 64);
            buffer.method_52964(feature.isAllowed());
        }
        return buffer;
    }

    public class_2540 makeHello(@NotNull ControlsMode controlsMode) {
        String version = "";
        Optional container = FabricLoader.getInstance().getModContainer("midnightcontrols");
        if (container.isPresent()) {
            version = ((ModContainer)container.get()).getMetadata().getVersion().getFriendlyString();
        }
        return new class_2540(Unpooled.buffer()).method_10788(version, 32).method_10788(controlsMode.getName(), 32);
    }

    public static MidnightControls get() {
        return INSTANCE;
    }

    static {
        CONTROLS_MODE_CHANNEL = new class_2960(MidnightControlsConstants.CONTROLS_MODE_CHANNEL.toString());
        FEATURE_CHANNEL = new class_2960(MidnightControlsConstants.FEATURE_CHANNEL.toString());
        HELLO_CHANNEL = new class_2960(MidnightControlsConstants.HELLO_CHANNEL.toString());
    }
}

