/*
 * Decompiled with CFR 0.152.
 */
package rynnavinx.sspb.client.gui;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class SSPBGameOptions {
    private static final String DEFAULT_FILE_NAME = "sodium-shadowy-path-blocks-options.json";
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    private Path configPath;
    public int shadowynessPercent = 85;
    private float shadowyness = 0.85f;
    private float shadowynessCompliment = 0.15f;
    public boolean onlyAffectPathBlocks = false;
    public boolean vanillaPathBlockLighting = false;

    public void updateShadowyness(int shadowynessPercent) {
        this.shadowynessPercent = shadowynessPercent;
        this.shadowyness = (float)shadowynessPercent / 100.0f;
        this.shadowynessCompliment = 1.0f - (float)shadowynessPercent / 100.0f;
    }

    public float getShadowyness() {
        return this.shadowyness;
    }

    public float getShadowynessCompliment() {
        return this.shadowynessCompliment;
    }

    public static SSPBGameOptions load() {
        SSPBGameOptions config;
        Path path;
        block10: {
            path = FabricLoader.getInstance().getConfigDir().resolve(DEFAULT_FILE_NAME);
            if (Files.exists(path, new LinkOption[0])) {
                try (FileReader reader = new FileReader(path.toFile());){
                    config = (SSPBGameOptions)GSON.fromJson((Reader)reader, SSPBGameOptions.class);
                    break block10;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse SSPB config", e);
                }
            }
            config = new SSPBGameOptions();
        }
        config.configPath = path;
        try {
            config.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't update SSPB config", e);
        }
        return config;
    }

    public void writeChanges() throws IOException {
        Path dir = this.configPath.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + dir);
        }
        Files.writeString(this.configPath, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
    }
}

