/*
 * Decompiled with CFR 0.152.
 */
package dev.ztereohype.nicerskies.sky.star;

import net.minecraft.class_287;
import net.minecraft.class_3532;

public class Star {
    private final float xCoord;
    private final float yCoord;
    private final float zCoord;
    private final float longitudeSin;
    private final float longitudeCos;
    private final float latitudeSin;
    private final float latitudeCos;
    private final float resizeSpeed;
    private final float spinSpeed;
    private final float minRadius;
    private final float maxRadius;
    private final int r;
    private final int g;
    private final int b;
    private float currentAngle;
    private float currentRadius;

    public Star(float randX, float randY, float randZ, float size, int[] color, float resizeSpeed, float spinSpeed) {
        this.r = color[0];
        this.g = color[1];
        this.b = color[2];
        float invsqrtDistance = (float)class_3532.method_15345((double)(randX * randX + randY * randY + randZ * randZ));
        this.xCoord = randX * invsqrtDistance * 100.0f;
        this.yCoord = randY * invsqrtDistance * 100.0f;
        this.zCoord = randZ * invsqrtDistance * 100.0f;
        double polarAngle = Math.atan2(randX, randZ);
        this.longitudeSin = (float)Math.sin(polarAngle);
        this.longitudeCos = (float)Math.cos(polarAngle);
        double proj = Math.atan2(Math.sqrt(randX * randX + randZ * randZ), randY);
        this.latitudeSin = (float)Math.sin(proj);
        this.latitudeCos = (float)Math.cos(proj);
        this.spinSpeed = spinSpeed;
        this.resizeSpeed = resizeSpeed;
        this.minRadius = size - 0.15f;
        this.maxRadius = size + 0.15f;
        this.currentRadius = size;
        this.currentAngle = (spinSpeed + 0.01f) * 628.3f;
    }

    public void tick(int ticks) {
        this.currentAngle += this.spinSpeed;
        this.currentRadius = class_3532.method_16439((float)class_3532.method_15374((float)((float)ticks * this.resizeSpeed)), (float)this.minRadius, (float)this.maxRadius);
    }

    public void setVertices(class_287 bufferBuilder) {
        float horizontalVertexDistance = this.currentRadius * class_3532.method_15362((float)this.currentAngle);
        float verticalVertexDistance = this.currentRadius * class_3532.method_15374((float)this.currentAngle);
        float firstVertexDistance = -horizontalVertexDistance + verticalVertexDistance;
        float secondVertexDistance = -horizontalVertexDistance - verticalVertexDistance;
        float thirdVertexDistance = horizontalVertexDistance - verticalVertexDistance;
        float fourthVertexDistance = horizontalVertexDistance + verticalVertexDistance;
        float ae1 = thirdVertexDistance * this.latitudeCos;
        float ae2 = fourthVertexDistance * this.latitudeCos;
        float ae3 = firstVertexDistance * this.latitudeCos;
        float ae4 = secondVertexDistance * this.latitudeCos;
        bufferBuilder.method_22912((double)(this.xCoord + ae1 * this.longitudeSin - secondVertexDistance * this.longitudeCos), (double)(this.yCoord + firstVertexDistance * this.latitudeSin), (double)(this.zCoord + secondVertexDistance * this.longitudeSin + ae1 * this.longitudeCos)).method_1336(this.r, this.g, this.b, 255).method_1344();
        bufferBuilder.method_22912((double)(this.xCoord + ae2 * this.longitudeSin - thirdVertexDistance * this.longitudeCos), (double)(this.yCoord + secondVertexDistance * this.latitudeSin), (double)(this.zCoord + thirdVertexDistance * this.longitudeSin + ae2 * this.longitudeCos)).method_1336(this.r, this.g, this.b, 255).method_1344();
        bufferBuilder.method_22912((double)(this.xCoord + ae3 * this.longitudeSin - fourthVertexDistance * this.longitudeCos), (double)(this.yCoord + thirdVertexDistance * this.latitudeSin), (double)(this.zCoord + fourthVertexDistance * this.longitudeSin + ae3 * this.longitudeCos)).method_1336(this.r, this.g, this.b, 255).method_1344();
        bufferBuilder.method_22912((double)(this.xCoord + ae4 * this.longitudeSin - firstVertexDistance * this.longitudeCos), (double)(this.yCoord + fourthVertexDistance * this.latitudeSin), (double)(this.zCoord + firstVertexDistance * this.longitudeSin + ae4 * this.longitudeCos)).method_1336(this.r, this.g, this.b, 255).method_1344();
    }

    public float getCurrentRadius() {
        return this.currentRadius;
    }
}

