/*
 * Decompiled with CFR 0.152.
 */
package dev.ztereohype.nicerskies.sky.nebula;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ztereohype.nicerskies.NicerSkies;
import dev.ztereohype.nicerskies.config.Config;
import dev.ztereohype.nicerskies.sky.nebula.SkyboxPainter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class Skybox {
    public static final int RESOLUTION = 768;
    private final class_1043 skyTexture = new class_1043(3072, 3072, false);
    private final ExecutorService skyExecutor = Executors.newCachedThreadPool();
    private final class_291 skyboxBuffer = new class_291(class_291.class_8555.field_44793);

    public Skybox(SkyboxPainter painter) {
        this.generateVertices();
        this.paint(painter);
    }

    public void render(class_4587 poseStack, Matrix4f projectionMatrix) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (int)this.skyTexture.method_4624());
        float alpha = this.getSkyboxBrightness(class_310.method_1551().field_1687);
        RenderSystem.setShaderColor((float)alpha, (float)alpha, (float)alpha, (float)1.0f);
        this.skyboxBuffer.method_1353();
        this.skyboxBuffer.method_34427(poseStack.method_23760().method_23761(), projectionMatrix, class_757.method_34542());
    }

    public void paint(SkyboxPainter painter) {
        class_1011 skyNativeTex = this.skyTexture.method_4525();
        CountDownLatch latch = new CountDownLatch(PaintTask.TextureLocation.values().length);
        for (PaintTask.TextureLocation location : PaintTask.TextureLocation.values()) {
            this.skyExecutor.execute(new PaintTask(skyNativeTex, painter, location, latch));
        }
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to paint skybox", e);
        }
        this.skyTexture.method_4524();
    }

    private void generateVertices() {
        class_287 skyboxBuilder = class_289.method_1348().method_1349();
        skyboxBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        skyboxBuilder.method_22912(-80.0, -80.0, 80.0).method_22913(0.25f, 0.25f).method_1344();
        skyboxBuilder.method_22912(-80.0, 80.0, 80.0).method_22913(0.25f, 0.5f).method_1344();
        skyboxBuilder.method_22912(80.0, 80.0, 80.0).method_22913(0.5f, 0.5f).method_1344();
        skyboxBuilder.method_22912(80.0, -80.0, 80.0).method_22913(0.5f, 0.25f).method_1344();
        skyboxBuilder.method_22912(-80.0, -80.0, -80.0).method_22913(0.75f, 0.25f).method_1344();
        skyboxBuilder.method_22912(80.0, -80.0, -80.0).method_22913(1.0f, 0.25f).method_1344();
        skyboxBuilder.method_22912(80.0, 80.0, -80.0).method_22913(1.0f, 0.5f).method_1344();
        skyboxBuilder.method_22912(-80.0, 80.0, -80.0).method_22913(0.75f, 0.5f).method_1344();
        skyboxBuilder.method_22912(-80.0, -80.0, -80.0).method_22913(0.5f, 0.5f).method_1344();
        skyboxBuilder.method_22912(-80.0, -80.0, 80.0).method_22913(0.5f, 0.75f).method_1344();
        skyboxBuilder.method_22912(80.0, -80.0, 80.0).method_22913(0.75f, 0.75f).method_1344();
        skyboxBuilder.method_22912(80.0, -80.0, -80.0).method_22913(0.75f, 0.5f).method_1344();
        skyboxBuilder.method_22912(-80.0, 80.0, -80.0).method_22913(0.5f, 0.0f).method_1344();
        skyboxBuilder.method_22912(80.0, 80.0, -80.0).method_22913(0.75f, 0.0f).method_1344();
        skyboxBuilder.method_22912(80.0, 80.0, 80.0).method_22913(0.75f, 0.25f).method_1344();
        skyboxBuilder.method_22912(-80.0, 80.0, 80.0).method_22913(0.5f, 0.25f).method_1344();
        skyboxBuilder.method_22912(80.0, -80.0, -80.0).method_22913(0.5f, 0.25f).method_1344();
        skyboxBuilder.method_22912(80.0, -80.0, 80.0).method_22913(0.75f, 0.25f).method_1344();
        skyboxBuilder.method_22912(80.0, 80.0, 80.0).method_22913(0.75f, 0.5f).method_1344();
        skyboxBuilder.method_22912(80.0, 80.0, -80.0).method_22913(0.5f, 0.5f).method_1344();
        skyboxBuilder.method_22912(-80.0, -80.0, -80.0).method_22913(0.0f, 0.25f).method_1344();
        skyboxBuilder.method_22912(-80.0, 80.0, -80.0).method_22913(0.0f, 0.5f).method_1344();
        skyboxBuilder.method_22912(-80.0, 80.0, 80.0).method_22913(0.25f, 0.5f).method_1344();
        skyboxBuilder.method_22912(-80.0, -80.0, 80.0).method_22913(0.25f, 0.25f).method_1344();
        this.skyboxBuffer.method_1353();
        this.skyboxBuffer.method_1352(skyboxBuilder.method_1326());
    }

    private float getSkyboxBrightness(class_638 level) {
        Config config = NicerSkies.getInstance().getConfig();
        float strength = config.getNebulaStrength();
        boolean renderDuringDay = config.getRenderDuringDay();
        float timeOfDay = level.method_30274(0.0f);
        float nightness = 1.0f - (class_3532.method_15362((float)(timeOfDay * ((float)Math.PI * 2))) * 4.0f + 0.5f);
        nightness = class_3532.method_15363((float)nightness, (float)(renderDuringDay ? 1.0f : 0.0f), (float)1.0f);
        float rain = level.method_8430(0.0f);
        return nightness * (1.0f - rain) * strength;
    }

    public class_291 getSkyboxBuffer() {
        return this.skyboxBuffer;
    }

    private static class PaintTask
    implements Runnable {
        private class_1011 skyNativeTex;
        private SkyboxPainter painter;
        private TextureLocation location;
        private CountDownLatch latch;

        @Override
        public void run() {
            for (int texY = 0; texY < 768; ++texY) {
                for (int texX = 0; texX < 768; ++texX) {
                    float x = this.location.getXFunc().apply(texX, texY).floatValue();
                    float y = this.location.getYFunc().apply(texX, texY).floatValue();
                    float z = this.location.getZFunc().apply(texX, texY).floatValue();
                    this.skyNativeTex.method_4305(this.location.getXLocation(texX), this.location.getYLocation(texY), this.painter.getTexelColour(x, y, z));
                }
            }
            this.latch.countDown();
        }

        public PaintTask(class_1011 skyNativeTex, SkyboxPainter painter, TextureLocation location, CountDownLatch latch) {
            this.skyNativeTex = skyNativeTex;
            this.painter = painter;
            this.location = location;
            this.latch = latch;
        }

        public static enum TextureLocation {
            TOP(CoordMap.X.getMap(), CoordMap.ONE.getMap(), CoordMap.Y.getMap(), 2, 0),
            BOTTOM(CoordMap.X.getMap(), CoordMap.NEG_ONE.getMap(), CoordMap.Y.getMap(), 2, 2),
            POS_Z(CoordMap.X.getMap(), CoordMap.Y.getMap(), CoordMap.ONE.getMap(), 1, 1),
            NEG_Z(CoordMap.X.getMap(), CoordMap.Y.getMap(), CoordMap.NEG_ONE.getMap(), 3, 1),
            POS_X(CoordMap.ONE.getMap(), CoordMap.Y.getMap(), CoordMap.X.getMap(), 2, 1),
            NEG_X(CoordMap.NEG_ONE.getMap(), CoordMap.Y.getMap(), CoordMap.X.getMap(), 0, 1);

            private final BiFunction<Integer, Integer, Float> xFunc;
            private final BiFunction<Integer, Integer, Float> yFunc;
            private final BiFunction<Integer, Integer, Float> zFunc;
            private final int shiftX;
            private final int shiftY;

            public int getXLocation(int texX) {
                return texX + this.shiftX * 768;
            }

            public int getYLocation(int texY) {
                return texY + this.shiftY * 768;
            }

            private TextureLocation(BiFunction<Integer, Integer, Float> xFunc, BiFunction<Integer, Integer, Float> yFunc, BiFunction<Integer, Integer, Float> zFunc, int shiftX, int shiftY) {
                this.xFunc = xFunc;
                this.yFunc = yFunc;
                this.zFunc = zFunc;
                this.shiftX = shiftX;
                this.shiftY = shiftY;
            }

            public BiFunction<Integer, Integer, Float> getXFunc() {
                return this.xFunc;
            }

            public BiFunction<Integer, Integer, Float> getYFunc() {
                return this.yFunc;
            }

            public BiFunction<Integer, Integer, Float> getZFunc() {
                return this.zFunc;
            }
        }

        private static enum CoordMap {
            X((texX, texY) -> Float.valueOf((float)texX.intValue() / 768.0f * 2.0f - 1.0f)),
            Y((texX, texY) -> Float.valueOf((float)texY.intValue() / 768.0f * 2.0f - 1.0f)),
            ONE((texX, texY) -> Float.valueOf(1.0f)),
            NEG_ONE((texX, texY) -> Float.valueOf(-1.0f));

            private final BiFunction<Integer, Integer, Float> map;

            public BiFunction<Integer, Integer, Float> getMap() {
                return this.map;
            }

            private CoordMap(BiFunction<Integer, Integer, Float> map) {
                this.map = map;
            }
        }
    }
}

