/*
 * Decompiled with CFR 0.152.
 */
package dev.ztereohype.nicerskies.sky.nebula;

import dev.ztereohype.nicerskies.core.Gradient;
import dev.ztereohype.nicerskies.sky.nebula.SkyboxPainter;
import net.minecraft.class_3532;
import net.minecraft.class_3537;
import net.minecraft.class_5253;

public class NebulaSkyboxPainter
extends SkyboxPainter {
    private final float scalingFactor;
    private final float noiseAmount;
    private final int baseColourStrength;
    private final Gradient nebulaGradient;

    public NebulaSkyboxPainter(class_3537 noise, Gradient nebulaGradient, float scalingFactor, float noiseAmount, int baseColourStrength) {
        super(noise);
        this.nebulaGradient = nebulaGradient;
        this.scalingFactor = scalingFactor;
        this.noiseAmount = noiseAmount;
        this.baseColourStrength = baseColourStrength;
    }

    @Override
    int getTexelColour(float x, float y, float z) {
        float[] projCoords = this.projectOnSphere(x, y, z);
        x = projCoords[0];
        y = projCoords[1];
        z = projCoords[2];
        float offset = (float)this.noise.method_15416((double)(x * this.scalingFactor * 3.0f), (double)(y * this.scalingFactor * 3.0f), (double)(z * this.scalingFactor * 3.0f));
        x = class_3532.method_15363((float)(x + offset / 5.0f), (float)-1.0f, (float)1.0f);
        y = class_3532.method_15363((float)(y + offset / 5.0f), (float)-1.0f, (float)1.0f);
        z = class_3532.method_15363((float)(z + offset / 5.0f), (float)-1.0f, (float)1.0f);
        double noiseValue = class_3532.method_15350((double)(this.noise.method_15416((double)(x * this.scalingFactor), (double)(y * this.scalingFactor), (double)(z * this.scalingFactor)) + 0.5), (double)0.0, (double)1.0);
        double[] ds = new double[3];
        this.noise.method_16668(0).method_35477((double)(x * this.scalingFactor), (double)(y * this.scalingFactor), (double)(z * this.scalingFactor), ds);
        int baseB = (int)(((double)(x / 2.0f) + 0.5) * (double)this.baseColourStrength);
        int baseG = (int)(((double)(y / 2.0f) + 0.5) * (double)this.baseColourStrength);
        int baseR = (int)(((double)(z / 2.0f) + 0.5) * (double)this.baseColourStrength);
        double nebulaFactor = this.noiseAmount != 0.0f ? class_3532.method_15350((double)(noiseValue * (1.0 / (double)this.noiseAmount) - (1.0 / (double)this.noiseAmount - 1.0)), (double)0.0, (double)0.99) : 0.0;
        int[] nebula = this.nebulaGradient.getAt(nebulaFactor);
        double bgFactor = class_3532.method_15350((double)(Math.log10(-nebulaFactor + 1.0) + 1.0), (double)0.0, (double)1.0);
        int r = class_3532.method_15340((int)((int)(nebulaFactor * (double)nebula[0] - ds[0] * nebulaFactor * 128.0 + (double)baseR * bgFactor)), (int)0, (int)255);
        int g = class_3532.method_15340((int)((int)(nebulaFactor * (double)nebula[1] - ds[1] * nebulaFactor * 64.0 + (double)baseG * bgFactor)), (int)0, (int)255);
        int b = class_3532.method_15340((int)((int)(nebulaFactor * (double)nebula[2] - ds[2] * nebulaFactor * 128.0 + (double)baseB * bgFactor)), (int)0, (int)255);
        int alpha = class_3532.method_15340((int)((int)((1.0 - bgFactor) * 255.0)), (int)50, (int)255);
        return class_5253.class_5254.method_27764((int)alpha, (int)b, (int)g, (int)r);
    }
}

