/*
 * Decompiled with CFR 0.152.
 */
package dev.ztereohype.nicerskies.config;

import com.google.gson.Gson;
import dev.ztereohype.nicerskies.NicerSkies;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class Config {
    public static final ConfigData DEFAULT_CONFIG = new ConfigData(false, true, true, 1.0f, 0.5f, 1.0f, 128, false, false);
    private static final Gson gson = new Gson();
    private final File file;
    private ConfigData configData;

    public static Config fromFile(File file) {
        ConfigData config;
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
                config = DEFAULT_CONFIG.toBuilder().build();
                gson.toJson((Object)config, (Appendable)new FileWriter(file));
            } else {
                config = (ConfigData)gson.fromJson((Reader)new FileReader(file), ConfigData.class);
                if (config == null) {
                    throw new IOException("Failed to read config file");
                }
            }
        }
        catch (IOException e) {
            NicerSkies.LOGGER.warning("Failed to read config file, falling back to default config.");
            e.printStackTrace();
            config = DEFAULT_CONFIG.toBuilder().build();
        }
        return new Config(config, file);
    }

    private Config(ConfigData configData, File file) {
        this.configData = configData;
        this.file = file;
        this.save(file);
    }

    public boolean getLightmapTweaked() {
        return this.configData.isLightmapTweaked();
    }

    public boolean areTwinlkingStarsEnabled() {
        return this.configData.isTwinklingStars();
    }

    public boolean areNebulasEnabled() {
        return this.configData.isRenderNebulas();
    }

    public float getNebulaStrength() {
        return this.configData.getNebulaConfig().getNebulaStrength();
    }

    public float getNebulaNoiseAmount() {
        return this.configData.getNebulaConfig().getNebulaNoiseAmount();
    }

    public float getNebulaNoiseScale() {
        return this.configData.getNebulaConfig().getNebulaNoiseScale();
    }

    public int getNebulaBaseColourAmount() {
        return this.configData.getNebulaConfig().getBaseColourAmount();
    }

    public boolean getRenderDuringDay() {
        return this.configData.getNebulaConfig().isRenderDuringDay();
    }

    public boolean renderInOtherDimensions() {
        return this.configData.isNebulasInOtherDimensions();
    }

    public void updateConfig(ConfigData configData) {
        this.configData = configData.toBuilder().build();
        this.configData.setNebulaConfig(configData.getNebulaConfig().toBuilder().build());
        this.save(this.file);
    }

    public void save(File file) {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(gson.toJson((Object)this.configData));
        }
        catch (IOException e) {
            e.printStackTrace();
            NicerSkies.LOGGER.warning("Failed to save config file!");
        }
    }

    public ConfigData getConfigData() {
        return this.configData;
    }

    public static final class ConfigData {
        private boolean lightmapTweaked;
        private boolean twinklingStars;
        private boolean renderNebulas;
        private boolean nebulasInOtherDimensions;
        private NebulaConfigData nebulaConfig;

        private ConfigData(boolean tweakedLigthmap, boolean twinklingStars, boolean nebulas, float nebulaStrength, float nebulaNoiseAmount, float nebulaNoiseScale, int baseColourAmount, boolean renderDuringDay, boolean renderInOtherDimensions) {
            this.lightmapTweaked = tweakedLigthmap;
            this.twinklingStars = twinklingStars;
            this.renderNebulas = nebulas;
            this.nebulasInOtherDimensions = renderInOtherDimensions;
            this.nebulaConfig = new NebulaConfigData(nebulaStrength, nebulaNoiseAmount, nebulaNoiseScale, baseColourAmount, renderDuringDay);
        }

        public static ConfigDataBuilder builder() {
            return new ConfigDataBuilder();
        }

        public ConfigDataBuilder toBuilder() {
            return new ConfigDataBuilder().lightmapTweaked(this.lightmapTweaked).twinklingStars(this.twinklingStars).renderNebulas(this.renderNebulas).nebulasInOtherDimensions(this.nebulasInOtherDimensions).nebulaConfig(this.nebulaConfig);
        }

        public boolean isLightmapTweaked() {
            return this.lightmapTweaked;
        }

        public boolean isTwinklingStars() {
            return this.twinklingStars;
        }

        public boolean isRenderNebulas() {
            return this.renderNebulas;
        }

        public boolean isNebulasInOtherDimensions() {
            return this.nebulasInOtherDimensions;
        }

        public NebulaConfigData getNebulaConfig() {
            return this.nebulaConfig;
        }

        public void setLightmapTweaked(boolean lightmapTweaked) {
            this.lightmapTweaked = lightmapTweaked;
        }

        public void setTwinklingStars(boolean twinklingStars) {
            this.twinklingStars = twinklingStars;
        }

        public void setRenderNebulas(boolean renderNebulas) {
            this.renderNebulas = renderNebulas;
        }

        public void setNebulasInOtherDimensions(boolean nebulasInOtherDimensions) {
            this.nebulasInOtherDimensions = nebulasInOtherDimensions;
        }

        public void setNebulaConfig(NebulaConfigData nebulaConfig) {
            this.nebulaConfig = nebulaConfig;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigData)) {
                return false;
            }
            ConfigData other = (ConfigData)o;
            if (this.isLightmapTweaked() != other.isLightmapTweaked()) {
                return false;
            }
            if (this.isTwinklingStars() != other.isTwinklingStars()) {
                return false;
            }
            if (this.isRenderNebulas() != other.isRenderNebulas()) {
                return false;
            }
            if (this.isNebulasInOtherDimensions() != other.isNebulasInOtherDimensions()) {
                return false;
            }
            NebulaConfigData this$nebulaConfig = this.getNebulaConfig();
            NebulaConfigData other$nebulaConfig = other.getNebulaConfig();
            return !(this$nebulaConfig == null ? other$nebulaConfig != null : !((Object)this$nebulaConfig).equals(other$nebulaConfig));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLightmapTweaked() ? 79 : 97);
            result = result * 59 + (this.isTwinklingStars() ? 79 : 97);
            result = result * 59 + (this.isRenderNebulas() ? 79 : 97);
            result = result * 59 + (this.isNebulasInOtherDimensions() ? 79 : 97);
            NebulaConfigData $nebulaConfig = this.getNebulaConfig();
            result = result * 59 + ($nebulaConfig == null ? 43 : ((Object)$nebulaConfig).hashCode());
            return result;
        }

        public String toString() {
            return "Config.ConfigData(lightmapTweaked=" + this.isLightmapTweaked() + ", twinklingStars=" + this.isTwinklingStars() + ", renderNebulas=" + this.isRenderNebulas() + ", nebulasInOtherDimensions=" + this.isNebulasInOtherDimensions() + ", nebulaConfig=" + this.getNebulaConfig() + ")";
        }

        public ConfigData(boolean lightmapTweaked, boolean twinklingStars, boolean renderNebulas, boolean nebulasInOtherDimensions, NebulaConfigData nebulaConfig) {
            this.lightmapTweaked = lightmapTweaked;
            this.twinklingStars = twinklingStars;
            this.renderNebulas = renderNebulas;
            this.nebulasInOtherDimensions = nebulasInOtherDimensions;
            this.nebulaConfig = nebulaConfig;
        }

        public static final class NebulaConfigData {
            private float nebulaStrength;
            private float nebulaNoiseAmount;
            private float nebulaNoiseScale;
            private int baseColourAmount;
            private boolean renderDuringDay;

            public static NebulaConfigDataBuilder builder() {
                return new NebulaConfigDataBuilder();
            }

            public NebulaConfigDataBuilder toBuilder() {
                return new NebulaConfigDataBuilder().nebulaStrength(this.nebulaStrength).nebulaNoiseAmount(this.nebulaNoiseAmount).nebulaNoiseScale(this.nebulaNoiseScale).baseColourAmount(this.baseColourAmount).renderDuringDay(this.renderDuringDay);
            }

            public float getNebulaStrength() {
                return this.nebulaStrength;
            }

            public float getNebulaNoiseAmount() {
                return this.nebulaNoiseAmount;
            }

            public float getNebulaNoiseScale() {
                return this.nebulaNoiseScale;
            }

            public int getBaseColourAmount() {
                return this.baseColourAmount;
            }

            public boolean isRenderDuringDay() {
                return this.renderDuringDay;
            }

            public void setNebulaStrength(float nebulaStrength) {
                this.nebulaStrength = nebulaStrength;
            }

            public void setNebulaNoiseAmount(float nebulaNoiseAmount) {
                this.nebulaNoiseAmount = nebulaNoiseAmount;
            }

            public void setNebulaNoiseScale(float nebulaNoiseScale) {
                this.nebulaNoiseScale = nebulaNoiseScale;
            }

            public void setBaseColourAmount(int baseColourAmount) {
                this.baseColourAmount = baseColourAmount;
            }

            public void setRenderDuringDay(boolean renderDuringDay) {
                this.renderDuringDay = renderDuringDay;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NebulaConfigData)) {
                    return false;
                }
                NebulaConfigData other = (NebulaConfigData)o;
                if (Float.compare(this.getNebulaStrength(), other.getNebulaStrength()) != 0) {
                    return false;
                }
                if (Float.compare(this.getNebulaNoiseAmount(), other.getNebulaNoiseAmount()) != 0) {
                    return false;
                }
                if (Float.compare(this.getNebulaNoiseScale(), other.getNebulaNoiseScale()) != 0) {
                    return false;
                }
                if (this.getBaseColourAmount() != other.getBaseColourAmount()) {
                    return false;
                }
                return this.isRenderDuringDay() == other.isRenderDuringDay();
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + Float.floatToIntBits(this.getNebulaStrength());
                result = result * 59 + Float.floatToIntBits(this.getNebulaNoiseAmount());
                result = result * 59 + Float.floatToIntBits(this.getNebulaNoiseScale());
                result = result * 59 + this.getBaseColourAmount();
                result = result * 59 + (this.isRenderDuringDay() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "Config.ConfigData.NebulaConfigData(nebulaStrength=" + this.getNebulaStrength() + ", nebulaNoiseAmount=" + this.getNebulaNoiseAmount() + ", nebulaNoiseScale=" + this.getNebulaNoiseScale() + ", baseColourAmount=" + this.getBaseColourAmount() + ", renderDuringDay=" + this.isRenderDuringDay() + ")";
            }

            public NebulaConfigData(float nebulaStrength, float nebulaNoiseAmount, float nebulaNoiseScale, int baseColourAmount, boolean renderDuringDay) {
                this.nebulaStrength = nebulaStrength;
                this.nebulaNoiseAmount = nebulaNoiseAmount;
                this.nebulaNoiseScale = nebulaNoiseScale;
                this.baseColourAmount = baseColourAmount;
                this.renderDuringDay = renderDuringDay;
            }

            public static class NebulaConfigDataBuilder {
                private float nebulaStrength;
                private float nebulaNoiseAmount;
                private float nebulaNoiseScale;
                private int baseColourAmount;
                private boolean renderDuringDay;

                NebulaConfigDataBuilder() {
                }

                public NebulaConfigDataBuilder nebulaStrength(float nebulaStrength) {
                    this.nebulaStrength = nebulaStrength;
                    return this;
                }

                public NebulaConfigDataBuilder nebulaNoiseAmount(float nebulaNoiseAmount) {
                    this.nebulaNoiseAmount = nebulaNoiseAmount;
                    return this;
                }

                public NebulaConfigDataBuilder nebulaNoiseScale(float nebulaNoiseScale) {
                    this.nebulaNoiseScale = nebulaNoiseScale;
                    return this;
                }

                public NebulaConfigDataBuilder baseColourAmount(int baseColourAmount) {
                    this.baseColourAmount = baseColourAmount;
                    return this;
                }

                public NebulaConfigDataBuilder renderDuringDay(boolean renderDuringDay) {
                    this.renderDuringDay = renderDuringDay;
                    return this;
                }

                public NebulaConfigData build() {
                    return new NebulaConfigData(this.nebulaStrength, this.nebulaNoiseAmount, this.nebulaNoiseScale, this.baseColourAmount, this.renderDuringDay);
                }

                public String toString() {
                    return "Config.ConfigData.NebulaConfigData.NebulaConfigDataBuilder(nebulaStrength=" + this.nebulaStrength + ", nebulaNoiseAmount=" + this.nebulaNoiseAmount + ", nebulaNoiseScale=" + this.nebulaNoiseScale + ", baseColourAmount=" + this.baseColourAmount + ", renderDuringDay=" + this.renderDuringDay + ")";
                }
            }
        }

        public static class ConfigDataBuilder {
            private boolean lightmapTweaked;
            private boolean twinklingStars;
            private boolean renderNebulas;
            private boolean nebulasInOtherDimensions;
            private NebulaConfigData nebulaConfig;

            ConfigDataBuilder() {
            }

            public ConfigDataBuilder lightmapTweaked(boolean lightmapTweaked) {
                this.lightmapTweaked = lightmapTweaked;
                return this;
            }

            public ConfigDataBuilder twinklingStars(boolean twinklingStars) {
                this.twinklingStars = twinklingStars;
                return this;
            }

            public ConfigDataBuilder renderNebulas(boolean renderNebulas) {
                this.renderNebulas = renderNebulas;
                return this;
            }

            public ConfigDataBuilder nebulasInOtherDimensions(boolean nebulasInOtherDimensions) {
                this.nebulasInOtherDimensions = nebulasInOtherDimensions;
                return this;
            }

            public ConfigDataBuilder nebulaConfig(NebulaConfigData nebulaConfig) {
                this.nebulaConfig = nebulaConfig;
                return this;
            }

            public ConfigData build() {
                return new ConfigData(this.lightmapTweaked, this.twinklingStars, this.renderNebulas, this.nebulasInOtherDimensions, this.nebulaConfig);
            }

            public String toString() {
                return "Config.ConfigData.ConfigDataBuilder(lightmapTweaked=" + this.lightmapTweaked + ", twinklingStars=" + this.twinklingStars + ", renderNebulas=" + this.renderNebulas + ", nebulasInOtherDimensions=" + this.nebulasInOtherDimensions + ", nebulaConfig=" + this.nebulaConfig + ")";
            }
        }
    }
}

