/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.mixin.tick;

import forge.me.thosea.badoptimizations.interfaces.BiomeSkyColorGetter;
import forge.me.thosea.badoptimizations.other.Config;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientWorld
extends Level {
    @Shadow
    @Final
    private Minecraft f_104565_;
    @Unique
    private BiomeSkyColorGetter biomeColors;
    @Unique
    private Vec3 skyColorCache;
    @Unique
    private int lastTick;
    @Unique
    private long previousTime;
    @Unique
    private int previousBiomeColor;
    @Unique
    private Vec3 biomeColorVector;
    @Unique
    private float previousRainGradient;
    @Unique
    private float rainGradientMultiplier;
    @Unique
    private float previousThunderGradient;
    @Unique
    private float thunderGradientMultiplier;
    @Unique
    private int previousLightningTicks;

    @Inject(method={"getSkyColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetColorHead(Vec3 cameraPos, float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        if (this.skyColorCache == null) {
            return;
        }
        int tick = this.f_104565_.f_91074_.f_19797_;
        if (this.lastTick != tick) {
            int lightningTicks;
            float thunderGradient;
            this.lastTick = tick;
            boolean doMiniUpdate = false;
            float rainGradient = this.f_46438_;
            if (this.previousRainGradient != rainGradient) {
                this.previousRainGradient = rainGradient;
                doMiniUpdate = true;
                if (rainGradient > 0.0f) {
                    this.rainGradientMultiplier = 1.0f - rainGradient * 0.75f;
                }
            }
            if (this.previousThunderGradient != (thunderGradient = this.f_46440_)) {
                this.previousThunderGradient = thunderGradient;
                doMiniUpdate = true;
                if (thunderGradient > 0.0f) {
                    this.thunderGradientMultiplier = 1.0f - thunderGradient * 0.75f;
                }
            }
            if (this.previousLightningTicks != (lightningTicks = this.m_104819_())) {
                doMiniUpdate = true;
                this.previousLightningTicks = lightningTicks;
            }
            if (this.isBiomeDirty(cameraPos.m_82492_(2.0, 2.0, 2.0).m_82490_(0.25))) {
                return;
            }
            long time = this.m_46468_();
            if (doMiniUpdate || Math.abs(time - this.previousTime) >= (long)Config.skycolor_time_change_needed_for_update) {
                this.previousTime = time;
                this.calcSkyColor(tickDelta);
            }
        }
        cir.setReturnValue((Object)this.skyColorCache);
    }

    @Unique
    private boolean isBiomeDirty(Vec3 pos) {
        int z;
        int y;
        int x = Mth.m_14107_((double)pos.f_82479_);
        int color = this.biomeColors.get(x, y = Mth.m_14107_((double)pos.f_82480_), z = Mth.m_14107_((double)pos.f_82481_));
        if (this.previousBiomeColor != color) {
            this.previousBiomeColor = color;
            this.biomeColorVector = Vec3.m_82501_((int)color).m_82490_(4096.0);
            return true;
        }
        return this.biomeColors.get(x - 2, y - 2, z - 2) != color || this.biomeColors.get(x + 3, y + 3, z + 3) != color;
    }

    @Shadow
    public abstract int m_104819_();

    @Shadow
    public abstract Vec3 m_171660_(Vec3 var1, float var2);

    @Unique
    private void calcSkyColor(float delta) {
        double color;
        float angle = Mth.m_14089_((float)(this.m_46942_(1.0f) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        angle = Mth.m_14036_((float)angle, (float)0.0f, (float)1.0f);
        double multiplier = 2.44140625E-4 * (double)angle;
        double x = this.biomeColorVector.f_82479_ * multiplier;
        double y = this.biomeColorVector.f_82480_ * multiplier;
        double z = this.biomeColorVector.f_82481_ * multiplier;
        if (this.f_46438_ > 0.0f) {
            color = (x * (double)0.3f + y * (double)0.59f + z * (double)0.11f) * (double)0.6f;
            x = x * (double)this.rainGradientMultiplier + color * (1.0 - (double)this.rainGradientMultiplier);
            y = y * (double)this.rainGradientMultiplier + color * (1.0 - (double)this.rainGradientMultiplier);
            z = z * (double)this.rainGradientMultiplier + color * (1.0 - (double)this.rainGradientMultiplier);
        }
        if (this.f_46440_ > 0.0f) {
            color = (x * (double)0.3f + y * (double)0.59f + z * (double)0.11f) * (double)0.2f;
            x = x * (double)this.thunderGradientMultiplier + color * (1.0 - (double)this.thunderGradientMultiplier);
            y = y * (double)this.thunderGradientMultiplier + color * (1.0 - (double)this.thunderGradientMultiplier);
            z = z * (double)this.thunderGradientMultiplier + color * (1.0 - (double)this.thunderGradientMultiplier);
        }
        if (this.previousLightningTicks > 0) {
            float lightningMultiplier = (float)this.previousLightningTicks - delta;
            if (lightningMultiplier > 1.0f) {
                lightningMultiplier = 1.0f;
            }
            x = x * (double)(1.0f - (lightningMultiplier *= 0.45f)) + (double)(0.8f * lightningMultiplier);
            y = y * (double)(1.0f - lightningMultiplier) + (double)(0.8f * lightningMultiplier);
            z = z * (double)(1.0f - lightningMultiplier) + (double)lightningMultiplier;
        }
        this.skyColorCache = new Vec3(x, y, z);
    }

    @Inject(method={"getSkyColor"}, at={@At(value="RETURN")})
    private void onGetColorTail(Vec3 cameraPos, float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        this.skyColorCache = (Vec3)cir.getReturnValue();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void afterInit(CallbackInfo ci) {
        this.lastTick = -1;
        this.previousBiomeColor = Integer.MIN_VALUE;
        this.biomeColorVector = Vec3.f_82478_;
        this.biomeColors = BiomeSkyColorGetter.of(this.m_7062_());
    }

    protected MixinClientWorld(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
        throw new AssertionError((Object)"nuh uh");
    }
}

