/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.experimentalperformance.utils.asm;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.util.Bytecode;

public class AsmUtils {
    public static void removeFieldsContaining(String className, List<FieldNode> fields, List<String> removeFields) {
        Iterator<FieldNode> each = fields.iterator();
        while (each.hasNext()) {
            String fieldName = each.next().name;
            if (!removeFields.contains(fieldName)) continue;
            each.remove();
            System.out.println("Removed `" + fieldName + "` from `" + className + "`");
        }
    }

    public static FieldNode generateInfoHolderField(String holderClassName) {
        return new FieldNode(18, "infoHolder", "L" + holderClassName + ";", null, null);
    }

    public static void redirectFieldsToInfoHolder(List<MethodNode> methods, String superClass, String targetClass, String holderClass, List<String> redirectFields) {
        boolean hasInjectedInfoHolder = false;
        for (MethodNode methodNode : methods) {
            ListIterator it = methodNode.instructions.iterator();
            block1: while (it.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)it.next();
                if (!(insn instanceof FieldInsnNode)) continue;
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                if (!fieldInsn.owner.equals(targetClass)) continue;
                for (String name : redirectFields) {
                    if (!fieldInsn.name.equals(name)) continue;
                    it.remove();
                    if (fieldInsn.getOpcode() == 180) {
                        AsmUtils.replaceFieldGet(it, fieldInsn, name, holderClass);
                        continue block1;
                    }
                    AsmUtils.replaceFieldSet(it, fieldInsn, name, holderClass);
                    continue block1;
                }
            }
            if (hasInjectedInfoHolder || !methodNode.name.equals("<cinit>") && !methodNode.name.equals("<init>")) continue;
            hasInjectedInfoHolder = true;
            Bytecode.DelegateInitialiser delegateInit = Bytecode.findDelegateInit((MethodNode)methodNode, (String)superClass, (String)targetClass);
            InsnList injectInfoHolder = new InsnList();
            injectInfoHolder.add((AbstractInsnNode)new VarInsnNode(25, 0));
            injectInfoHolder.add((AbstractInsnNode)new TypeInsnNode(187, holderClass));
            injectInfoHolder.add((AbstractInsnNode)new InsnNode(89));
            injectInfoHolder.add((AbstractInsnNode)new MethodInsnNode(183, holderClass, "<init>", "()V"));
            injectInfoHolder.add((AbstractInsnNode)new FieldInsnNode(181, targetClass, "infoHolder", "L" + holderClass + ";"));
            if (delegateInit.isPresent) {
                methodNode.instructions.insert((AbstractInsnNode)delegateInit.insn, injectInfoHolder);
                continue;
            }
            methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), injectInfoHolder);
        }
    }

    private static void replaceFieldGet(ListIterator<AbstractInsnNode> it, FieldInsnNode fieldInsn, String newFieldName, String holderClassName) {
        it.add((AbstractInsnNode)new FieldInsnNode(180, fieldInsn.owner, "infoHolder", "L" + holderClassName + ";"));
        it.add((AbstractInsnNode)new FieldInsnNode(180, holderClassName, newFieldName, fieldInsn.desc));
    }

    private static void replaceFieldSet(ListIterator<AbstractInsnNode> it, FieldInsnNode fieldInsn, String newFieldName, String holderClassName) {
        int size = Type.getType((String)fieldInsn.desc).getSize();
        if (size == 2) {
            it.add((AbstractInsnNode)new InsnNode(93));
            it.add((AbstractInsnNode)new InsnNode(88));
        } else {
            it.add((AbstractInsnNode)new InsnNode(95));
        }
        it.add((AbstractInsnNode)new FieldInsnNode(180, fieldInsn.owner, "infoHolder", "L" + holderClassName + ";"));
        if (size == 2) {
            it.add((AbstractInsnNode)new InsnNode(91));
            it.add((AbstractInsnNode)new InsnNode(87));
        } else {
            it.add((AbstractInsnNode)new InsnNode(95));
        }
        it.add((AbstractInsnNode)new FieldInsnNode(181, holderClassName, newFieldName, fieldInsn.desc));
    }
}

