/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.experimentalperformance.utils;

import java.util.List;
import java.util.Objects;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Textifier;

public class NodeUtils {
    public static void printMethod(List<MethodNode> methods) {
        for (int i = 0; i < methods.size(); ++i) {
            MethodNode methodNode = methods.get(i);
            System.out.println(i + ") name: " + methodNode.name + " - parameterCount: " + (methodNode.parameters == null ? 0 : methodNode.parameters.size()) + " - instructionCount: " + methodNode.instructions.size());
        }
    }

    public static void printInstructions(InsnList instructions) {
        NodeUtils.printInstructions(instructions, true);
    }

    public static void printInstructions(InsnList instructions, boolean numbered) {
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instructionNode = instructions.get(i);
            if (numbered) {
                System.out.printf("%3d) %s%n", i, NodeUtils.instructionToString(instructionNode));
                continue;
            }
            System.out.println(NodeUtils.instructionToString(instructionNode));
        }
    }

    public static String getOpcodeString(int opcode) {
        return opcode == -1 ? "" : Textifier.OPCODES[opcode];
    }

    public static String getTypeString(int type) {
        return switch (type) {
            case 0 -> "INSN";
            case 1 -> "INT_INSN";
            case 2 -> "VAR_INSN";
            case 3 -> "TYPE_INSN";
            case 4 -> "FIELD_INSN";
            case 5 -> "METHOD_INSN";
            case 6 -> "INVOKE_DYNAMIC_INSN";
            case 7 -> "JUMP_INSN";
            case 8 -> "LABEL";
            case 9 -> "LDC_INSN";
            case 10 -> "IINC_INSN";
            case 11 -> "TABLESWITCH_INSN";
            case 12 -> "LOOKUPSWITCH_INSN";
            case 13 -> "MULTIANEWARRAY_INSN";
            case 14 -> "FRAME";
            case 15 -> "LINE";
            default -> throw new IllegalStateException("Unexpected type: " + type);
        };
    }

    public static String instructionToString(AbstractInsnNode insn) {
        int type = insn.getType();
        String data = switch (type) {
            case 0 -> "";
            case 1 -> String.valueOf(((IntInsnNode)insn).operand);
            case 2 -> String.valueOf(((VarInsnNode)insn).var);
            case 3 -> ((TypeInsnNode)insn).desc;
            case 4 -> ((FieldInsnNode)insn).owner + " " + ((FieldInsnNode)insn).name + " " + ((FieldInsnNode)insn).desc;
            case 5 -> ((MethodInsnNode)insn).owner + " " + ((MethodInsnNode)insn).name + " " + ((MethodInsnNode)insn).desc + " " + ((MethodInsnNode)insn).itf;
            case 6 -> ((InvokeDynamicInsnNode)insn).name + " " + ((InvokeDynamicInsnNode)insn).desc;
            case 7 -> ((JumpInsnNode)insn).label.getLabel().toString();
            case 8 -> ((LabelNode)insn).getLabel().toString();
            case 9 -> "<stuff>";
            case 10 -> ((IincInsnNode)insn).var + " " + ((IincInsnNode)insn).incr;
            case 11 -> ((TableSwitchInsnNode)insn).min + " " + ((TableSwitchInsnNode)insn).max + " " + ((TableSwitchInsnNode)insn).dflt.getLabel().toString();
            case 12 -> "";
            case 13 -> ((MultiANewArrayInsnNode)insn).desc + " " + ((MultiANewArrayInsnNode)insn).dims;
            case 14 -> "FRAME";
            case 15 -> ((LineNumberNode)insn).start.getLabel().toString();
            default -> throw new IllegalStateException("Unexpected type: " + type);
        };
        String opcode = NodeUtils.getOpcodeString(insn.getOpcode());
        return (type == 15 ? "" : "  ") + (String)(Objects.equals(opcode, "") ? "" : opcode + " ") + (String)(Objects.equals(data, "") ? "" : data + " ");
    }
}

