/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.experimentalperformance.memoryDensity.analysis;

import ca.fxco.experimentalperformance.memoryDensity.analysis.ClassAnalysis;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.datamodel.Model32;
import org.openjdk.jol.datamodel.Model64;
import org.openjdk.jol.layouters.CurrentLayouter;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.layouters.Layouter;
import org.openjdk.jol.layouters.RawLayouter;

public class ClassAnalysisManager {
    private final Layouter[] layouts;
    private final List<Future<ClassAnalysis.AnalysisResults>> futureAnalysisResults = new ArrayList<Future<ClassAnalysis.AnalysisResults>>();

    public ClassAnalysisManager(boolean attemptAllLayouts) {
        Layouter[] layouterArray;
        if (attemptAllLayouts) {
            Layouter[] layouterArray2 = new Layouter[13];
            layouterArray2[0] = new RawLayouter((DataModel)new Model32());
            layouterArray2[1] = new RawLayouter((DataModel)new Model64(false, false));
            layouterArray2[2] = new RawLayouter((DataModel)new Model64(true, true));
            layouterArray2[3] = new HotSpotLayouter((DataModel)new Model32(), 8);
            layouterArray2[4] = new HotSpotLayouter((DataModel)new Model64(false, false), 8);
            layouterArray2[5] = new HotSpotLayouter((DataModel)new Model64(true, true), 8);
            layouterArray2[6] = new HotSpotLayouter((DataModel)new Model64(true, true, 16), 8);
            layouterArray2[7] = new HotSpotLayouter((DataModel)new Model32(), 15);
            layouterArray2[8] = new HotSpotLayouter((DataModel)new Model64(false, false), 15);
            layouterArray2[9] = new HotSpotLayouter((DataModel)new Model64(true, true), 15);
            layouterArray2[10] = new HotSpotLayouter((DataModel)new Model64(true, true, 16), 15);
            layouterArray2[11] = new HotSpotLayouter((DataModel)new Model64(false, true), 15);
            layouterArray = layouterArray2;
            layouterArray2[12] = new HotSpotLayouter((DataModel)new Model64(false, true, 16), 15);
        } else {
            Layouter[] layouterArray3 = new Layouter[1];
            layouterArray = layouterArray3;
            layouterArray3[0] = new CurrentLayouter();
        }
        this.layouts = layouterArray;
    }

    public void runSingleAnalysis(Class<?> clazz) {
        for (Layouter model : this.layouts) {
            this.futureAnalysisResults.add(new ClassAnalysis(clazz, model).runAnalysis());
        }
    }

    public void printResults() {
        try {
            System.out.println("ClassAnalysisManager - Total: " + this.futureAnalysisResults.size());
            for (Future<ClassAnalysis.AnalysisResults> task : this.futureAnalysisResults) {
                ClassAnalysis.AnalysisResults analysisResults = task.get();
                System.out.println(analysisResults.toString());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    public void printResults(ResultConditions conditions) {
        System.out.println("ClassAnalysisManager - Total: " + this.futureAnalysisResults.size());
        int count = 0;
        int fails = 0;
        for (Future<ClassAnalysis.AnalysisResults> task : this.futureAnalysisResults) {
            try {
                ClassAnalysis.AnalysisResults results = task.get();
                if (results.getSize() < conditions.minSize || results.getSize() > conditions.maxSize || results.getPrivateSize() < conditions.minPrivateSize || results.getPrivateSize() > conditions.maxPrivateSize) continue;
                System.out.println(results);
                ++count;
            }
            catch (InterruptedException | ExecutionException e) {
                ++fails;
            }
        }
        System.out.println("Total Shown: " + count + " - Total Fails: " + fails);
    }

    public void simulateResults() {
        try {
            for (Future<ClassAnalysis.AnalysisResults> task : this.futureAnalysisResults) {
                task.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static class ResultConditions {
        public final long minSize;
        public final long maxSize;
        public final long minPrivateSize;
        public final long maxPrivateSize;

        public ResultConditions(long minSize) {
            this(minSize, Long.MAX_VALUE);
        }

        public ResultConditions(long minSize, long maxSize) {
            this(minSize, maxSize, 0L);
        }

        public ResultConditions(long minSize, long maxSize, long minPrivateSize) {
            this(minSize, maxSize, minPrivateSize, Long.MAX_VALUE);
        }

        public ResultConditions(long minSize, long maxSize, long minPrivateSize, long maxPrivateSize) {
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.minPrivateSize = minPrivateSize;
            this.maxPrivateSize = maxPrivateSize;
        }
    }
}

