/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.experimentalperformance.memoryDensity.analysis;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.info.FieldData;
import org.openjdk.jol.layouters.Layouter;

public class ClassAnalysis {
    private final Class<?> clazz;
    private final Layouter layouter;

    public ClassAnalysis(Class<?> clazz, Layouter layouter) {
        this.clazz = clazz;
        this.layouter = layouter;
    }

    private static ClassData createClassDataFromClass(@NotNull Class<?> clazz, boolean privateOnly) {
        String clazzName = clazz.getName();
        ClassData classData = new ClassData(clazzName);
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && !clazz.equals(superClazz)) {
            classData.addSuperClassData(ClassAnalysis.createClassDataFromClass(superClazz, privateOnly));
        }
        do {
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || privateOnly && !Modifier.isPrivate(modifiers)) continue;
                classData.addField(FieldData.parse((Field)field));
            }
            classData.addSuperClass(clazz.getName());
        } while ((clazz = clazz.getSuperclass()) != null);
        return classData;
    }

    public Future<AnalysisResults> runAnalysis() {
        return CompletableFuture.supplyAsync(() -> {
            ClassLayout classLayout = this.layouter.layout(ClassAnalysis.createClassDataFromClass(this.clazz, false));
            ClassLayout privateClassLayout = this.layouter.layout(ClassAnalysis.createClassDataFromClass(this.clazz, true));
            return new AnalysisResults(classLayout, privateClassLayout);
        });
    }

    public String toString() {
        return this.clazz.getName();
    }

    class AnalysisResults {
        private final ClassLayout classLayout;
        private final ClassLayout privateClassLayout;
        private final boolean canOptimize;

        public AnalysisResults(ClassLayout classLayout, ClassLayout privateClassLayout) {
            this.classLayout = classLayout;
            this.privateClassLayout = privateClassLayout;
            long totalSize = classLayout.instanceSize();
            this.canOptimize = totalSize > 64L && privateClassLayout.instanceSize() >= totalSize % 64L;
        }

        public long getSize() {
            return this.classLayout.instanceSize();
        }

        public long getPrivateSize() {
            return this.privateClassLayout.instanceSize();
        }

        public long getHeaderSize() {
            return this.classLayout.headerSize();
        }

        public long getPrivateHeaderSize() {
            return this.privateClassLayout.headerSize();
        }

        public int getFieldCount() {
            return this.classLayout.fields().size();
        }

        public int getPrivateFieldCount() {
            return this.privateClassLayout.fields().size();
        }

        public boolean canOptimize() {
            return this.canOptimize;
        }

        public String toString() {
            return String.format("Size: %4d - %s", this.getSize() - this.getHeaderSize(), ClassAnalysis.this);
        }
    }
}

