/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.experimentalperformance.memoryDensity;

import ca.fxco.experimentalperformance.ExperimentalPerformance;
import ca.fxco.experimentalperformance.config.TransformationManager;
import ca.fxco.experimentalperformance.memoryDensity.infoHolders.InfoHolderGenerator;
import ca.fxco.experimentalperformance.utils.GeneralUtils;
import ca.fxco.experimentalperformance.utils.asm.AsmUtils;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;

public class InfoHolderData {
    private static final String INFOHOLDER_PATH = "ca/fxco/experimentalperformance/memoryDensity/infoHolders/";
    private final String targetClassName;
    private final List<String> redirectFields;
    private final String modId;
    private final String versionPredicate;
    private final boolean defaultValue;

    public InfoHolderData(String targetClassName, List<String> redirectFields) {
        this(targetClassName, redirectFields, "*");
    }

    public InfoHolderData(String targetClassName, List<String> redirectFields, String versionPredicate) {
        this(targetClassName, redirectFields, versionPredicate, "minecraft");
    }

    public InfoHolderData(String targetClassName, List<String> redirectFields, String versionPredicate, String modId) {
        this(targetClassName, redirectFields, versionPredicate, modId, true);
    }

    public InfoHolderData(String targetClassName, List<String> redirectFields, String versionPredicate, String modId, boolean defaultValue) {
        if (redirectFields.size() == 0) {
            throw new IllegalArgumentException("`redirectFields` must have at least 1 field to redirect!");
        }
        if (redirectFields.size() == 1) {
            ExperimentalPerformance.LOGGER.warn("`redirectFields` should have more than 1 field to redirect.");
        }
        this.targetClassName = targetClassName;
        this.redirectFields = redirectFields;
        this.modId = modId;
        this.versionPredicate = versionPredicate;
        this.defaultValue = defaultValue;
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public String getModId() {
        return this.modId;
    }

    public String getVersionPredicate() {
        return this.versionPredicate;
    }

    public boolean shouldLoad() {
        return true;
    }

    public void apply(String holderId, TransformationManager transformationManager) {
        if (!this.shouldLoad()) {
            return;
        }
        transformationManager.addPostTransformer(this.targetClassName, node -> {
            String generatedHolderClassName = (INFOHOLDER_PATH + holderId + "InfoHolder").replace(".", "_");
            System.out.println(generatedHolderClassName);
            String className = GeneralUtils.getLastPathPart(this.targetClassName);
            InfoHolderGenerator generator = new InfoHolderGenerator();
            generator.createInfoHolder((ClassNode)node, generatedHolderClassName, this.redirectFields);
            AsmUtils.removeFieldsContaining(className, node.fields, this.redirectFields);
            node.fields.add(AsmUtils.generateInfoHolderField(generatedHolderClassName));
            AsmUtils.redirectFieldsToInfoHolder(node.methods, node.superName, this.targetClassName, generatedHolderClassName, this.redirectFields);
        });
    }
}

