/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.experimentalperformance.config;

import ca.fxco.experimentalperformance.ExperimentalPerformance;
import ca.fxco.experimentalperformance.utils.GeneralUtils;
import ca.fxco.experimentalperformance.utils.asm.FakeMixinStreamHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionClassExporter;

public class TransformationManager {
    private static final String MIXIN_ANNOTATION_DESCRIPTOR = "Lorg/spongepowered/asm/mixin/Mixin;";
    private final Map<String, Set<Consumer<ClassNode>>> preTransformers = new HashMap<String, Set<Consumer<ClassNode>>>();
    private final Map<String, Set<Consumer<ClassNode>>> postTransformers = new HashMap<String, Set<Consumer<ClassNode>>>();
    private final Map<String, byte[]> mixinClassModifiers = new HashMap<String, byte[]>();
    private final Set<String> loadAsMixins = new HashSet<String>();
    private final String mixinPackage;
    private final Consumer<URL> urlParser;

    public TransformationManager(String mixinPackage) {
        mixinPackage = GeneralUtils.formatPathSlash((String)mixinPackage);
        if (!((String)mixinPackage).endsWith("/")) {
            mixinPackage = (String)mixinPackage + "/";
        }
        this.mixinPackage = mixinPackage;
        this.urlParser = this.getAddURLMethod();
    }

    public void onLoad() {
        try {
            this.urlParser.accept(FakeMixinStreamHandler.createURL(this.mixinClassModifiers));
        }
        catch (MalformedURLException e) {
            ExperimentalPerformance.LOGGER.error("MalformedURL used for Mixin UrlParser", (Throwable)e);
        }
        ExtensionClassExporter extensionClassExporter = TransformationManager.getExtension(ExtensionClassExporter.class);
        FakeMixinStreamHandler.sign = (name, bytes) -> {
            ClassNode node = new ClassNode();
            new ClassReader(bytes).accept((ClassVisitor)node, 8);
            extensionClassExporter.export(MixinEnvironment.getCurrentEnvironment(), name, false, node);
        };
    }

    public String getMixinPackage() {
        return this.mixinPackage;
    }

    public void addPreTransformer(String className, Consumer<ClassNode> consumer) {
        className = GeneralUtils.formatPathSlash(className);
        this.addMixinClass(className);
        this.preTransformers.computeIfAbsent(className, n -> new HashSet()).add(consumer);
    }

    public void addPostTransformer(String className, Consumer<ClassNode> consumer) {
        className = GeneralUtils.formatPathSlash(className);
        this.addMixinClass(className);
        this.postTransformers.computeIfAbsent(className, n -> new HashSet()).add(consumer);
    }

    private void addMixinClass(String className) {
        this.loadAsMixins.add(GeneralUtils.formatPathDot(className));
        String fullName = this.mixinPackage + className;
        ExperimentalPerformance.LOGGER.info("Generating " + fullName + " with target " + className);
        this.mixinClassModifiers.put("/" + fullName + ".class", TransformationManager.makeMixinBlob(fullName, className));
    }

    public List<String> onGetMixins() {
        return new ArrayList<String>(this.loadAsMixins);
    }

    public void onPreApply(String targetClassName, ClassNode targetClass, String mixinClassName) {
        Set<Consumer<ClassNode>> classChanges = this.preTransformers.get(GeneralUtils.formatPathSlash(targetClassName));
        if (classChanges == null) {
            return;
        }
        for (Consumer<ClassNode> changes : classChanges) {
            changes.accept(targetClass);
        }
    }

    public void onPostApply(String targetClassName, ClassNode targetClass, String mixinClassName) {
        Set<Consumer<ClassNode>> classChanges = this.postTransformers.get(GeneralUtils.formatPathSlash(targetClassName));
        if (classChanges == null) {
            return;
        }
        for (Consumer<ClassNode> changes : classChanges) {
            changes.accept(targetClass);
        }
        targetClass.interfaces.remove(GeneralUtils.formatPathSlash(mixinClassName));
    }

    private Consumer<URL> getAddURLMethod() {
        ClassLoader classLoader = TransformationManager.class.getClassLoader();
        for (Method addUrlMethod : classLoader.getClass().getDeclaredMethods()) {
            if (addUrlMethod.getReturnType() != Void.TYPE || addUrlMethod.getParameterCount() != 1 || addUrlMethod.getParameterTypes()[0] != URL.class) continue;
            try {
                addUrlMethod.setAccessible(true);
                MethodHandle handle = MethodHandles.lookup().unreflect(addUrlMethod);
                return url -> {
                    try {
                        handle.invoke(classLoader, (URL)url);
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Unknown error while attempting to invoke Url handle", t);
                    }
                };
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to find handle for " + addUrlMethod, e);
            }
        }
        throw new IllegalStateException("Unable to find addUrl method in " + classLoader);
    }

    private static byte[] makeMixinBlob(String name, String targetClassName) {
        ClassWriter writer = new ClassWriter(0);
        writer.visit(61, 1537, name, null, "java/lang/Object", null);
        AnnotationVisitor mixinAnnotation = writer.visitAnnotation(MIXIN_ANNOTATION_DESCRIPTOR, false);
        AnnotationVisitor valueAnnotation = mixinAnnotation.visitArray("value");
        valueAnnotation.visit(null, (Object)GeneralUtils.asType(targetClassName));
        valueAnnotation.visitEnd();
        mixinAnnotation.visit("priority", (Object)50000);
        mixinAnnotation.visitEnd();
        writer.visitEnd();
        return writer.toByteArray();
    }

    private static <T extends IExtension> T getExtension(Class<T> extensionClass) {
        Object transformer = MixinEnvironment.getCurrentEnvironment().getActiveTransformer();
        if (transformer == null) {
            throw new IllegalStateException("No transformer was found for current Mixin environment");
        }
        try {
            for (Field field : transformer.getClass().getDeclaredFields()) {
                if (!field.getType().equals(Extensions.class)) continue;
                field.setAccessible(true);
                return (T)((Extensions)field.get(transformer)).getExtension(extensionClass);
            }
            throw new NoSuchFieldError("Unable to find extensions field for current Mixin environment transformer!");
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Critical error happened while attempting to get extension", e);
        }
    }
}

