/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.experimentalperformance.config;

import ca.fxco.experimentalperformance.ExperimentalPerformance;
import ca.fxco.experimentalperformance.config.TransformationManager;
import ca.fxco.experimentalperformance.memoryDensity.HolderDataRegistry;
import ca.fxco.experimentalperformance.memoryDensity.HolderPatcher;
import ca.fxco.experimentalperformance.memoryDensity.InfoHolderData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class SimpleConfigMixinPlugin
implements IMixinConfigPlugin {
    private static TransformationManager transformationManager;

    public void onLoad(String mixinPackage) {
        transformationManager = new TransformationManager(mixinPackage);
        ExperimentalPerformance.CONFIG.parseConfig();
        HashMap<String, InfoHolderData> allInfoHolderData = new HashMap<String, InfoHolderData>();
        HolderPatcher.attemptToAddHolders(allInfoHolderData, HolderDataRegistry.infoHolderDataMap);
        HolderPatcher.attemptToAddVersionedHolders(allInfoHolderData, HolderDataRegistry.versionedInfoHolderDataMap);
        for (Map.Entry entry : allInfoHolderData.entrySet()) {
            if (!ExperimentalPerformance.CONFIG.shouldLoad((String)entry.getKey())) continue;
            ((InfoHolderData)entry.getValue()).apply((String)entry.getKey(), transformationManager);
        }
        transformationManager.onLoad();
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return transformationManager.onGetMixins();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        transformationManager.onPreApply(targetClassName, targetClass, mixinClassName);
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        transformationManager.onPostApply(targetClassName, targetClass, mixinClassName);
    }
}

