/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.experimentalperformance.config;

import ca.fxco.experimentalperformance.ExperimentalPerformance;
import ca.fxco.experimentalperformance.memoryDensity.HolderDataRegistry;
import ca.fxco.experimentalperformance.memoryDensity.InfoHolderData;
import ca.fxco.experimentalperformance.memoryDensity.VersionedInfoHolderData;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class SimpleConfig {
    private final Path configPath;
    private boolean parsed = false;
    private final Set<String> validHolders = new HashSet<String>();

    public SimpleConfig() {
        this.configPath = FabricLoader.getInstance().getConfigDir().resolve("experimentalperformance.properties");
    }

    public boolean hasParsed() {
        return this.parsed;
    }

    public boolean shouldLoad(String id) {
        return this.validHolders.contains(id);
    }

    public void clearHolders() {
        this.validHolders.clear();
    }

    public void parseConfig() {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        if (Files.exists(this.configPath, new LinkOption[0])) {
            Properties properties = new Properties();
            try (InputStream is = Files.newInputStream(this.configPath, new OpenOption[0]);){
                properties.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load config file", e);
            }
            this.loadProperties(properties);
        } else {
            try {
                this.writeDefaultConfig();
            }
            catch (IOException e) {
                ExperimentalPerformance.LOGGER.warn("Unable to create the config file", (Throwable)e);
            }
        }
    }

    private void loadProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!value.equalsIgnoreCase("true")) continue;
            this.validHolders.add(key);
        }
    }

    private void writeDefaultConfig() throws IOException {
        Path path = this.configPath.getParent();
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        } else if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("Unable to create config file without a directory");
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
            writer.write("# This is the ExperimentalPerformance mod config\n");
            writer.write("# Use this config to change what options should be enabled or disabled\n");
            writer.write("#\n");
            writer.write("# The default value will be placed here when writing the config for the first time\n\n");
            for (Map.Entry<String, InfoHolderData> entry : HolderDataRegistry.infoHolderDataMap.entrySet()) {
                writer.write(entry.getKey() + "=" + entry.getValue().getDefaultValue() + "\n");
                if (!entry.getValue().getDefaultValue()) continue;
                this.validHolders.add(entry.getKey());
            }
            for (Map.Entry<String, Object> entry : HolderDataRegistry.versionedInfoHolderDataMap.entrySet()) {
                writer.write(entry.getKey() + "=" + ((VersionedInfoHolderData)entry.getValue()).getDefaultValue() + "\n");
                if (!((VersionedInfoHolderData)entry.getValue()).getDefaultValue()) continue;
                this.validHolders.add(entry.getKey());
            }
        }
    }
}

