/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.task;

import java.util.Iterator;
import java.util.function.Predicate;
import net.earthcomputer.clientcommands.task.SimpleTask;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_638;

public abstract class RenderDistanceScanTask
extends SimpleTask {
    private static final long MAX_SCAN_TIME = 30000000L;
    private final boolean keepSearching;
    private Iterator<class_2338.class_2339> squarePosIterator;

    protected RenderDistanceScanTask(boolean keepSearching) {
        this.keepSearching = keepSearching;
    }

    @Override
    public void initialize() {
        this.squarePosIterator = this.createIterator();
    }

    @Override
    public boolean condition() {
        return this.squarePosIterator != null;
    }

    @Override
    protected void onTick() {
        class_1297 cameraEntity = class_310.method_1551().field_1719;
        if (cameraEntity == null) {
            this._break();
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        assert (level != null);
        long startTime = System.nanoTime();
        while (this.squarePosIterator.hasNext()) {
            class_2338 chunkPosAsBlockPos = (class_2338)this.squarePosIterator.next();
            class_1923 chunkPos = new class_1923(chunkPosAsBlockPos.method_10263(), chunkPosAsBlockPos.method_10260());
            if (this.canScanChunk(cameraEntity, chunkPos)) {
                int minSection = level.method_32891();
                int maxSection = level.method_31597();
                for (int sectionY = minSection; sectionY < maxSection; ++sectionY) {
                    class_4076 sectionPos = class_4076.method_18681((class_1923)chunkPos, (int)sectionY);
                    if (!this.canScanChunkSection(cameraEntity, sectionPos)) continue;
                    this.scanChunkSection(cameraEntity, sectionPos);
                }
            }
            if (System.nanoTime() - startTime <= 30000000L) continue;
            return;
        }
        if (this.keepSearching) {
            if (this.canKeepSearchingNow()) {
                this.squarePosIterator = this.createIterator();
            }
        } else {
            this.squarePosIterator = null;
        }
    }

    protected boolean canKeepSearchingNow() {
        return true;
    }

    protected boolean canScanChunk(class_1297 cameraEntity, class_1923 pos) {
        class_638 level = class_310.method_1551().field_1687;
        assert (level != null);
        return level.method_8402(pos.field_9181, pos.field_9180, class_2806.field_12803, false) != null;
    }

    protected boolean canScanChunkSection(class_1297 cameraEntity, class_4076 pos) {
        return true;
    }

    protected boolean hasAnyBlockCloserThan(class_1297 cameraEntity, class_1923 chunkPos, double distanceSq) {
        class_243 cameraPos = cameraEntity.method_5836(0.0f);
        double closestX = class_3532.method_15350((double)cameraPos.field_1352, (double)(chunkPos.field_9181 << 4), (double)(chunkPos.field_9181 + 1 << 4));
        double closestZ = class_3532.method_15350((double)cameraPos.field_1350, (double)(chunkPos.field_9180 << 4), (double)(chunkPos.field_9180 + 1 << 4));
        double closestDistanceSq = class_3532.method_33723((double)(cameraPos.field_1352 - closestX)) + class_3532.method_33723((double)(cameraPos.field_1350 - closestZ));
        return closestDistanceSq < distanceSq;
    }

    protected boolean willScanBlockCloserThan(class_1297 cameraEntity, class_1923 currentlyScanningChunk, double distanceSq) {
        class_243 cameraPos = cameraEntity.method_5836(0.0f);
        int cameraChunkX = class_3532.method_15357((double)cameraPos.field_1352) >> 4;
        int cameraChunkZ = class_3532.method_15357((double)cameraPos.field_1350) >> 4;
        int chunkRadius = Math.max(Math.abs(currentlyScanningChunk.field_9181 - cameraChunkX), Math.abs(currentlyScanningChunk.field_9180 - cameraChunkZ));
        double minPossibleDistance = (double)(chunkRadius - 1 << 4) + Math.min(Math.min(cameraPos.field_1352 - (double)(cameraChunkX << 4), (double)(cameraChunkX + 1 << 4) - cameraPos.field_1352), Math.min(cameraPos.field_1350 - (double)(cameraChunkZ << 4), (double)(cameraChunkZ + 1 << 4) - cameraPos.field_1350));
        return minPossibleDistance * minPossibleDistance < distanceSq;
    }

    protected boolean hasBlockState(class_4076 pos, Predicate<class_2680> stateTest) {
        class_638 level = class_310.method_1551().field_1687;
        assert (level != null);
        class_2818 chunk = level.method_8497(pos.method_10263(), pos.method_10260());
        class_2826 section = chunk.method_38259(chunk.method_31603(pos.method_10264()));
        return section.method_19523(stateTest);
    }

    private void scanChunkSection(class_1297 cameraEntity, class_4076 sectionPos) {
        class_638 level = class_310.method_1551().field_1687;
        assert (level != null);
        for (class_2338 pos : class_2338.method_10094((int)sectionPos.method_19527(), (int)sectionPos.method_19528(), (int)sectionPos.method_19529(), (int)sectionPos.method_19530(), (int)sectionPos.method_19531(), (int)sectionPos.method_19532())) {
            this.scanBlock(cameraEntity, pos);
        }
    }

    protected abstract void scanBlock(class_1297 var1, class_2338 var2);

    private Iterator<class_2338.class_2339> createIterator() {
        class_1297 cameraEntity = class_310.method_1551().field_1719;
        if (cameraEntity == null) {
            this._break();
            return null;
        }
        return class_2338.method_30512((class_2338)new class_2338(class_3532.method_15357((double)cameraEntity.method_23317()) >> 4, 0, class_3532.method_15357((double)cameraEntity.method_23321()) >> 4), (int)((Integer)class_310.method_1551().field_1690.method_42503().method_41753()), (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035).iterator();
    }
}

