/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.task;

import com.mojang.logging.LogUtils;
import java.lang.ref.WeakReference;
import java.util.Set;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.features.PlayerRandCracker;
import net.earthcomputer.clientcommands.features.SuggestionsHook;
import net.earthcomputer.clientcommands.task.SimpleTask;
import net.minecraft.class_2604;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.slf4j.Logger;

public class ItemThrowTask
extends SimpleTask {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<Object> MUTEX_KEYS = Set.of(ItemThrowTask.class);
    public static final int FLAG_URGENT = 1;
    public static final int FLAG_WAIT_FOR_ITEMS = 2;
    private static WeakReference<ItemThrowTask> currentThrowTask = null;
    private final int totalItemsToThrow;
    private final int flags;
    private int confirmedItemThrows;
    private int sentItemThrows;
    private float itemThrowsAllowedThisTick;
    private boolean waitingFence = false;
    private boolean failed = false;

    public ItemThrowTask(int itemsToThrow) {
        this(itemsToThrow, 0);
    }

    public ItemThrowTask(int itemsToThrow, int flags) {
        this.totalItemsToThrow = itemsToThrow;
        this.flags = flags;
    }

    @Override
    public boolean condition() {
        return this.waitingFence || this.sentItemThrows != this.totalItemsToThrow || this.sentItemThrows > this.confirmedItemThrows;
    }

    @Override
    protected void onTick() {
        this.itemThrowsAllowedThisTick += Configs.itemThrowsPerTick;
        while (((this.flags & 1) != 0 || this.itemThrowsAllowedThisTick >= 1.0f) && this.sentItemThrows < this.totalItemsToThrow) {
            this.itemThrowsAllowedThisTick -= 1.0f;
            if (!PlayerRandCracker.throwItem()) {
                if ((this.flags & 2) != 0) {
                    return;
                }
                this.failed = true;
                this._break();
                this.onFailedToThrowItem();
                return;
            }
            ++this.sentItemThrows;
        }
        if (!this.waitingFence && this.sentItemThrows == this.totalItemsToThrow && this.confirmedItemThrows < this.sentItemThrows) {
            this.waitingFence = true;
            SuggestionsHook.fence().thenAccept(v -> {
                if (this.sentItemThrows > this.confirmedItemThrows) {
                    LOGGER.info("Server rejected {} item throws. Rethrowing them.", (Object)(this.sentItemThrows - this.confirmedItemThrows));
                    while (this.sentItemThrows > this.confirmedItemThrows) {
                        PlayerRandCracker.unthrowItem();
                        --this.sentItemThrows;
                    }
                }
                this.waitingFence = false;
            });
        }
    }

    @Override
    public void initialize() {
        currentThrowTask = new WeakReference<ItemThrowTask>(this);
    }

    @Override
    public void onCompleted() {
        if (!this.failed) {
            this.onSuccess();
        }
        currentThrowTask = null;
    }

    @Override
    public Set<Object> getMutexKeys() {
        return MUTEX_KEYS;
    }

    protected void onFailedToThrowItem() {
    }

    protected void onSuccess() {
    }

    protected void onItemSpawn(class_2604 packet) {
    }

    public static void handleItemSpawn(class_2604 packet) {
        ItemThrowTask task;
        ItemThrowTask itemThrowTask = task = currentThrowTask == null ? null : (ItemThrowTask)currentThrowTask.get();
        if (task == null) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (player.method_33571().method_1028(packet.method_11175(), packet.method_11174(), packet.method_11176()) > 1.0) {
            return;
        }
        ++task.confirmedItemThrows;
        task.onItemSpawn(packet);
    }

    public String toString() {
        return "ItemThrowTask[totalItemsToThrow=" + this.totalItemsToThrow + ",flags=" + this.flags + "]";
    }
}

