/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.response.ProfileSearchResultsResponse;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.util.ByteBufferTypeAdapter;
import com.mojang.util.InstantTypeAdapter;
import com.mojang.util.UUIDTypeAdapter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.ToIntFunction;
import net.earthcomputer.clientcommands.features.MappingsHelper;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_4076;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.apache.commons.io.function.IOBiConsumer;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.IOStream;
import org.apache.commons.io.function.Uncheck;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketDumper {
    public static void dumpPacket(class_2596<?> packet, JsonWriter writer) throws IOException {
        writer.beginArray();
        try {
            packet.method_11052((class_2540)new PacketDumpByteBuf(writer));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        writer.endArray();
    }

    private static class PacketDumpByteBuf
    extends class_2540 {
        private static final Gson GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeAdapter(Instant.class, (Object)new InstantTypeAdapter()).registerTypeHierarchyAdapter(ByteBuffer.class, (Object)new ByteBufferTypeAdapter().nullSafe()).registerTypeAdapter(GameProfile.class, (Object)new GameProfile.Serializer()).registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).registerTypeAdapter(ProfileSearchResultsResponse.class, (Object)new ProfileSearchResultsResponse.Serializer()).create();
        private static final DateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        private final JsonWriter writer;

        public PacketDumpByteBuf(JsonWriter writer) {
            super(Unpooled.buffer((int)0, (int)0));
            this.writer = writer;
        }

        @NotNull
        public <T> PacketDumpByteBuf writeWithCodec(DynamicOps<class_2520> ops, Codec<T> codec, T value) {
            return this.dump("withCodec", () -> {
                this.dumpValueClass(value);
                this.writer.name("value").value(Objects.toString(value));
                this.writer.name("encodedNbt").value(((class_2520)class_156.method_47526((DataResult)codec.encodeStart(ops, value), message -> new EncoderException("Failed to encode: " + message + " " + value))).toString());
                this.writer.name("encodedJson");
                GSON.toJson((JsonElement)class_156.method_47526((DataResult)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value), message -> new EncoderException("Failed to encode: " + message + " " + value)), this.writer);
            });
        }

        public <T> void method_49395(Codec<T> codec, T value) {
            this.dump("jsonWithCodec", () -> {
                this.dumpValueClass(value);
                this.writer.name("value").value(Objects.toString(value));
                this.writer.name("encodedJson");
                GSON.toJson((JsonElement)class_156.method_47526((DataResult)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value), message -> new EncoderException("Failed to encode: " + message + " " + value)), this.writer);
            });
        }

        public <T> void method_42065(class_2359<T> idMap, T value) {
            this.dump("id", () -> {
                this.dumpValueClass(value);
                this.writer.name("value").value(Objects.toString(value));
                if (idMap instanceof class_2378) {
                    class_2378 registry = (class_2378)idMap;
                    this.writer.name("registry").value(registry.method_30517().method_29177().toString());
                    this.writer.name("valueKey").value(Objects.toString(registry.method_10221(value)));
                }
                this.writer.name("id").value((long)idMap.method_10206(value));
            });
        }

        public <T> void method_47989(class_2359<class_6880<T>> idMap, class_6880<T> value, class_2540.class_7462<T> directWriter) {
            this.dump("idHolder", () -> {
                this.writer.name("kind").value(value.method_40231().name());
                value.method_40229().ifLeft(key -> Uncheck.run(() -> {
                    this.writer.name("referenceKey").value(key.method_29177().toString());
                    this.writer.name("id").value((long)idMap.method_10206((Object)value));
                })).ifRight(directValue -> Uncheck.run(() -> {
                    this.writer.name("directValue");
                    this.dumpValue(directValue, directWriter);
                }));
            });
        }

        public <T> void method_34062(Collection<T> collection, class_2540.class_7462<T> elementWriter) {
            this.dump("collection", () -> {
                this.writer.name("size").value((long)collection.size());
                this.writer.name("elements").beginArray();
                for (Object element : collection) {
                    this.dumpValue(element, elementWriter);
                }
                this.writer.endArray();
            });
        }

        public void method_34060(IntList intIdList) {
            this.dump("intIdList", () -> {
                this.writer.name("size").value((long)intIdList.size());
                this.writer.name("elements").beginArray();
                IntListIterator intListIterator = intIdList.iterator();
                while (intListIterator.hasNext()) {
                    int value = (Integer)intListIterator.next();
                    this.writer.value((long)value);
                }
                this.writer.endArray();
            });
        }

        public <K, V> void method_34063(Map<K, V> map, class_2540.class_7462<K> keyWriter, class_2540.class_7462<V> valueWriter) {
            this.dump("map", () -> {
                this.writer.name("size").value((long)map.size());
                this.writer.name("elements").beginArray();
                for (Map.Entry entry : map.entrySet()) {
                    this.writer.beginObject();
                    this.writer.name("key");
                    this.dumpValue(entry.getKey(), keyWriter);
                    this.writer.name("value");
                    this.dumpValue(entry.getValue(), valueWriter);
                    this.writer.endObject();
                }
                this.writer.endArray();
            });
        }

        public <E extends Enum<E>> void method_46253(EnumSet<E> enumSet, Class<E> enumClass) {
            this.dump("enumSet", () -> {
                String className = enumClass.getName().replace('.', '/');
                String mojmapClassName = Objects.requireNonNullElse(MappingsHelper.namedOrIntermediaryToMojmap_class(className), className);
                mojmapClassName = mojmapClassName.substring(mojmapClassName.lastIndexOf(47) + 1);
                this.writer.name("enumClass").value(mojmapClassName);
                this.writer.name("size").value((long)enumSet.size());
                this.writer.name("elements").beginArray();
                for (Enum element : enumSet) {
                    this.writer.value(element.name());
                }
                this.writer.endArray();
            });
        }

        public <T> void method_37435(Optional<T> optional, class_2540.class_7462<T> valueWriter) {
            this.writeNullable("optional", optional.orElse(null), valueWriter);
        }

        public <T> void method_43826(@Nullable T value, class_2540.class_7462<T> writer) {
            this.writeNullable("nullable", value, writer);
        }

        private <T> void writeNullable(String type, T value, class_2540.class_7462<T> valueWriter) {
            this.dump(type, () -> {
                this.writer.name("present");
                if (value != null) {
                    this.writer.value(true);
                    this.writer.name("value");
                    this.dumpValue(value, valueWriter);
                } else {
                    this.writer.value(false);
                }
            });
        }

        public <L, R> void method_43619(Either<L, R> value, class_2540.class_7462<L> leftWriter, class_2540.class_7462<R> rightWriter) {
            this.dump("either", () -> {
                this.writer.name("either");
                value.ifLeft(left -> Uncheck.run(() -> {
                    this.writer.value("left");
                    this.writer.name("value");
                    this.dumpValue(left, leftWriter);
                })).ifRight(right -> Uncheck.run(() -> {
                    this.writer.value("right");
                    this.writer.name("value");
                    this.dumpValue(right, rightWriter);
                }));
            });
        }

        @NotNull
        public PacketDumpByteBuf writeByteArray(byte[] array) {
            return this.dump("byteArray", () -> this.writer.name("length").value((long)array.length).name("value").value(Base64.getEncoder().encodeToString(array)));
        }

        @NotNull
        public PacketDumpByteBuf writeVarIntArray(int[] array) {
            return this.dump("varIntArray", () -> {
                this.writer.name("length").value((long)array.length);
                this.writer.name("elements").beginArray();
                for (int element : array) {
                    this.writer.value((long)element);
                }
                this.writer.endArray();
            });
        }

        @NotNull
        public PacketDumpByteBuf writeLongArray(long[] array) {
            return this.dump("longArray", () -> {
                this.writer.name("length").value((long)array.length);
                this.writer.name("elements").beginArray();
                for (long element : array) {
                    this.writer.value(element);
                }
                this.writer.endArray();
            });
        }

        @NotNull
        public PacketDumpByteBuf writeBlockPos(class_2338 pos) {
            return this.dump("blockPos", () -> this.writer.name("x").value((long)pos.method_10263()).name("y").value((long)pos.method_10264()).name("z").value((long)pos.method_10260()));
        }

        @NotNull
        public PacketDumpByteBuf writeChunkPos(class_1923 chunkPos) {
            return this.dump("chunkPos", () -> this.writer.name("x").value((long)chunkPos.field_9181).name("z").value((long)chunkPos.field_9180));
        }

        @NotNull
        public PacketDumpByteBuf writeSectionPos(class_4076 sectionPos) {
            return this.dump("sectionPos", () -> this.writer.name("x").value((long)sectionPos.method_18674()).name("y").value((long)sectionPos.method_18683()).name("z").value((long)sectionPos.method_18687()));
        }

        public void method_44113(class_4208 pos) {
            this.dump("globalPos", () -> this.writer.name("level").value(pos.method_19442().method_29177().toString()).name("x").value((long)pos.method_19446().method_10263()).name("y").value((long)pos.method_19446().method_10264()).name("z").value((long)pos.method_19446().method_10260()));
        }

        public void method_49068(Vector3f vector3f) {
            this.dump("vector3f", () -> this.writer.name("x").value(vector3f.x).name("y").value(vector3f.y).name("z").value(vector3f.z));
        }

        public void method_49067(Quaternionf quaternion) {
            this.dump("quaternion", () -> this.writer.name("x").value(quaternion.x).name("y").value(quaternion.y).name("z").value(quaternion.z).name("w").value(quaternion.w));
        }

        public void method_52955(class_243 vec3) {
            this.dump("vec3", () -> this.writer.name("x").value(vec3.field_1352).name("y").value(vec3.field_1351).name("z").value(vec3.field_1350));
        }

        @NotNull
        public PacketDumpByteBuf writeComponent(class_2561 component) {
            return this.dump("component", () -> {
                this.writer.name("value");
                GSON.toJson(class_2561.class_2562.method_10868((class_2561)component), this.writer);
            });
        }

        @NotNull
        public PacketDumpByteBuf writeEnum(Enum<?> value) {
            return this.dump("enum", () -> {
                String className = value.getDeclaringClass().getName().replace('.', '/');
                String mojmapClassName = Objects.requireNonNullElse(MappingsHelper.namedOrIntermediaryToMojmap_class(className), className);
                mojmapClassName = mojmapClassName.substring(mojmapClassName.lastIndexOf(47) + 1);
                this.writer.name("enum").value(mojmapClassName).name("value").value(value.name());
            });
        }

        @NotNull
        public <T> PacketDumpByteBuf writeById(ToIntFunction<T> idGetter, T value) {
            return this.dump("byId", () -> {
                this.dumpValueClass(value);
                this.writer.name("value").value(Objects.toString(value));
                this.writer.name("id").value((long)idGetter.applyAsInt(value));
            });
        }

        @NotNull
        public PacketDumpByteBuf writeUUID(UUID uuid) {
            return this.dumpAsString("uuid", uuid);
        }

        @NotNull
        public PacketDumpByteBuf writeVarInt(int input) {
            return this.dumpSimple("varInt", input, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeVarLong(long value) {
            return this.dumpSimple("varLong", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeNbt(@Nullable class_2520 tag) {
            return this.dumpAsString("nbt", tag);
        }

        @NotNull
        public PacketDumpByteBuf writeItem(class_1799 stack) {
            return this.dump("item", () -> this.writer.name("item").value((String)stack.method_41409().method_40230().map(k -> k.method_29177().toString()).orElse(null)).name("count").value((long)stack.method_7947()).name("tag").value(Objects.toString(stack.method_7969())));
        }

        @NotNull
        public class_2540 method_10814(String string) {
            return this.dump("utf", () -> this.writer.name("value").value(string));
        }

        @NotNull
        public PacketDumpByteBuf writeUtf(String string, int maxLength) {
            return this.dump("utf", () -> this.writer.name("maxLength").value((long)maxLength).name("value").value(string));
        }

        @NotNull
        public PacketDumpByteBuf writeResourceLocation(class_2960 resourceLocation) {
            return this.dumpAsString("resourceLocation", resourceLocation);
        }

        public void method_44116(class_5321<?> resourceKey) {
            this.dump("resourceKey", () -> this.writer.name("registry").value(resourceKey.method_41185().toString()).name("location").value(resourceKey.method_29177().toString()));
        }

        @NotNull
        public PacketDumpByteBuf writeDate(Date time) {
            return this.dumpSimple("date", ISO_8601.format(time), JsonWriter::value);
        }

        public void method_44115(Instant instant) {
            this.dumpAsString("instant", instant);
        }

        @NotNull
        public PacketDumpByteBuf writePublicKey(PublicKey publicKey) {
            return this.dump("publicKey", () -> this.writer.name("encoded").value(Base64.getEncoder().encodeToString(publicKey.getEncoded())));
        }

        public void method_17813(class_3965 result) {
            this.dump("blockHitResult", () -> this.writer.name("pos").beginObject().name("x").value((long)result.method_17777().method_10263()).name("y").value((long)result.method_17777().method_10264()).name("z").value((long)result.method_17777().method_10260()).endObject().name("direction").value(result.method_17780().method_15434()).name("offset").beginObject().name("x").value(result.method_17784().field_1352 - (double)result.method_17777().method_10263()).name("y").value(result.method_17784().field_1351 - (double)result.method_17777().method_10264()).name("z").value(result.method_17784().field_1350 - (double)result.method_17777().method_10260()).name("isInside").value(result.method_17781()));
        }

        public void method_33557(BitSet bitSet) {
            this.dump("bitSet", () -> {
                this.writer.name("bits").beginArray();
                IOStream.adapt(bitSet.stream().boxed()).forEach(arg_0 -> ((JsonWriter)this.writer).value(arg_0));
                this.writer.endArray();
            });
        }

        public void method_46252(BitSet bitSet, int size) {
            this.dump("fixedBitSet", () -> {
                this.writer.name("size").value((long)size);
                this.writer.name("bits").beginArray();
                IOStream.adapt(bitSet.stream().boxed()).forEach(arg_0 -> ((JsonWriter)this.writer).value(arg_0));
                this.writer.endArray();
            });
        }

        public void method_43616(GameProfile gameProfile) {
            this.dump("gameProfile", () -> {
                this.writer.name("value");
                GSON.toJson((Object)gameProfile, GameProfile.class, this.writer);
            });
        }

        public void method_46249(PropertyMap gameProfileProperties) {
            this.dump("gameProfileProperties", () -> {
                this.writer.name("value");
                GSON.toJson((Object)gameProfileProperties, PropertyMap.class, this.writer);
            });
        }

        public void method_43617(Property property) {
            this.dump("property", () -> {
                this.writer.name("name").value(property.name());
                this.writer.name("value").value(property.value());
                if (property.hasSignature()) {
                    this.writer.name("signature").value(property.signature());
                }
            });
        }

        @NotNull
        public PacketDumpByteBuf skipBytes(int length) {
            return this.dump("skipBytes", () -> this.writer.name("length").value((long)length));
        }

        @NotNull
        public PacketDumpByteBuf writeBoolean(boolean value) {
            return this.dumpSimple("boolean", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeByte(int value) {
            return this.dumpSimple("byte", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeShort(int value) {
            return this.dumpSimple("short", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeShortLE(int value) {
            return this.dumpSimple("shortLE", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeMedium(int value) {
            return this.dumpSimple("medium", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeMediumLE(int value) {
            return this.dumpSimple("mediumLE", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeInt(int value) {
            return this.dumpSimple("int", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeIntLE(int value) {
            return this.dumpSimple("intLE", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeLong(long value) {
            return this.dumpSimple("long", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeLongLE(long value) {
            return this.dumpSimple("longLE", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeChar(int value) {
            return this.dumpSimple("char", Character.toString((char)value), JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeFloat(float value) {
            return this.dumpSimple("float", Float.valueOf(value), JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeFloatLE(float value) {
            return this.dumpSimple("floatLE", Float.valueOf(value), JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeDouble(double value) {
            return this.dumpSimple("double", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeDoubleLE(double value) {
            return this.dumpSimple("doubleLE", value, JsonWriter::value);
        }

        @NotNull
        public PacketDumpByteBuf writeBytes(ByteBuf source) {
            return this.writeBytes(source, source.readableBytes());
        }

        @NotNull
        public PacketDumpByteBuf writeBytes(ByteBuf source, int length) {
            byte[] bytes = new byte[length];
            source.readBytes(bytes);
            return this.dumpBytes(bytes);
        }

        @NotNull
        public PacketDumpByteBuf writeBytes(ByteBuf source, int sourceIndex, int length) {
            byte[] bytes = new byte[length];
            source.getBytes(sourceIndex, bytes);
            return this.dumpBytes(bytes);
        }

        @NotNull
        public PacketDumpByteBuf writeBytes(byte[] source) {
            return this.dumpBytes(source);
        }

        @NotNull
        public PacketDumpByteBuf writeBytes(byte[] source, int sourceIndex, int length) {
            return this.dumpBytes(Arrays.copyOfRange(source, sourceIndex, sourceIndex + length));
        }

        @NotNull
        public PacketDumpByteBuf writeBytes(ByteBuffer source) {
            byte[] bytes = new byte[source.remaining()];
            source.get(bytes);
            return this.dumpBytes(bytes);
        }

        public int writeBytes(InputStream inputStream, int i) throws IOException {
            byte[] bytes = new byte[i];
            int read = inputStream.read(bytes);
            this.dumpBytes(Arrays.copyOf(bytes, i));
            return read;
        }

        public int writeBytes(ScatteringByteChannel scatteringByteChannel, int i) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(i);
            int read = scatteringByteChannel.read(buffer);
            buffer.flip();
            this.dumpBytes(Arrays.copyOfRange(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.arrayOffset() + buffer.limit()));
            return read;
        }

        public int writeBytes(FileChannel fileChannel, long l, int i) throws IOException {
            return this.writeBytes(fileChannel.position(l), i);
        }

        private PacketDumpByteBuf dumpBytes(byte[] bytes) {
            return this.dump("bytes", () -> this.writer.name("length").value((long)bytes.length).name("value").value(Base64.getEncoder().encodeToString(bytes)));
        }

        @NotNull
        public PacketDumpByteBuf writeZero(int length) {
            return this.dump("zero", () -> this.writer.name("length").value((long)length));
        }

        public int writeCharSequence(CharSequence charSequence, Charset charset) {
            String string = charSequence.toString();
            byte[] encoded = string.getBytes(charset);
            this.dump("charSequence", () -> this.writer.name("charset").value(charset.name()).name("value").value(string).name("encoded").value(Base64.getEncoder().encodeToString(encoded)));
            return encoded.length;
        }

        private void dumpValueClass(Object value) throws IOException {
            this.writer.name("valueClass");
            if (value != null) {
                String className = value.getClass().getName().replace('.', '/');
                String mojmapClassName = Objects.requireNonNullElse(MappingsHelper.namedOrIntermediaryToMojmap_class(className), className);
                mojmapClassName = mojmapClassName.substring(mojmapClassName.lastIndexOf(47) + 1);
                this.writer.value(mojmapClassName);
            } else {
                this.writer.nullValue();
            }
        }

        private <T> void dumpValue(T value, class_2540.class_7462<T> valueWriter) throws IOException {
            this.writer.beginObject();
            this.dumpValueClass(value);
            this.writer.name("fields").beginArray();
            valueWriter.accept((Object)this, value);
            this.writer.endArray();
            this.writer.endObject();
        }

        private PacketDumpByteBuf dumpAsString(String type, Object value) {
            return this.dumpSimple(type, value != null ? value.toString() : null, JsonWriter::value);
        }

        private <T> PacketDumpByteBuf dumpSimple(String type, T value, IOBiConsumer<JsonWriter, T> valueWriter) {
            return this.dump(type, () -> {
                this.writer.name("value");
                valueWriter.accept((Object)this.writer, value);
            });
        }

        private PacketDumpByteBuf dump(String type, IORunnable dumper) {
            Uncheck.run(() -> {
                this.writer.beginObject();
                this.writer.name("type").value(type);
                dumper.run();
                this.writer.endObject();
            });
            return this;
        }
    }
}

