/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class TranslationQueryArgumentType
implements ArgumentType<TranslationQuery> {
    private static final Collection<String> EXAMPLES = Arrays.asList("\"Voorbeeld\" from nl to en", "\"Non numeranda, sed ponderanda sunt argumenta\" from la", "\"Cogito, ergo sum\"");
    private static final DynamicCommandExceptionType UNKNOWN_LANGUAGE_CODE_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.ctranslate.unknownLanguageCode", (Object[])new Object[]{arg}));
    private static final SimpleCommandExceptionType EXPECTED_FROM_TO_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ctranslate.expectedFromTo"));
    private static final Collection<String> LANGUAGES = Arrays.asList("af", "sq", "am", "ar", "hy", "az", "eu", "be", "bn", "bs", "bg", "ca", "ceb", "zh-CN", "zh", "zh-TW", "co", "hr", "cs", "da", "nl", "en", "eo", "et", "fi", "fr", "fy", "gl", "ka", "de", "el", "gu", "ht", "ha", "haw", "he", "iw", "hi", "hmn", "hu", "is", "ig", "id", "ga", "it", "ja", "jv", "kn", "kk", "km", "rw", "ko", "ku", "ky", "lo", "la", "lv", "lt", "lb", "mk", "mg", "ms", "ml", "mt", "mi", "mr", "mn", "my", "ne", "no", "ny", "or", "ps", "fa", "pl", "pt", "pa", "ro", "ru", "sm", "gd", "sr", "st", "sn", "sd", "si", "sk", "sl", "so", "es", "su", "sw", "sv", "tl", "tg", "ta", "tt", "te", "th", "tr", "tk", "uk", "ur", "ug", "uz", "vi", "cy", "xh", "yi", "yo", "zu");

    public static TranslationQueryArgumentType translationQuery() {
        return new TranslationQueryArgumentType();
    }

    public static TranslationQuery getTranslationQuery(CommandContext<FabricClientCommandSource> context, String arg) {
        TranslationQuery query = (TranslationQuery)context.getArgument(arg, TranslationQuery.class);
        return new TranslationQuery(query.from() == null ? "auto" : query.from(), query.to() == null ? ((FabricClientCommandSource)context.getSource()).getClient().field_1690.field_1883 : query.to(), query.query());
    }

    public TranslationQuery parse(StringReader reader) throws CommandSyntaxException {
        return new Parser(reader).parse();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        Parser parser = new Parser(reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (parser.suggestor != null) {
            parser.suggestor.accept(builder);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public record TranslationQuery(String from, String to, String query) {
    }

    private static class Parser {
        private final StringReader reader;
        private Consumer<SuggestionsBuilder> suggestor;

        public Parser(StringReader reader) {
            this.reader = reader;
        }

        public TranslationQuery parse() throws CommandSyntaxException {
            String query = this.reader.readQuotedString();
            String from = null;
            String to = null;
            while (this.reader.canRead()) {
                this.reader.skipWhitespace();
                Option option = this.parseFromTo();
                boolean suggest = this.reader.canRead();
                this.reader.skipWhitespace();
                String language = this.parseLanguage(suggest);
                if (option == Option.FROM) {
                    from = language;
                    continue;
                }
                to = language;
            }
            return new TranslationQuery(from, to, query);
        }

        private Option parseFromTo() throws CommandSyntaxException {
            String option;
            int start = this.reader.getCursor();
            this.suggestor = suggestions -> {
                SuggestionsBuilder builder = suggestions.createOffset(start);
                class_2172.method_9253((String[])new String[]{"from", "to"}, (SuggestionsBuilder)builder);
                suggestions.add(builder);
            };
            return switch (option = this.reader.readUnquotedString()) {
                case "from" -> Option.FROM;
                case "to" -> Option.TO;
                default -> throw EXPECTED_FROM_TO_EXCEPTION.create();
            };
        }

        private String parseLanguage(boolean suggest) throws CommandSyntaxException {
            String language;
            int start = this.reader.getCursor();
            if (suggest) {
                this.suggestor = suggestions -> {
                    SuggestionsBuilder builder = suggestions.createOffset(start);
                    class_2172.method_9265(LANGUAGES, (SuggestionsBuilder)builder);
                    suggestions.add(builder);
                };
            }
            if (LANGUAGES.contains(language = this.reader.readUnquotedString())) {
                return language;
            }
            throw UNKNOWN_LANGUAGE_CODE_EXCEPTION.create((Object)language);
        }

        private static enum Option {
            FROM,
            TO;

        }
    }
}

