/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_2561;

public class RegexArgumentType
implements ArgumentType<Pattern> {
    private static final DynamicCommandExceptionType EXPECTED_REGEX_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.client.expectedRegex", (Object[])new Object[]{arg}));
    private final RegexType type;

    private RegexArgumentType(RegexType type) {
        this.type = type;
    }

    public static RegexArgumentType wordRegex() {
        return new RegexArgumentType(RegexType.SINGLE_WORD);
    }

    public static RegexArgumentType slashyRegex() {
        return new RegexArgumentType(RegexType.SLASHY_PHRASE);
    }

    public static RegexArgumentType greedyRegex() {
        return new RegexArgumentType(RegexType.GREEDY_PHRASE);
    }

    public static Pattern getRegex(CommandContext<?> context, String name) {
        return (Pattern)context.getArgument(name, Pattern.class);
    }

    public Pattern parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        if (this.type == RegexType.GREEDY_PHRASE) {
            String text = reader.getRemaining();
            try {
                Pattern pattern = Pattern.compile(text);
                reader.setCursor(reader.getTotalLength());
                return pattern;
            }
            catch (PatternSyntaxException e) {
                reader.setCursor(start);
                throw EXPECTED_REGEX_EXCEPTION.createWithContext((ImmutableStringReader)reader, (Object)text);
            }
        }
        if (this.type == RegexType.SINGLE_WORD) {
            String text = reader.readUnquotedString();
            try {
                return Pattern.compile(text);
            }
            catch (PatternSyntaxException e) {
                reader.setCursor(start);
                throw EXPECTED_REGEX_EXCEPTION.createWithContext((ImmutableStringReader)reader, (Object)text);
            }
        }
        return RegexArgumentType.parseSlashyRegex(reader);
    }

    public static Pattern parseSlashyRegex(StringReader reader) throws CommandSyntaxException {
        boolean slashy;
        int start = reader.getCursor();
        boolean bl = slashy = reader.canRead() && reader.peek() == '/';
        if (!slashy) {
            String text = reader.readUnquotedString();
            try {
                return Pattern.compile(text);
            }
            catch (PatternSyntaxException e) {
                reader.setCursor(start);
                throw EXPECTED_REGEX_EXCEPTION.createWithContext((ImmutableStringReader)reader, (Object)text);
            }
        }
        reader.skip();
        StringBuilder regex = new StringBuilder();
        boolean escaped = false;
        while (true) {
            if (!reader.canRead()) {
                reader.setCursor(start);
                throw EXPECTED_REGEX_EXCEPTION.createWithContext((ImmutableStringReader)reader, (Object)reader.getString().substring(start));
            }
            if (reader.peek() == '/') {
                if (!escaped) {
                    reader.skip();
                    try {
                        return Pattern.compile(regex.toString());
                    }
                    catch (PatternSyntaxException e) {
                        int end = reader.getCursor();
                        reader.setCursor(start);
                        throw EXPECTED_REGEX_EXCEPTION.createWithContext((ImmutableStringReader)reader, (Object)reader.getString().substring(start, end));
                    }
                }
                regex.deleteCharAt(regex.length() - 1);
            }
            escaped = reader.peek() == '\\' && !escaped;
            regex.append(reader.peek());
            reader.skip();
        }
    }

    public Collection<String> getExamples() {
        return this.type.getExamples();
    }

    public static enum RegexType {
        SINGLE_WORD("word", "\\w+"),
        SLASHY_PHRASE("/\\w+/", "word", "//"),
        GREEDY_PHRASE("word", "words with spaces", "/and symbols/");

        private final Collection<String> examples;

        private RegexType(String ... examples) {
            this.examples = Arrays.asList(examples);
        }

        public Collection<String> getExamples() {
            return this.examples;
        }
    }
}

