/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.earthcomputer.clientcommands.features.MappingsHelper;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_156;
import net.minecraft.class_2172;
import net.minecraft.class_2539;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_8144;

public class MojmapPacketClassArgumentType
implements ArgumentType<Class<? extends class_2596<?>>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("ClientboundPlayerChatPacket", "ClientboundSystemChatMessage", "ServerboundContainerSlotStateChangedPacket");
    private static final DynamicCommandExceptionType UNKNOWN_PACKET_EXCEPTION = new DynamicCommandExceptionType(packet -> class_2561.method_43469((String)"commands.clisten.unknownPacket", (Object[])new Object[]{packet}));
    private static final Map<String, Class<? extends class_2596<?>>> mojmapPackets = (Map)Arrays.stream(class_2539.values()).flatMap(connectionProtocol -> connectionProtocol.field_20595.values().stream()).flatMap(codecData -> codecData.field_45674.field_20596.keySet().stream()).map(clazz -> (Map.Entry)class_8144.method_49077((Object)MappingsHelper.namedOrIntermediaryToMojmap_class(clazz.getName().replace('.', '/')), packet -> Map.entry(packet.substring(packet.lastIndexOf(47) + 1), clazz))).filter(Objects::nonNull).distinct().collect(class_156.method_664());

    public static MojmapPacketClassArgumentType packet() {
        return new MojmapPacketClassArgumentType();
    }

    public static Class<? extends class_2596<?>> getPacket(CommandContext<FabricClientCommandSource> context, String name) {
        return (Class)context.getArgument(name, Class.class);
    }

    public Class<? extends class_2596<?>> parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        while (reader.canRead() && (StringReader.isAllowedInUnquotedString((char)reader.peek()) || reader.peek() == '$')) {
            reader.skip();
        }
        String packet = reader.getString().substring(start, reader.getCursor());
        Class<? extends class_2596<?>> packetClass = mojmapPackets.get(packet);
        if (packetClass == null) {
            throw UNKNOWN_PACKET_EXCEPTION.create((Object)packet);
        }
        return packetClass;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(mojmapPackets.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

