/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.earthcomputer.clientcommands.mixin.HoverEventActionAccessor;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_8824;

public class FormattedComponentArgumentType
implements ArgumentType<class_5250> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Earth", "bold{xpple}", "bold{italic{red{nwex}}}");
    private static final DynamicCommandExceptionType INVALID_CLICK_ACTION = new DynamicCommandExceptionType(action -> class_2561.method_43469((String)"commands.client.invalidClickAction", (Object[])new Object[]{action}));
    private static final DynamicCommandExceptionType INVALID_HOVER_ACTION = new DynamicCommandExceptionType(action -> class_2561.method_43469((String)"commands.client.invalidHoverAction", (Object[])new Object[]{action}));
    private static final DynamicCommandExceptionType INVALID_HOVER_EVENT = new DynamicCommandExceptionType(event -> class_2561.method_43469((String)"commands.client.invalidHoverEvent", (Object[])new Object[]{event}));

    private FormattedComponentArgumentType() {
    }

    public static FormattedComponentArgumentType formattedComponent() {
        return new FormattedComponentArgumentType();
    }

    public static class_5250 getFormattedComponent(CommandContext<FabricClientCommandSource> context, String arg) {
        return (class_5250)context.getArgument(arg, class_5250.class);
    }

    public class_5250 parse(StringReader reader) throws CommandSyntaxException {
        return new Parser(reader).parse();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        Parser parser = new Parser(reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (parser.suggestor != null) {
            parser.suggestor.accept(builder);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static class Parser {
        private final StringReader reader;
        private Consumer<SuggestionsBuilder> suggestor;

        public Parser(StringReader reader) {
            this.reader = reader;
        }

        public class_5250 parse() throws CommandSyntaxException {
            int cursor = this.reader.getCursor();
            this.suggestor = builder -> {
                SuggestionsBuilder newBuilder = builder.createOffset(cursor);
                class_2172.method_9265(FormattedText.FORMATTING.keySet(), (SuggestionsBuilder)newBuilder);
                builder.add(newBuilder);
            };
            String word = this.reader.readUnquotedString();
            if (FormattedText.FORMATTING.containsKey(word.toLowerCase(Locale.ROOT))) {
                class_5250 literalText;
                FormattedText.Styler styler = FormattedText.FORMATTING.get(word.toLowerCase(Locale.ROOT));
                this.suggestor = null;
                this.reader.skipWhitespace();
                if (!this.reader.canRead() || this.reader.peek() != '{') {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedSymbol().createWithContext((ImmutableStringReader)this.reader, (Object)"{");
                }
                this.reader.skip();
                this.reader.skipWhitespace();
                ArrayList<String> arguments = new ArrayList<String>();
                if (this.reader.canRead()) {
                    if (this.reader.peek() != '}') {
                        literalText = StringReader.isQuotedStringStart((char)this.reader.peek()) ? class_2561.method_43470((String)this.reader.readQuotedString()) : this.parse();
                        this.reader.skipWhitespace();
                        while (this.reader.canRead() && this.reader.peek() != '}') {
                            if (arguments.isEmpty()) {
                                this.suggestor = builder -> {
                                    SuggestionsBuilder newBuilder = builder.createOffset(cursor);
                                    class_2172.method_9253((String[])styler.suggestions, (SuggestionsBuilder)newBuilder);
                                    builder.add(newBuilder);
                                };
                            }
                            if (this.reader.peek() != ',') {
                                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedSymbol().createWithContext((ImmutableStringReader)this.reader, (Object)",");
                            }
                            this.reader.skip();
                            this.reader.skipWhitespace();
                            arguments.add(this.readArgument());
                            this.reader.skipWhitespace();
                        }
                    } else {
                        literalText = class_2561.method_43470((String)"");
                    }
                } else {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedSymbol().createWithContext((ImmutableStringReader)this.reader, (Object)"}");
                }
                this.reader.skip();
                if (styler.argumentCount != arguments.size()) {
                    this.reader.setCursor(cursor);
                    this.reader.readUnquotedString();
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)this.reader);
                }
                return new FormattedText(styler.operator, literalText, arguments).style();
            }
            return class_2561.method_43470((String)(word + this.readArgument()));
        }

        private String readArgument() {
            int start = this.reader.getCursor();
            while (this.reader.canRead() && Parser.isAllowedInArgument(this.reader.peek())) {
                this.reader.skip();
            }
            return this.reader.getString().substring(start, this.reader.getCursor());
        }

        private static boolean isAllowedInArgument(char c) {
            return c != ',' && c != '{' && c != '}';
        }
    }

    static class FormattedText {
        private static final Map<String, Styler> FORMATTING = ImmutableMap.builder().put((Object)"aqua", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1075), 0, new String[0])).put((Object)"black", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1074), 0, new String[0])).put((Object)"blue", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1078), 0, new String[0])).put((Object)"bold", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1067), 0, new String[0])).put((Object)"dark_aqua", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1062), 0, new String[0])).put((Object)"dark_blue", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1058), 0, new String[0])).put((Object)"dark_gray", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1063), 0, new String[0])).put((Object)"dark_green", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1077), 0, new String[0])).put((Object)"dark_purple", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1064), 0, new String[0])).put((Object)"dark_red", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1079), 0, new String[0])).put((Object)"gold", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1065), 0, new String[0])).put((Object)"gray", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1080), 0, new String[0])).put((Object)"green", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1060), 0, new String[0])).put((Object)"italic", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1056), 0, new String[0])).put((Object)"light_purple", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1076), 0, new String[0])).put((Object)"obfuscated", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1051), 0, new String[0])).put((Object)"red", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1061), 0, new String[0])).put((Object)"reset", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1070), 0, new String[0])).put((Object)"strikethrough", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1055), 0, new String[0])).put((Object)"underline", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1073), 0, new String[0])).put((Object)"white", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1068), 0, new String[0])).put((Object)"yellow", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1054), 0, new String[0])).put((Object)"font", (Object)new Styler((s, o) -> s.method_27704(class_2960.method_12829((String)((String)o.get(0)))), 1, "alt", "default")).put((Object)"hex", (Object)new Styler((s, o) -> s.method_27703(class_5251.method_27717((int)Integer.parseInt((String)o.get(0), 16))), 1, new String[0])).put((Object)"insert", (Object)new Styler((s, o) -> s.method_10975((String)o.get(0)), 1, new String[0])).put((Object)"click", (Object)new Styler((s, o) -> s.method_10958(FormattedText.parseClickEvent((String)o.get(0), (String)o.get(1))), 2, "change_page", "copy_to_clipboard", "open_file", "open_url", "run_command", "suggest_command")).put((Object)"hover", (Object)new Styler((s, o) -> s.method_10949(FormattedText.parseHoverEvent((String)o.get(0), (String)o.get(1))), 2, "show_entity", "show_item", "show_text")).put((Object)"strike", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1055), 0, new String[0])).put((Object)"magic", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1051), 0, new String[0])).build();
        private final StylerFunc styler;
        private final class_5250 argument;
        private final List<String> args;
        private static final Function<String, class_2558.class_2559> CLICK_EVENT_ACTION_BY_NAME = class_3542.method_53953((class_3542[])class_2558.class_2559.values(), Function.identity());

        public FormattedText(StylerFunc styler, class_5250 argument, List<String> args) {
            this.styler = styler;
            this.argument = argument;
            this.args = args;
        }

        public class_5250 style() throws CommandSyntaxException {
            return this.argument.method_10862(this.styler.apply(this.argument.method_10866(), this.args));
        }

        private static class_2558 parseClickEvent(String name, String value) throws CommandSyntaxException {
            class_2558.class_2559 action = CLICK_EVENT_ACTION_BY_NAME.apply(name);
            if (action == null) {
                throw INVALID_CLICK_ACTION.create((Object)name);
            }
            return new class_2558(action, value);
        }

        private static class_2568 parseHoverEvent(String name, String value) throws CommandSyntaxException {
            class_2568.class_5247 action = class_2568.class_5247.field_46603.parse((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive(name)).result().orElse(null);
            if (action == null) {
                throw INVALID_HOVER_ACTION.create((Object)name);
            }
            JsonElement component = (JsonElement)class_156.method_47526((DataResult)class_8824.field_46597.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)class_2561.method_30163((String)value)), IllegalStateException::new);
            class_2568.class_8826 eventData = (class_2568.class_8826)class_156.method_47526((DataResult)((HoverEventActionAccessor)action).getLegacyCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)component), error -> INVALID_HOVER_EVENT.create((Object)value));
            return new class_2568(eventData);
        }

        @FunctionalInterface
        static interface StylerFunc {
            public class_2583 apply(class_2583 var1, List<String> var2) throws CommandSyntaxException;
        }

        private record Styler(StylerFunc operator, int argumentCount, String[] suggestions) {
        }
    }
}

