/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.mixin.CommandSuggestionsAccessor;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class ExpressionArgumentType
implements ArgumentType<Expression> {
    private static final Collection<String> EXAMPLES = Arrays.asList("123", "ans", "(1+2)", "1*3");
    private static final DynamicCommandExceptionType EXPECTED_EXCEPTION = new DynamicCommandExceptionType(obj -> class_2561.method_43469((String)"commands.ccalc.expected", (Object[])new Object[]{obj}));
    private static final Dynamic2CommandExceptionType INVALID_ARGUMENT_COUNT = new Dynamic2CommandExceptionType((func, count) -> class_2561.method_43469((String)"commands.ccalc.invalidArgumentCount", (Object[])new Object[]{func, count}));
    private static final SimpleCommandExceptionType TOO_DEEPLY_NESTED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ccalc.tooDeeplyNested"));

    private ExpressionArgumentType() {
    }

    public static ExpressionArgumentType expression() {
        return new ExpressionArgumentType();
    }

    public static Expression getExpression(CommandContext<FabricClientCommandSource> context, String arg) {
        return (Expression)context.getArgument(arg, Expression.class);
    }

    public Expression parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        Expression ret = new Parser(reader).parse();
        ret.strVal = reader.getString().substring(start, reader.getCursor());
        return ret;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        Parser parser = new Parser(reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (parser.suggestor != null) {
            parser.suggestor.accept(builder);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static abstract class Expression {
        public String strVal;

        public abstract double eval() throws StackOverflowError;

        public abstract class_2561 getParsedTree(int var1) throws StackOverflowError;

        protected static class_2561 getDepthStyled(int depth, class_5250 text) {
            List<class_2583> formattings = CommandSuggestionsAccessor.getArgumentStyles();
            return text.method_10862(formattings.get(depth % formattings.size()));
        }
    }

    private static class Parser {
        private final StringReader reader;
        private Consumer<SuggestionsBuilder> suggestor;

        public Parser(StringReader reader) {
            this.reader = reader;
        }

        public Expression parse() throws CommandSyntaxException {
            try {
                return this.parseExpression();
            }
            catch (StackOverflowError e) {
                this.suggestor = null;
                throw TOO_DEEPLY_NESTED.create();
            }
        }

        private Expression parseExpression() throws CommandSyntaxException {
            Expression expr = this.parseTerm();
            this.reader.skipWhitespace();
            while (this.reader.canRead() && (this.reader.peek() == '+' || this.reader.peek() == '-')) {
                char operator = this.reader.read();
                this.reader.skipWhitespace();
                Expression right = this.parseTerm();
                if (operator == '+') {
                    expr = new BinaryOpExpression(expr, right, Double::sum, "addition");
                    continue;
                }
                expr = new BinaryOpExpression(expr, right, (l, r) -> l - r, "subtraction");
            }
            return expr;
        }

        private Expression parseTerm() throws CommandSyntaxException {
            Expression expr = this.parseUnary();
            this.reader.skipWhitespace();
            while (this.reader.canRead() && (this.reader.peek() == '*' || this.reader.peek() == '/' || this.reader.peek() == '%')) {
                char operator = this.reader.read();
                this.reader.skipWhitespace();
                Expression right = this.parseUnary();
                if (operator == '*') {
                    expr = new BinaryOpExpression(expr, right, (l, r) -> l * r, "multiplication");
                    continue;
                }
                if (operator == '/') {
                    expr = new BinaryOpExpression(expr, right, (l, r) -> l / r, "division");
                    continue;
                }
                expr = new BinaryOpExpression(expr, right, (l, r) -> l % r, "modulo");
            }
            return expr;
        }

        private Expression parseUnary() throws CommandSyntaxException {
            boolean negative = false;
            while (this.reader.canRead() && (this.reader.peek() == '+' || this.reader.peek() == '-')) {
                if (this.reader.peek() == '-') {
                    negative = !negative;
                }
                this.reader.skip();
                this.reader.skipWhitespace();
            }
            Expression right = this.parseImplicitMult();
            if (negative) {
                return new NegateExpression(right);
            }
            return right;
        }

        private Expression parseImplicitMult() throws CommandSyntaxException {
            Expression expr = this.parseExponentiation();
            if (this.reader.canRead() && !StringReader.isAllowedNumber((char)this.reader.peek())) {
                int cursor = this.reader.getCursor();
                try {
                    Expression right = this.parseImplicitMult();
                    return new BinaryOpExpression(expr, right, (l, r) -> l * r, "multiplication");
                }
                catch (CommandSyntaxException e) {
                    this.reader.setCursor(cursor);
                }
            }
            return expr;
        }

        private Expression parseExponentiation() throws CommandSyntaxException {
            Expression expr = this.parseConstantOrFunction();
            this.reader.skipWhitespace();
            if (this.reader.canRead() && this.reader.peek() == '^') {
                this.reader.skip();
                this.reader.skipWhitespace();
                Expression exponent = this.parseUnary();
                return new BinaryOpExpression(expr, exponent, Math::pow, "exponentiation");
            }
            return expr;
        }

        private Expression parseConstantOrFunction() throws CommandSyntaxException {
            int cursor = this.reader.getCursor();
            this.suggestor = builder -> {
                SuggestionsBuilder newBuilder = builder.createOffset(cursor);
                class_2172.method_9265(ConstantExpression.CONSTANTS.keySet(), (SuggestionsBuilder)newBuilder);
                class_2172.method_9265(FunctionExpression.FUNCTIONS.keySet(), (SuggestionsBuilder)newBuilder);
                builder.add(newBuilder);
            };
            String word = this.reader.readUnquotedString().toLowerCase(Locale.ENGLISH);
            if (ConstantExpression.CONSTANTS.containsKey(word)) {
                this.suggestor = null;
                return new ConstantExpression(word, ConstantExpression.CONSTANTS.get(word));
            }
            if (FunctionExpression.FUNCTIONS.containsKey(word)) {
                this.suggestor = null;
                this.reader.skipWhitespace();
                if (!this.reader.canRead() || this.reader.peek() != '(') {
                    throw EXPECTED_EXCEPTION.createWithContext((ImmutableStringReader)this.reader, (Object)"(");
                }
                this.reader.skip();
                this.reader.skipWhitespace();
                ArrayList<Expression> arguments = new ArrayList<Expression>();
                if (this.reader.canRead() && this.reader.peek() != ')') {
                    arguments.add(this.parseExpression());
                    this.reader.skipWhitespace();
                    while (this.reader.canRead() && this.reader.peek() != ')') {
                        if (this.reader.peek() != ',') {
                            throw EXPECTED_EXCEPTION.createWithContext((ImmutableStringReader)this.reader, (Object)",");
                        }
                        this.reader.skip();
                        this.reader.skipWhitespace();
                        arguments.add(this.parseExpression());
                        this.reader.skipWhitespace();
                    }
                }
                if (!this.reader.canRead()) {
                    throw EXPECTED_EXCEPTION.createWithContext((ImmutableStringReader)this.reader, (Object)")");
                }
                this.reader.skip();
                FunctionExpression.IFunction function = FunctionExpression.FUNCTIONS.get(word);
                if (!function.isAcceptableInputCount(arguments.size())) {
                    this.reader.setCursor(cursor);
                    this.reader.readUnquotedString();
                    throw INVALID_ARGUMENT_COUNT.createWithContext((ImmutableStringReader)this.reader, (Object)word, (Object)arguments.size());
                }
                return new FunctionExpression(word, function, arguments.toArray(new Expression[0]));
            }
            this.reader.setCursor(cursor);
            if (this.reader.canRead() && this.reader.peek() == '(') {
                this.suggestor = null;
            }
            Expression ret = this.parseParenthesized();
            this.suggestor = null;
            return ret;
        }

        private Expression parseParenthesized() throws CommandSyntaxException {
            if (this.reader.canRead() && this.reader.peek() == '(') {
                this.reader.skip();
                this.reader.skipWhitespace();
                Expression ret = this.parseExpression();
                this.reader.skipWhitespace();
                if (!this.reader.canRead() || this.reader.peek() != ')') {
                    throw EXPECTED_EXCEPTION.createWithContext((ImmutableStringReader)this.reader, (Object)")");
                }
                this.reader.skip();
                return ret;
            }
            return this.parseLiteral();
        }

        private Expression parseLiteral() throws CommandSyntaxException {
            int start = this.reader.getCursor();
            while (this.reader.canRead() && Parser.isAllowedNumber(this.reader.peek())) {
                this.reader.skip();
            }
            String number = this.reader.getString().substring(start, this.reader.getCursor());
            if (number.isEmpty()) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedDouble().createWithContext((ImmutableStringReader)this.reader);
            }
            try {
                return new LiteralExpression(Double.parseDouble(number));
            }
            catch (NumberFormatException e) {
                this.reader.setCursor(start);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidDouble().createWithContext((ImmutableStringReader)this.reader, (Object)number);
            }
        }

        private static boolean isAllowedNumber(char c) {
            return c >= '0' && c <= '9' || c == '.';
        }
    }

    private static class LiteralExpression
    extends Expression {
        private final double val;

        public LiteralExpression(double val) {
            this.val = val;
        }

        @Override
        public double eval() {
            return this.val;
        }

        @Override
        public class_2561 getParsedTree(int depth) {
            return LiteralExpression.getDepthStyled(depth, class_2561.method_43469((String)"commands.ccalc.parse.literal", (Object[])new Object[]{this.val}));
        }
    }

    public static class FunctionExpression
    extends Expression {
        private static final Map<String, IFunction> FUNCTIONS = ImmutableMap.builder().put((Object)"sqrt", Math::sqrt).put((Object)"abs", Math::abs).put((Object)"floor", Math::floor).put((Object)"ceil", Math::ceil).put((Object)"ln", Math::log).put((Object)"log", (Object)new IFunction(){

            @Override
            public double eval(double ... inputs) {
                if (inputs.length == 1) {
                    return Math.log10(inputs[0]);
                }
                return Math.log(inputs[0]) / Math.log(inputs[1]);
            }

            @Override
            public boolean isAcceptableInputCount(int count) {
                return count == 1 || count == 2;
            }
        }).put((Object)"sin", Math::sin).put((Object)"cos", Math::cos).put((Object)"tan", Math::tan).put((Object)"csc", n -> 1.0 / Math.sin(n)).put((Object)"sec", n -> 1.0 / Math.cos(n)).put((Object)"cot", n -> 1.0 / Math.tan(n)).put((Object)"asin", Math::asin).put((Object)"acos", Math::acos).put((Object)"atan", Math::atan).put((Object)"atan2", Math::atan2).put((Object)"acsc", n -> Math.asin(1.0 / n)).put((Object)"asec", n -> Math.acos(1.0 / n)).put((Object)"acot", n -> Math.atan(1.0 / n)).put((Object)"sinh", Math::sinh).put((Object)"cosh", Math::cosh).put((Object)"tanh", Math::tanh).put((Object)"csch", n -> 1.0 / Math.sinh(n)).put((Object)"sech", n -> 1.0 / Math.cosh(n)).put((Object)"coth", n -> 1.0 / Math.tanh(n)).put((Object)"asinh", n -> Math.log(n + Math.sqrt(1.0 + n * n))).put((Object)"acosh", n -> Math.log(n + Math.sqrt(n * n - 1.0))).put((Object)"atanh", n -> 0.5 * Math.log((1.0 + n) / (1.0 - n))).put((Object)"acsch", n -> {
            if (n < 0.0) {
                return Math.log((1.0 - Math.sqrt(1.0 + n * n)) / n);
            }
            if (n > 0.0) {
                return Math.log((1.0 + Math.sqrt(1.0 + n * n)) / n);
            }
            return Double.NaN;
        }).put((Object)"asech", n -> {
            if (n < -1.0) {
                return Math.log((1.0 - Math.sqrt(1.0 - n * n)) / n);
            }
            if (n > 0.0) {
                return Math.log((1.0 + Math.sqrt(1.0 - n * n)) / n);
            }
            return Double.NaN;
        }).put((Object)"acoth", n -> 0.5 * Math.log((n + 1.0) / (n - 1.0))).put((Object)"and", vals -> Arrays.stream(vals).mapToInt(val -> (int)val).reduce(-1, (a, b) -> a & b)).put((Object)"or", vals -> Arrays.stream(vals).mapToInt(val -> (int)val).reduce(0, (a, b) -> a | b)).put((Object)"xor", vals -> Arrays.stream(vals).mapToInt(val -> (int)val).reduce(0, (a, b) -> a ^ b)).put((Object)"not", val -> ~((int)val)).build();
        private final String type;
        private final IFunction function;
        private final Expression[] arguments;

        public FunctionExpression(String type, IFunction function, Expression ... arguments) {
            this.type = type;
            this.function = function;
            this.arguments = arguments;
        }

        @Override
        public double eval() {
            double[] args = new double[this.arguments.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.arguments[i].eval();
            }
            return this.function.eval(args);
        }

        @Override
        public class_2561 getParsedTree(int depth) {
            class_5250 argumentsText = class_2561.method_43470((String)"");
            boolean first = true;
            for (Expression argument : this.arguments) {
                if (first) {
                    first = false;
                } else {
                    argumentsText.method_27693(", ");
                }
                argumentsText.method_10852(argument.getParsedTree(depth + 1));
            }
            return FunctionExpression.getDepthStyled(depth, class_2561.method_43469((String)"commands.ccalc.parse.function", (Object[])new Object[]{this.type, argumentsText}));
        }

        private static interface IFunction {
            public double eval(double ... var1);

            public boolean isAcceptableInputCount(int var1);
        }

        @FunctionalInterface
        private static interface UnaryFunction
        extends IFunction {
            public double evalUnary(double var1);

            @Override
            default public double eval(double ... inputs) {
                return this.evalUnary(inputs[0]);
            }

            @Override
            default public boolean isAcceptableInputCount(int count) {
                return count == 1;
            }
        }

        @FunctionalInterface
        private static interface BinaryFunction
        extends IFunction {
            public double evalBinary(double var1, double var3);

            @Override
            default public double eval(double ... inputs) {
                return this.evalBinary(inputs[0], inputs[1]);
            }

            @Override
            default public boolean isAcceptableInputCount(int count) {
                return count == 2;
            }
        }

        @FunctionalInterface
        private static interface TwoOrMoreFunction
        extends IFunction {
            @Override
            default public boolean isAcceptableInputCount(int count) {
                return count >= 2;
            }
        }
    }

    private static class ConstantExpression
    extends Expression {
        private static final Map<String, DoubleSupplier> CONSTANTS = ImmutableMap.of((Object)"pi", () -> Math.PI, (Object)"e", () -> Math.E, (Object)"ans", () -> Configs.calcAnswer);
        private final String type;
        private final DoubleSupplier constant;

        public ConstantExpression(String type, DoubleSupplier constant) {
            this.type = type;
            this.constant = constant;
        }

        @Override
        public double eval() {
            return this.constant.getAsDouble();
        }

        @Override
        public class_2561 getParsedTree(int depth) {
            return ConstantExpression.getDepthStyled(depth, class_2561.method_43469((String)"commands.ccalc.parse.constant", (Object[])new Object[]{this.type}));
        }
    }

    private static class NegateExpression
    extends Expression {
        private final Expression right;

        public NegateExpression(Expression right) {
            this.right = right;
        }

        @Override
        public double eval() {
            return -this.right.eval();
        }

        @Override
        public class_2561 getParsedTree(int depth) {
            return NegateExpression.getDepthStyled(depth, class_2561.method_43469((String)"commands.ccalc.parse.negate", (Object[])new Object[]{this.right.getParsedTree(depth + 1)}));
        }
    }

    private static class BinaryOpExpression
    extends Expression {
        private final Expression left;
        private final Expression right;
        private final DoubleBinaryOperator operator;
        private final String type;

        public BinaryOpExpression(Expression left, Expression right, DoubleBinaryOperator operator, String type) {
            this.left = left;
            this.right = right;
            this.operator = operator;
            this.type = type;
        }

        @Override
        public double eval() {
            return this.operator.applyAsDouble(this.left.eval(), this.right.eval());
        }

        @Override
        public class_2561 getParsedTree(int depth) {
            return BinaryOpExpression.getDepthStyled(depth, class_2561.method_43469((String)("commands.ccalc.parse.binaryOperator." + this.type), (Object[])new Object[]{this.left.getParsedTree(depth + 1), this.right.getParsedTree(depth + 1)}));
        }
    }
}

