/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.xpple.clientarguments.arguments.CGameProfileArgumentType;
import java.util.Collection;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class PingCommand {
    private static final SimpleCommandExceptionType PLAYER_IN_SINGLEPLAYER_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cping.singleplayer"));
    private static final SimpleCommandExceptionType PLAYER_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cping.playerNotFound"));
    private static final SimpleCommandExceptionType TOO_MANY_PLAYERS_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cping.tooManyPlayers"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cping").executes(ctx -> PingCommand.printPing((FabricClientCommandSource)ctx.getSource()))).then(ClientCommandManager.argument((String)"player", (ArgumentType)CGameProfileArgumentType.gameProfile()).executes(ctx -> PingCommand.printPing((FabricClientCommandSource)ctx.getSource(), CGameProfileArgumentType.getCProfileArgument((CommandContext)ctx, (String)"player")))));
    }

    private static int printPing(FabricClientCommandSource source) throws CommandSyntaxException {
        if (source.getClient().method_1542()) {
            throw PLAYER_IN_SINGLEPLAYER_EXCEPTION.create();
        }
        int ping = PingCommand.getLocalPing();
        if (ping == -1) {
            throw PLAYER_IN_SINGLEPLAYER_EXCEPTION.create();
        }
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cping.success", (Object[])new Object[]{ping}));
        return 1;
    }

    private static int printPing(FabricClientCommandSource source, Collection<GameProfile> profiles) throws CommandSyntaxException {
        if (source.getClient().method_1542()) {
            throw PLAYER_IN_SINGLEPLAYER_EXCEPTION.create();
        }
        if (profiles.isEmpty()) {
            throw PLAYER_NOT_FOUND_EXCEPTION.create();
        }
        if (profiles.size() > 1) {
            throw TOO_MANY_PLAYERS_EXCEPTION.create();
        }
        GameProfile profile = profiles.iterator().next();
        class_634 packetListener = source.getClient().method_1562();
        assert (packetListener != null);
        class_640 player = packetListener.method_2871(profile.getId());
        if (player == null) {
            throw PLAYER_NOT_FOUND_EXCEPTION.create();
        }
        int ping = player.method_2959();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cping.success.other", (Object[])new Object[]{profile.getName(), ping}));
        return 1;
    }

    public static int getLocalPing() {
        class_634 packetListener = class_310.method_1551().method_1562();
        if (packetListener == null) {
            return -1;
        }
        class_640 localPlayer = packetListener.method_2871(packetListener.method_2879().getId());
        if (localPlayer == null) {
            return -1;
        }
        return localPlayer.method_2959();
    }
}

