/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.earthcomputer.clientcommands.command.PreviewScreen;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.slf4j.Logger;

public class KitCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType SAVE_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ckit.saveFile.failed"));
    private static final DynamicCommandExceptionType ALREADY_EXISTS_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.ckit.create.alreadyExists", (Object[])new Object[]{arg}));
    private static final SimpleCommandExceptionType NOT_CREATIVE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ckit.load.notCreative"));
    private static final DynamicCommandExceptionType NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.ckit.notFound", (Object[])new Object[]{arg}));
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("clientcommands");
    private static final Map<String, class_2499> kits = new HashMap<String, class_2499>();

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ckit").then(ClientCommandManager.literal((String)"create").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> KitCommand.create((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(ClientCommandManager.literal((String)"delete").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9265(kits.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> KitCommand.delete((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(ClientCommandManager.literal((String)"edit").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9265(kits.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> KitCommand.edit((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(ClientCommandManager.literal((String)"load").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9265(kits.keySet(), (SuggestionsBuilder)builder)).then(ClientCommandManager.literal((String)"--override").executes(ctx -> KitCommand.load((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), true)))).executes(ctx -> KitCommand.load((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), false))))).then(ClientCommandManager.literal((String)"list").executes(ctx -> KitCommand.list((FabricClientCommandSource)ctx.getSource())))).then(ClientCommandManager.literal((String)"preview").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9265(kits.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> KitCommand.preview((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))));
    }

    private static int create(FabricClientCommandSource source, String name) throws CommandSyntaxException {
        if (kits.containsKey(name)) {
            throw ALREADY_EXISTS_EXCEPTION.create((Object)name);
        }
        kits.put(name, source.getPlayer().method_31548().method_7384(new class_2499()));
        KitCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ckit.create.success", (Object[])new Object[]{name}));
        return 1;
    }

    private static int delete(FabricClientCommandSource source, String name) throws CommandSyntaxException {
        if (kits.remove(name) == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        KitCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ckit.delete.success", (Object[])new Object[]{name}));
        return 1;
    }

    private static int edit(FabricClientCommandSource source, String name) throws CommandSyntaxException {
        if (!kits.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        kits.put(name, source.getPlayer().method_31548().method_7384(new class_2499()));
        KitCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ckit.edit.success", (Object[])new Object[]{name}));
        return 1;
    }

    private static int load(FabricClientCommandSource source, String name, boolean override) throws CommandSyntaxException {
        if (!source.getPlayer().method_31549().field_7477) {
            throw NOT_CREATIVE_EXCEPTION.create();
        }
        class_2499 kit = kits.get(name);
        if (kit == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        class_1661 tempInv = new class_1661((class_1657)source.getPlayer());
        tempInv.method_7397(kit);
        class_2371 slots = source.getPlayer().field_7498.field_7761;
        for (int i = 0; i < slots.size(); ++i) {
            class_1799 itemStack;
            if (((class_1735)slots.get((int)i)).field_7871 != source.getPlayer().method_31548() || (itemStack = tempInv.method_5438(((class_1735)slots.get(i)).method_34266())).method_7960() && !override) continue;
            source.getClient().field_1761.method_2909(itemStack, i);
        }
        source.getPlayer().field_7498.method_7623();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ckit.load.success", (Object[])new Object[]{name}));
        return 1;
    }

    private static int list(FabricClientCommandSource source) {
        if (kits.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.ckit.list.empty"));
        } else {
            String list = String.join((CharSequence)", ", kits.keySet());
            source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ckit.list", (Object[])new Object[]{list}));
        }
        return kits.size();
    }

    private static int preview(FabricClientCommandSource source, String name) throws CommandSyntaxException {
        class_2499 kit = kits.get(name);
        if (kit == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        class_1661 tempInv = new class_1661((class_1657)source.getPlayer());
        tempInv.method_7397(kit);
        source.getClient().method_18858(() -> source.getClient().method_1507((class_437)new PreviewScreen(new class_1723(tempInv, true, (class_1657)source.getPlayer()), tempInv, name)));
        return 1;
    }

    private static void saveFile() throws CommandSyntaxException {
        try {
            class_2487 rootTag = new class_2487();
            class_2487 compoundTag = new class_2487();
            kits.forEach((arg_0, arg_1) -> ((class_2487)compoundTag).method_10566(arg_0, arg_1));
            rootTag.method_10569("DataVersion", class_155.method_16673().method_37912().method_38494());
            rootTag.method_10566("Kits", (class_2520)compoundTag);
            Path newFile = File.createTempFile("kits", ".dat", configPath.toFile()).toPath();
            class_2507.method_10630((class_2487)rootTag, (Path)newFile);
            Path backupFile = configPath.resolve("kits.dat_old");
            Path currentFile = configPath.resolve("kits.dat");
            class_156.method_30626((Path)currentFile, (Path)newFile, (Path)backupFile);
        }
        catch (IOException e) {
            throw SAVE_FAILED_EXCEPTION.create();
        }
    }

    private static void loadFile() throws IOException {
        kits.clear();
        class_2487 rootTag = class_2507.method_10633((Path)configPath.resolve("kits.dat"));
        if (rootTag == null) {
            return;
        }
        int currentVersion = class_155.method_16673().method_37912().method_38494();
        int fileVersion = rootTag.method_10550("DataVersion");
        class_2487 compoundTag = rootTag.method_10562("Kits");
        DataFixer dataFixer = class_310.method_1551().method_1543();
        if (fileVersion >= currentVersion) {
            compoundTag.method_10541().forEach(key -> kits.put((String)key, compoundTag.method_10554(key, 10)));
        } else {
            compoundTag.method_10541().forEach(key -> {
                class_2499 updatedListTag = new class_2499();
                compoundTag.method_10554(key, 10).forEach(tag -> {
                    Dynamic oldTagDynamic = new Dynamic((DynamicOps)class_2509.field_11560, tag);
                    Dynamic newTagDynamic = dataFixer.update(class_1208.field_5712, oldTagDynamic, fileVersion, currentVersion);
                    updatedListTag.add((Object)((class_2520)newTagDynamic.getValue()));
                });
                kits.put((String)key, updatedListTag);
            });
        }
    }

    static {
        try {
            KitCommand.loadFile();
        }
        catch (IOException e) {
            LOGGER.error("Could not load kits file, hence /ckit will not work!", (Throwable)e);
        }
    }
}

