/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.xpple.clientarguments.arguments.CBlockPosArgumentType;
import dev.xpple.clientarguments.arguments.CEntityArgumentType;
import dev.xpple.clientarguments.arguments.CNbtPathArgumentType;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2338;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3161;
import net.minecraft.class_3162;
import net.minecraft.class_3169;
import net.minecraft.class_3532;

public class GetDataCommand {
    private static final DynamicCommandExceptionType GET_UNKNOWN_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.data.get.unknown", (Object[])new Object[]{arg}));
    private static final SimpleCommandExceptionType GET_MULTIPLE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.data.get.multiple"));
    private static final SimpleCommandExceptionType INVALID_BLOCK_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.data.block.invalid"));
    public static final Function<String, AccessorType> CLIENT_ENTITY_DATA_ACCESSOR = argName -> new AccessorType((String)argName){
        final /* synthetic */ String val$argName;
        {
            this.val$argName = string;
        }

        @Override
        public class_3162 getAccessor(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
            return new class_3169(CEntityArgumentType.getCEntity(ctx, (String)this.val$argName));
        }

        @Override
        public ArgumentBuilder<FabricClientCommandSource, ?> addArgumentsToBuilder(ArgumentBuilder<FabricClientCommandSource, ?> builder, Function<ArgumentBuilder<FabricClientCommandSource, ?>, ArgumentBuilder<FabricClientCommandSource, ?>> subcommandAdder) {
            return builder.then(ClientCommandManager.literal((String)"entity").then(subcommandAdder.apply((ArgumentBuilder<FabricClientCommandSource, ?>)ClientCommandManager.argument((String)this.val$argName, (ArgumentType)CEntityArgumentType.entity()))));
        }
    };
    public static final Function<String, AccessorType> CLIENT_TILE_ENTITY_DATA_OBJECT = argName -> new AccessorType((String)argName){
        final /* synthetic */ String val$argName;
        {
            this.val$argName = string;
        }

        @Override
        public class_3162 getAccessor(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
            class_2338 pos = CBlockPosArgumentType.getCBlockPos(ctx, (String)(this.val$argName + "Pos"));
            class_2586 blockEntity = class_310.method_1551().field_1687.method_8321(pos);
            if (blockEntity == null) {
                throw INVALID_BLOCK_EXCEPTION.create();
            }
            return new class_3161(blockEntity, pos);
        }

        @Override
        public ArgumentBuilder<FabricClientCommandSource, ?> addArgumentsToBuilder(ArgumentBuilder<FabricClientCommandSource, ?> builder, Function<ArgumentBuilder<FabricClientCommandSource, ?>, ArgumentBuilder<FabricClientCommandSource, ?>> subcommandAdder) {
            return builder.then(ClientCommandManager.literal((String)"block").then(subcommandAdder.apply((ArgumentBuilder<FabricClientCommandSource, ?>)ClientCommandManager.argument((String)(this.val$argName + "Pos"), (ArgumentType)CBlockPosArgumentType.blockPos()))));
        }
    };
    public static List<Function<String, AccessorType>> OBJECT_TYPES = ImmutableList.of(CLIENT_ENTITY_DATA_ACCESSOR, CLIENT_TILE_ENTITY_DATA_OBJECT);
    public static List<AccessorType> TARGET_OBJECT_TYPES = (List)OBJECT_TYPES.stream().map(it -> (AccessorType)it.apply("target")).collect(ImmutableList.toImmutableList());

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        for (AccessorType objType : TARGET_OBJECT_TYPES) {
            dispatcher.register((LiteralArgumentBuilder)objType.addArgumentsToBuilder((ArgumentBuilder<FabricClientCommandSource, ?>)ClientCommandManager.literal((String)"cgetdata"), builder -> builder.executes(ctx -> GetDataCommand.getData((FabricClientCommandSource)ctx.getSource(), objType.getAccessor((CommandContext<FabricClientCommandSource>)ctx))).then(ClientCommandManager.argument((String)"path", (ArgumentType)CNbtPathArgumentType.nbtPath()).executes(ctx -> GetDataCommand.getData((FabricClientCommandSource)ctx.getSource(), objType.getAccessor((CommandContext<FabricClientCommandSource>)ctx), CNbtPathArgumentType.getCNbtPath((CommandContext)ctx, (String)"path"))))));
        }
    }

    private static int getData(FabricClientCommandSource source, class_3162 accessor) throws CommandSyntaxException {
        source.sendFeedback(accessor.method_13882((class_2520)accessor.method_13881()));
        return 1;
    }

    private static int getData(FabricClientCommandSource source, class_3162 accessor, CNbtPathArgumentType.NbtPath path) throws CommandSyntaxException {
        int ret;
        class_2520 tag = GetDataCommand.getNbt(path, accessor);
        if (tag instanceof class_2514) {
            ret = class_3532.method_15357((double)((class_2514)tag).method_10697());
        } else if (tag instanceof class_2483) {
            ret = ((class_2483)tag).size();
        } else if (tag instanceof class_2487) {
            ret = ((class_2487)tag).method_10546();
        } else if (tag instanceof class_2519) {
            ret = tag.method_10714().length();
        } else {
            throw GET_UNKNOWN_EXCEPTION.create((Object)path.toString());
        }
        source.sendFeedback(accessor.method_13882(tag));
        return ret;
    }

    private static class_2520 getNbt(CNbtPathArgumentType.NbtPath path, class_3162 accessor) throws CommandSyntaxException {
        List tags = path.get((class_2520)accessor.method_13881());
        Iterator tagItr = tags.iterator();
        class_2520 firstTag = (class_2520)tagItr.next();
        if (tagItr.hasNext()) {
            throw GET_MULTIPLE_EXCEPTION.create();
        }
        return firstTag;
    }

    private static interface AccessorType {
        public class_3162 getAccessor(CommandContext<FabricClientCommandSource> var1) throws CommandSyntaxException;

        public ArgumentBuilder<FabricClientCommandSource, ?> addArgumentsToBuilder(ArgumentBuilder<FabricClientCommandSource, ?> var1, Function<ArgumentBuilder<FabricClientCommandSource, ?>, ArgumentBuilder<FabricClientCommandSource, ?>> var2);
    }
}

