/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.xpple.clientarguments.arguments.CItemPredicateArgumentType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.earthcomputer.clientcommands.ClientcommandsDataQueryHandler;
import net.earthcomputer.clientcommands.GuiBlocker;
import net.earthcomputer.clientcommands.MathUtil;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.command.Flag;
import net.earthcomputer.clientcommands.command.arguments.WithStringArgumentType;
import net.earthcomputer.clientcommands.mixin.AbstractContainerMenuAccessor;
import net.earthcomputer.clientcommands.task.SimpleTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3936;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class FindItemCommand {
    private static final Flag<Boolean> FLAG_NO_SEARCH_SHULKER_BOX = Flag.ofFlag("no-search-shulker-box").withShortName('s').build();
    private static final Flag<Boolean> FLAG_KEEP_SEARCHING = Flag.ofFlag("keep-searching").build();

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 context) {
        LiteralCommandNode cfinditem = dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cfinditem").then(ClientCommandManager.argument((String)"item", WithStringArgumentType.withString(CItemPredicateArgumentType.itemPredicate((class_7157)context))).executes(ctx -> FindItemCommand.findItem((CommandContext<FabricClientCommandSource>)ctx, ClientCommandHelper.getFlag((CommandContext<FabricClientCommandSource>)ctx, FLAG_NO_SEARCH_SHULKER_BOX), ClientCommandHelper.getFlag((CommandContext<FabricClientCommandSource>)ctx, FLAG_KEEP_SEARCHING), WithStringArgumentType.getWithString(ctx, "item", Predicate.class)))));
        FLAG_NO_SEARCH_SHULKER_BOX.addToCommand(dispatcher, (LiteralCommandNode<FabricClientCommandSource>)cfinditem, ctx -> true);
        FLAG_KEEP_SEARCHING.addToCommand(dispatcher, (LiteralCommandNode<FabricClientCommandSource>)cfinditem, ctx -> true);
    }

    private static int findItem(CommandContext<FabricClientCommandSource> ctx, boolean noSearchShulkerBox, boolean keepSearching, Pair<String, Predicate<class_1799>> item) {
        String taskName = TaskManager.addTask("cfinditem", FindItemCommand.makeFindItemsTask((String)item.getLeft(), (Predicate)item.getRight(), !noSearchShulkerBox, keepSearching));
        if (keepSearching) {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfinditem.starting.keepSearching", (Object[])new Object[]{item.getLeft()}).method_27693(" ").method_10852(ClientCommandHelper.getCommandTextComponent("commands.client.cancel", "/ctask stop " + taskName)));
        } else {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfinditem.starting", (Object[])new Object[]{item.getLeft()}));
        }
        return 1;
    }

    private static SimpleTask makeFindItemsTask(String searchingForName, Predicate<class_1799> searchingFor, boolean searchShulkerBoxes, boolean keepSearching) {
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        if (player.method_5687(2)) {
            return new NbtQueryFindItemsTask(searchingForName, searchingFor, searchShulkerBoxes, keepSearching);
        }
        return new ClickInventoriesFindItemsTask(searchingForName, searchingFor, searchShulkerBoxes, keepSearching);
    }

    private static class NbtQueryFindItemsTask
    extends AbstractFindItemsTask {
        private static final long MAX_SCAN_TIME = 30000000L;
        private static final int NO_RESPONSE_TIMEOUT = 100;
        private final Set<class_2338> searchedBlocks = new HashSet<class_2338>();
        private boolean isScanning = true;
        private Iterator<class_2338.class_2339> scanningIterator;
        private final Set<class_2338> waitingOnBlocks = new HashSet<class_2338>();
        private int currentlySearchingTimeout;
        @Nullable
        private class_2338 enderChestPosition = null;
        @Nullable
        private Integer numItemsInEnderChest = null;
        private boolean hasPrintedEnderChest = false;

        public NbtQueryFindItemsTask(String searchingForName, Predicate<class_1799> searchingFor, boolean searchShulkerBoxes, boolean keepSearching) {
            super(searchingForName, searchingFor, searchShulkerBoxes, keepSearching);
        }

        @Override
        public boolean condition() {
            return true;
        }

        @Override
        protected void onTick() {
            class_1297 cameraEntity = class_310.method_1551().field_1719;
            if (cameraEntity == null) {
                this._break();
                return;
            }
            class_638 level = class_310.method_1551().field_1687;
            assert (level != null);
            if (this.isScanning) {
                long startTime = System.nanoTime();
                if (this.scanningIterator == null) {
                    class_243 cameraPos = cameraEntity.method_5836(0.0f);
                    this.scanningIterator = class_2338.method_30512((class_2338)new class_2338(class_3532.method_15357((double)cameraPos.field_1352) >> 4, 0, class_3532.method_15357((double)cameraPos.field_1350) >> 4), (int)((Integer)class_310.method_1551().field_1690.method_42503().method_41753()), (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035).iterator();
                }
                while (this.scanningIterator.hasNext()) {
                    class_2338 chunkPosAsBlockPos = (class_2338)this.scanningIterator.next();
                    if (level.method_8402(chunkPosAsBlockPos.method_10263(), chunkPosAsBlockPos.method_10260(), class_2806.field_12803, false) != null) {
                        this.scanChunk(new class_1923(chunkPosAsBlockPos.method_10263(), chunkPosAsBlockPos.method_10260()), cameraEntity);
                    }
                    if (System.nanoTime() - startTime <= 30000000L) continue;
                    return;
                }
                this.isScanning = false;
            }
            if (this.waitingOnBlocks.isEmpty() && (this.enderChestPosition == null || this.numItemsInEnderChest != null)) {
                if (this.keepSearching) {
                    this.isScanning = true;
                } else {
                    this._break();
                }
                return;
            }
            if (this.currentlySearchingTimeout > 0) {
                --this.currentlySearchingTimeout;
            } else {
                this._break();
            }
        }

        private void scanChunk(class_1923 chunkToScan, class_1297 cameraEntity) {
            class_746 player = class_310.method_1551().field_1724;
            assert (player != null);
            class_638 level = class_310.method_1551().field_1687;
            assert (level != null);
            class_634 packetListener = class_310.method_1551().method_1562();
            assert (packetListener != null);
            if (this.enderChestPosition != null && this.numItemsInEnderChest != null && !this.hasPrintedEnderChest) {
                class_243 cameraPos = cameraEntity.method_5836(0.0f);
                double enderChestDistanceSq = this.enderChestPosition.method_19770((class_2374)cameraPos);
                int cameraChunkX = class_3532.method_15357((double)cameraPos.field_1352) >> 4;
                int cameraChunkZ = class_3532.method_15357((double)cameraPos.field_1350) >> 4;
                int currentChunkRadius = Math.max(Math.abs(cameraChunkX - chunkToScan.field_9181), Math.abs(cameraChunkZ - chunkToScan.field_9180));
                double closestPossibleDistance = (double)(currentChunkRadius - 1 << 4) + Math.min(Math.min(cameraPos.field_1352 - (double)(cameraChunkX << 4), cameraPos.field_1350 - (double)(cameraChunkZ << 4)), Math.min((double)(cameraChunkX + 1 << 4) - cameraPos.field_1352, (double)(cameraChunkZ + 1 << 4) - cameraPos.field_1350));
                if (enderChestDistanceSq < closestPossibleDistance * closestPossibleDistance) {
                    this.hasPrintedEnderChest = true;
                    if (this.numItemsInEnderChest > 0) {
                        this.printLocation(this.enderChestPosition, this.numItemsInEnderChest);
                    }
                }
            }
            class_2818 chunk = level.method_8497(chunkToScan.field_9181, chunkToScan.field_9180);
            int minSection = chunk.method_32891();
            int maxSection = chunk.method_31597();
            for (int sectionY = minSection; sectionY < maxSection; ++sectionY) {
                if (!chunk.method_38259(chunk.method_31603(sectionY)).method_19523(state -> state.method_27852(class_2246.field_10443) || state.method_31709())) continue;
                for (class_2338 pos : class_2338.method_10094((int)chunkToScan.method_8326(), (int)(sectionY << 4), (int)chunkToScan.method_8328(), (int)chunkToScan.method_8327(), (int)((sectionY << 4) + 15), (int)chunkToScan.method_8329())) {
                    class_2338 currentPos;
                    if (this.searchedBlocks.contains(pos)) continue;
                    class_2680 state2 = chunk.method_8320(pos);
                    if (state2.method_27852(class_2246.field_10443)) {
                        currentPos = pos.method_10062();
                        this.searchedBlocks.add(currentPos);
                        if (this.enderChestPosition == null) {
                            this.enderChestPosition = currentPos;
                            this.currentlySearchingTimeout = 100;
                            ClientcommandsDataQueryHandler.get(packetListener).queryEntityNbt(player.method_5628(), playerNbt -> {
                                int numItemsInEnderChest = 0;
                                if (playerNbt != null && playerNbt.method_10573("EnderItems", 9)) {
                                    numItemsInEnderChest = this.countItems(playerNbt.method_10554("EnderItems", 10));
                                }
                                this.numItemsInEnderChest = numItemsInEnderChest;
                                this.totalFound += numItemsInEnderChest;
                                this.currentlySearchingTimeout = 100;
                            });
                            continue;
                        }
                        if (this.hasPrintedEnderChest) continue;
                        class_243 cameraPos = cameraEntity.method_5836(0.0f);
                        double currentDistanceSq = this.enderChestPosition.method_19770((class_2374)cameraPos);
                        double newDistanceSq = currentPos.method_19770((class_2374)cameraPos);
                        if (!(newDistanceSq < currentDistanceSq)) continue;
                        this.enderChestPosition = currentPos;
                        continue;
                    }
                    if (!(chunk.method_8321(pos) instanceof class_1263)) continue;
                    currentPos = pos.method_10062();
                    this.searchedBlocks.add(currentPos);
                    this.waitingOnBlocks.add(currentPos);
                    this.currentlySearchingTimeout = 100;
                    ClientcommandsDataQueryHandler.get(packetListener).queryBlockNbt(currentPos, blockNbt -> {
                        int count;
                        this.waitingOnBlocks.remove(currentPos);
                        if (blockNbt != null && blockNbt.method_10573("Items", 9) && (count = this.countItems(blockNbt.method_10554("Items", 10))) > 0) {
                            this.totalFound += count;
                            this.printLocation(currentPos, count);
                        }
                        this.currentlySearchingTimeout = 100;
                    });
                }
            }
        }

        @Override
        public void onCompleted() {
            if (this.enderChestPosition != null && this.numItemsInEnderChest != null && this.numItemsInEnderChest > 0 && !this.hasPrintedEnderChest) {
                this.printLocation(this.enderChestPosition, this.numItemsInEnderChest);
            }
            super.onCompleted();
        }
    }

    private static class ClickInventoriesFindItemsTask
    extends AbstractFindItemsTask {
        private final Set<class_2338> searchedBlocks = new HashSet<class_2338>();
        private class_2338 currentlySearching = null;
        private int currentlySearchingTimeout;
        private boolean hasSearchedEnderChest = false;

        public ClickInventoriesFindItemsTask(String searchingForName, Predicate<class_1799> searchingFor, boolean searchShulkerBoxes, boolean keepSearching) {
            super(searchingForName, searchingFor, searchShulkerBoxes, keepSearching);
        }

        @Override
        public boolean condition() {
            return true;
        }

        @Override
        protected void onTick() {
            class_1297 entity = class_310.method_1551().field_1719;
            if (entity == null) {
                this._break();
                return;
            }
            class_638 level = class_310.method_1551().field_1687;
            assert (level != null);
            class_746 player = class_310.method_1551().field_1724;
            assert (player != null);
            class_636 gameMode = class_310.method_1551().field_1761;
            assert (gameMode != null);
            if (this.currentlySearchingTimeout > 0) {
                --this.currentlySearchingTimeout;
                return;
            }
            if (player.method_5715()) {
                return;
            }
            class_243 origin = entity.method_5836(0.0f);
            float reachDistance = gameMode.method_2904();
            int minX = class_3532.method_15357((double)(origin.field_1352 - (double)reachDistance));
            int minY = class_3532.method_15357((double)(origin.field_1351 - (double)reachDistance));
            int minZ = class_3532.method_15357((double)(origin.field_1350 - (double)reachDistance));
            int maxX = class_3532.method_15357((double)(origin.field_1352 + (double)reachDistance));
            int maxY = class_3532.method_15357((double)(origin.field_1351 + (double)reachDistance));
            int maxZ = class_3532.method_15357((double)(origin.field_1350 + (double)reachDistance));
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        class_2338 offsetPos;
                        class_2680 state;
                        class_243 closestPos;
                        class_2338 pos = new class_2338(x, y, z);
                        if (!this.canSearch((class_1937)level, pos) || this.searchedBlocks.contains(pos) || (closestPos = MathUtil.getClosestPoint(pos, (state = level.method_8320(pos)).method_26218((class_1922)level, pos), origin)).method_1025(origin) > (double)(reachDistance * reachDistance)) continue;
                        this.searchedBlocks.add(pos);
                        if (state.method_26204() == class_2246.field_10443) {
                            if (this.hasSearchedEnderChest) continue;
                            this.hasSearchedEnderChest = true;
                        } else if (state.method_26204() instanceof class_2281 && state.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569 && level.method_8320(offsetPos = pos.method_10093(class_2281.method_9758((class_2680)state))).method_26204() == state.method_26204()) {
                            this.searchedBlocks.add(offsetPos);
                        }
                        this.startSearch(pos, origin, closestPos);
                        this.scheduleDelay();
                        return;
                    }
                }
            }
            if (!this.keepSearching) {
                this._break();
            }
        }

        private boolean canSearch(class_1937 level, class_2338 pos) {
            class_2680 state = level.method_8320(pos);
            class_2586 blockEntity = level.method_8321(pos);
            if (!(blockEntity instanceof class_1263) && state.method_26204() != class_2246.field_10443) {
                return false;
            }
            if (state.method_26204() instanceof class_2281 || state.method_26204() == class_2246.field_10443) {
                if (class_2281.method_9756((class_1936)level, (class_2338)pos)) {
                    return false;
                }
                if (state.method_26204() instanceof class_2281 && state.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569) {
                    class_2338 offsetPos = pos.method_10093(class_2281.method_9758((class_2680)state));
                    return level.method_8320(offsetPos).method_26204() != state.method_26204() || !class_2281.method_9756((class_1936)level, (class_2338)offsetPos);
                }
            }
            return true;
        }

        private void startSearch(class_2338 pos, class_243 cameraPos, class_243 clickPos) {
            final class_310 mc = class_310.method_1551();
            this.currentlySearching = pos;
            this.currentlySearchingTimeout = 100;
            GuiBlocker.addBlocker(new GuiBlocker(){

                @Override
                public boolean accept(class_437 screen) {
                    if (!(screen instanceof class_3936)) {
                        return true;
                    }
                    class_3936 menuAccess = (class_3936)screen;
                    assert (mc.field_1724 != null);
                    class_1703 container = menuAccess.method_17577();
                    final HashSet<Integer> playerInvSlots = new HashSet<Integer>();
                    for (class_1735 slot : container.field_7761) {
                        if (!(slot.field_7871 instanceof class_1661)) continue;
                        playerInvSlots.add(slot.field_7874);
                    }
                    mc.field_1724.field_7512 = new class_1703(((AbstractContainerMenuAccessor)container).getNullableType(), container.field_7763){

                        public boolean method_7597(class_1657 var1) {
                            return true;
                        }

                        public class_1799 method_7601(class_1657 player, int index) {
                            return class_1799.field_8037;
                        }

                        public void method_7610(int revision, List<class_1799> stacks, class_1799 cursorStack) {
                            int matchingItems = 0;
                            for (int slot = 0; slot < stacks.size(); ++slot) {
                                class_2487 blockEntityTag;
                                if (playerInvSlots.contains(slot)) continue;
                                class_1799 stack = stacks.get(slot);
                                if (searchingFor.test(stack)) {
                                    matchingItems += stack.method_7947();
                                }
                                if (!searchShulkerBoxes || !(stack.method_7909() instanceof class_1747) || !(((class_1747)stack.method_7909()).method_7711() instanceof class_2480) || (blockEntityTag = class_1747.method_38072((class_1799)stack)) == null || !blockEntityTag.method_10573("Items", 9)) continue;
                                matchingItems += this.countItems(blockEntityTag.method_10554("Items", 10));
                            }
                            if (matchingItems > 0) {
                                this.printLocation(currentlySearching, matchingItems);
                                totalFound += matchingItems;
                            }
                            currentlySearching = null;
                            currentlySearchingTimeout = 0;
                            mc.field_1724.method_7346();
                        }
                    };
                    return false;
                }
            });
            assert (mc.field_1761 != null);
            mc.field_1761.method_2896(mc.field_1724, class_1268.field_5808, new class_3965(clickPos, class_2350.method_10147((float)((float)(clickPos.field_1352 - cameraPos.field_1352)), (float)((float)(clickPos.field_1351 - cameraPos.field_1351)), (float)((float)(clickPos.field_1350 - cameraPos.field_1350))), pos, false));
        }
    }

    private static abstract class AbstractFindItemsTask
    extends SimpleTask {
        protected final String searchingForName;
        protected final Predicate<class_1799> searchingFor;
        protected final boolean searchShulkerBoxes;
        protected final boolean keepSearching;
        protected int totalFound = 0;

        private AbstractFindItemsTask(String searchingForName, Predicate<class_1799> searchingFor, boolean searchShulkerBoxes, boolean keepSearching) {
            this.searchingForName = searchingForName;
            this.searchingFor = searchingFor;
            this.searchShulkerBoxes = searchShulkerBoxes;
            this.keepSearching = keepSearching;
        }

        protected int countItems(class_2499 inventory) {
            int result = 0;
            for (int i = 0; i < inventory.size(); ++i) {
                class_2487 blockEntityNbt;
                class_1747 block;
                class_1792 class_17922;
                class_2487 compound = inventory.method_10602(i);
                class_1799 stack = class_1799.method_7915((class_2487)compound);
                if (this.searchingFor.test(stack)) {
                    result += stack.method_7947();
                }
                if (!this.searchShulkerBoxes || !((class_17922 = stack.method_7909()) instanceof class_1747) || !((block = (class_1747)class_17922).method_7711() instanceof class_2480) || (blockEntityNbt = class_1747.method_38072((class_1799)stack)) == null || !blockEntityNbt.method_10573("Items", 9)) continue;
                result += this.countItems(blockEntityNbt.method_10554("Items", 10));
            }
            return result;
        }

        protected void printLocation(class_2338 pos, int count) {
            ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfinditem.match.left", (Object[])new Object[]{count, this.searchingForName}).method_10852(ClientCommandHelper.getLookCoordsTextComponent(pos)).method_27693(" ").method_10852(ClientCommandHelper.getGlowCoordsTextComponent(class_2561.method_43471((String)"commands.cfindblock.success.glow"), pos)).method_10852((class_2561)class_2561.method_43469((String)"commands.cfinditem.match.right", (Object[])new Object[]{count, this.searchingForName})));
        }

        @Override
        public void onCompleted() {
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"commands.cfinditem.total", (Object[])new Object[]{this.totalFound, this.searchingForName}).method_27692(class_124.field_1067));
        }
    }
}

