/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.xpple.clientarguments.arguments.CEntityArgumentType;
import dev.xpple.clientarguments.arguments.CEntitySelector;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.command.Flag;
import net.earthcomputer.clientcommands.task.LongTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class FindCommand {
    private static final Flag<Boolean> FLAG_KEEP_SEARCHING = Flag.ofFlag("keep-searching").build();
    private static final SimpleCommandExceptionType NO_MATCH_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cfind.noMatch"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode cfind = dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cfind").then(ClientCommandManager.argument((String)"filter", (ArgumentType)CEntityArgumentType.entities()).executes(ctx -> FindCommand.listEntities((FabricClientCommandSource)ctx.getSource(), (CEntitySelector)ctx.getArgument("filter", CEntitySelector.class)))));
        FLAG_KEEP_SEARCHING.addToCommand(dispatcher, (LiteralCommandNode<FabricClientCommandSource>)cfind, ctx -> true);
    }

    private static int listEntities(FabricClientCommandSource source, CEntitySelector selector) throws CommandSyntaxException {
        boolean keepSearching = ClientCommandHelper.getFlag(source, FLAG_KEEP_SEARCHING);
        if (keepSearching) {
            String taskName = TaskManager.addTask("cfind", new FindTask(source, selector));
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cfind.keepSearching.success").method_27693(" ").method_10852(ClientCommandHelper.getCommandTextComponent("commands.client.cancel", "/ctask stop " + taskName)));
            return 1;
        }
        List entities = selector.getEntities(source);
        if (entities.isEmpty()) {
            throw NO_MATCH_EXCEPTION.create();
        }
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfind.success", (Object[])new Object[]{entities.size()}).method_27692(class_124.field_1067));
        for (class_1297 entity : entities) {
            FindCommand.sendEntityFoundMessage(source, entity);
        }
        return entities.size();
    }

    private static void sendEntityFoundMessage(FabricClientCommandSource source, class_1297 entity) {
        String distance = "%.2f".formatted(Math.sqrt(entity.method_5707(source.getPosition())));
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfind.found.left", (Object[])new Object[]{entity.method_5477(), distance}).method_10852(ClientCommandHelper.getLookCoordsTextComponent(entity.method_24515())).method_10852((class_2561)class_2561.method_43469((String)"commands.cfind.found.right", (Object[])new Object[]{entity.method_5477(), distance})));
    }

    private static class FindTask
    extends LongTask {
        private final FabricClientCommandSource source;
        private final CEntitySelector selector;
        private final Set<UUID> foundEntities = new HashSet<UUID>();

        private FindTask(FabricClientCommandSource source, CEntitySelector selector) {
            this.source = source;
            this.selector = selector;
        }

        @Override
        public void initialize() {
        }

        @Override
        public boolean condition() {
            return class_310.method_1551().field_1724 != null;
        }

        @Override
        public void increment() {
        }

        @Override
        public void body() {
            try {
                for (class_1297 entity : this.selector.getEntities(this.source)) {
                    if (!this.foundEntities.add(entity.method_5667())) continue;
                    FindCommand.sendEntityFoundMessage(this.source, entity);
                }
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            this.scheduleDelay();
        }
    }
}

