/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Objects;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.command.arguments.ClientBlockPredicateArgumentType;
import net.earthcomputer.clientcommands.command.arguments.WithStringArgumentType;
import net.earthcomputer.clientcommands.task.RenderDistanceScanTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_638;
import net.minecraft.class_7157;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class FindBlockCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 context) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cfindblock").then(ClientCommandManager.argument((String)"block", WithStringArgumentType.withString(ClientBlockPredicateArgumentType.blockPredicate(context))).executes(ctx -> {
            Pair<String, ClientBlockPredicateArgumentType.ParseResult> blockWithString = WithStringArgumentType.getWithString(ctx, "block", ClientBlockPredicateArgumentType.ParseResult.class);
            return FindBlockCommand.findBlock((class_2561)class_2561.method_43469((String)"commands.cfindblock.starting", (Object[])new Object[]{blockWithString.getLeft()}), ClientBlockPredicateArgumentType.getBlockPredicate((ClientBlockPredicateArgumentType.ParseResult)blockWithString.getRight()));
        })));
    }

    public static int findBlock(class_2561 startingMessage, ClientBlockPredicateArgumentType.ClientBlockPredicate block) {
        ClientCommandHelper.sendFeedback(startingMessage);
        TaskManager.addTask("cfindblock", new FindBlockTask(block));
        return 1;
    }

    private static final class FindBlockTask
    extends RenderDistanceScanTask {
        private final ClientBlockPredicateArgumentType.ClientBlockPredicate predicate;
        @Nullable
        private class_2338 closestBlock;

        FindBlockTask(ClientBlockPredicateArgumentType.ClientBlockPredicate predicate) {
            super(false);
            this.predicate = predicate;
        }

        @Override
        protected void scanBlock(class_1297 cameraEntity, class_2338 pos) {
            class_638 level = class_310.method_1551().field_1687;
            assert (level != null);
            class_243 cameraPos = cameraEntity.method_5836(0.0f);
            if ((this.closestBlock == null || pos.method_19770((class_2374)cameraPos) < this.closestBlock.method_19770((class_2374)cameraPos)) && this.predicate.test((class_1922)level, pos)) {
                this.closestBlock = pos.method_10062();
            }
        }

        @Override
        protected boolean canScanChunk(class_1297 cameraEntity, class_1923 pos) {
            return (this.closestBlock == null || this.hasAnyBlockCloserThan(cameraEntity, pos, this.closestBlock.method_19770((class_2374)cameraEntity.method_5836(0.0f)))) && super.canScanChunk(cameraEntity, pos);
        }

        @Override
        protected boolean canScanChunkSection(class_1297 cameraEntity, class_4076 pos) {
            return this.hasBlockState(pos, this.predicate::canEverMatch) && super.canScanChunkSection(cameraEntity, pos);
        }

        @Override
        public void onCompleted() {
            if (this.closestBlock == null) {
                ClientCommandHelper.sendError((class_2561)class_2561.method_43471((String)"commands.cfindblock.notFound"));
            } else {
                class_1297 cameraEntity = (class_1297)Objects.requireNonNullElse(class_310.method_1551().field_1719, class_310.method_1551().field_1724);
                String foundRadius = "%.2f".formatted(Math.sqrt(this.closestBlock.method_19770((class_2374)cameraEntity.method_5836(0.0f))));
                ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfindblock.success.left", (Object[])new Object[]{foundRadius}).method_10852(ClientCommandHelper.getLookCoordsTextComponent(this.closestBlock)).method_27693(" ").method_10852(ClientCommandHelper.getGlowCoordsTextComponent(class_2561.method_43471((String)"commands.cfindblock.success.glow"), this.closestBlock)).method_10852((class_2561)class_2561.method_43469((String)"commands.cfindblock.success.right", (Object[])new Object[]{foundRadius})));
            }
        }
    }
}

