/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import dev.xpple.clientarguments.arguments.CItemStackArgumentType;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import net.minecraft.class_7708;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class CreativeTabCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DynamicCommandExceptionType NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.ccreativetab.notFound", (Object[])new Object[]{arg}));
    private static final DynamicCommandExceptionType OUT_OF_BOUNDS_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.ccreativetab.outOfBounds", (Object[])new Object[]{arg}));
    private static final SimpleCommandExceptionType SAVE_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ccreativetab.saveFile.failed"));
    private static final DynamicCommandExceptionType ILLEGAL_CHARACTER_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.ccreativetab.addTab.illegalCharacter", (Object[])new Object[]{arg}));
    private static final DynamicCommandExceptionType ALREADY_EXISTS_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.ccreativetab.addTab.alreadyExists", (Object[])new Object[]{arg}));
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("clientcommands");
    private static final Map<String, Tab> tabs = new HashMap<String, Tab>();

    public static void registerItemGroups() {
        try {
            CreativeTabCommand.loadFile();
        }
        catch (IOException e) {
            LOGGER.error("Could not load groups file, hence /ccreativetab will not work!", (Throwable)e);
        }
        tabs.forEach((key, tab) -> tab.registerItemGroup((String)key));
    }

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ccreativetab").then(ClientCommandManager.literal((String)"modify").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)ClientCommandManager.argument((String)"tab", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9265(tabs.keySet(), (SuggestionsBuilder)builder)).then(ClientCommandManager.literal((String)"add").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"itemstack", (ArgumentType)CItemStackArgumentType.itemStack((class_7157)context)).then(ClientCommandManager.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CreativeTabCommand.addStack((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"tab"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"itemstack").method_9781(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), false))))).executes(ctx -> CreativeTabCommand.addStack((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"tab"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"itemstack").method_9781(1, false)))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CreativeTabCommand.removeStack((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"tab"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index")))))).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"itemstack", (ArgumentType)CItemStackArgumentType.itemStack((class_7157)context)).then(ClientCommandManager.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CreativeTabCommand.setStack((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"tab"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"itemstack").method_9781(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), false))))).executes(ctx -> CreativeTabCommand.setStack((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"tab"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"itemstack").method_9781(1, false))))))).then(ClientCommandManager.literal((String)"icon").then(ClientCommandManager.argument((String)"icon", (ArgumentType)CItemStackArgumentType.itemStack((class_7157)context)).executes(ctx -> CreativeTabCommand.changeIcon((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"tab"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"icon").method_9781(1, false)))))).then(ClientCommandManager.literal((String)"rename").then(ClientCommandManager.argument((String)"new", (ArgumentType)StringArgumentType.string()).executes(ctx -> CreativeTabCommand.renameTab((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"tab"), StringArgumentType.getString((CommandContext)ctx, (String)"new")))))))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"tab", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"icon", (ArgumentType)CItemStackArgumentType.itemStack((class_7157)context)).executes(ctx -> CreativeTabCommand.addTab((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"tab"), CItemStackArgumentType.getCItemStackArgument((CommandContext)ctx, (String)"icon").method_9781(1, false))))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"tab", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9265(tabs.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> CreativeTabCommand.removeTab((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"tab"))))));
    }

    private static int addTab(FabricClientCommandSource source, String name, class_1799 icon) throws CommandSyntaxException {
        if (tabs.containsKey(name)) {
            throw ALREADY_EXISTS_EXCEPTION.create((Object)name);
        }
        class_2960 identifier = class_2960.method_12829((String)("clientcommands:" + name));
        if (identifier == null) {
            throw ILLEGAL_CHARACTER_EXCEPTION.create((Object)name);
        }
        tabs.put(name, new Tab(icon, new class_2499()));
        CreativeTabCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ccreativetab.addTab.success", (Object[])new Object[]{name}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int removeTab(FabricClientCommandSource source, String name) throws CommandSyntaxException {
        if (!tabs.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        tabs.remove(name);
        CreativeTabCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ccreativetab.removeTab.success", (Object[])new Object[]{name}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int addStack(FabricClientCommandSource source, String name, class_1799 itemStack) throws CommandSyntaxException {
        if (!tabs.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        Tab tab = tabs.get(name);
        class_2499 items = tab.items();
        items.add((Object)itemStack.method_7953(new class_2487()));
        CreativeTabCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ccreativetab.addStack.success", (Object[])new Object[]{itemStack.method_7909().method_7848(), name}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int removeStack(FabricClientCommandSource source, String name, int index) throws CommandSyntaxException {
        if (!tabs.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        Tab tab = tabs.get(name);
        class_2499 items = tab.items();
        if (index < 0 || index >= items.size()) {
            throw OUT_OF_BOUNDS_EXCEPTION.create((Object)index);
        }
        items.method_10536(index);
        CreativeTabCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ccreativetab.removeStack.success", (Object[])new Object[]{name, index}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int setStack(FabricClientCommandSource source, String name, int index, class_1799 itemStack) throws CommandSyntaxException {
        if (!tabs.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        Tab tab = tabs.get(name);
        class_2499 items = tab.items();
        if (index < 0 || index >= items.size()) {
            throw OUT_OF_BOUNDS_EXCEPTION.create((Object)index);
        }
        items.method_10606(index, (class_2520)itemStack.method_7953(new class_2487()));
        CreativeTabCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ccreativetab.setStack.success", (Object[])new Object[]{name, index, itemStack.method_7909().method_7848()}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int changeIcon(FabricClientCommandSource source, String name, class_1799 icon) throws CommandSyntaxException {
        if (!tabs.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        Tab tab = tabs.get(name);
        class_2499 items = tab.items();
        class_1799 old = tab.icon();
        tabs.put(name, new Tab(icon, items));
        CreativeTabCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ccreativetab.changeIcon.success", (Object[])new Object[]{name, old.method_7909().method_7848(), icon.method_7909().method_7848()}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static int renameTab(FabricClientCommandSource source, String name, String _new) throws CommandSyntaxException {
        if (!tabs.containsKey(name)) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        class_2960 identifier = class_2960.method_12829((String)("clientcommands:" + _new));
        if (identifier == null) {
            throw ILLEGAL_CHARACTER_EXCEPTION.create((Object)_new);
        }
        Tab tab = tabs.remove(name);
        tabs.put(_new, tab);
        CreativeTabCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ccreativetab.renameTab.success", (Object[])new Object[]{name, _new}));
        ClientCommandHelper.sendRequiresRestart();
        return 1;
    }

    private static void saveFile() throws CommandSyntaxException {
        try {
            class_2487 rootTag = new class_2487();
            class_2487 compoundTag = new class_2487();
            tabs.forEach((key, value) -> {
                class_2487 tab = new class_2487();
                tab.method_10566("icon", (class_2520)value.icon().method_7953(new class_2487()));
                tab.method_10566("items", (class_2520)value.items());
                compoundTag.method_10566(key, (class_2520)tab);
            });
            rootTag.method_10569("DataVersion", class_155.method_16673().method_37912().method_38494());
            rootTag.method_10566("CreativeTabs", (class_2520)compoundTag);
            Path newFile = File.createTempFile("creative_tabs", ".dat", configPath.toFile()).toPath();
            class_2507.method_10630((class_2487)rootTag, (Path)newFile);
            Path backupFile = configPath.resolve("creative_tabs.dat_old");
            Path currentFile = configPath.resolve("creative_tabs.dat");
            class_156.method_30626((Path)currentFile, (Path)newFile, (Path)backupFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw SAVE_FAILED_EXCEPTION.create();
        }
    }

    private static void loadFile() throws IOException {
        tabs.clear();
        class_2487 rootTag = class_2507.method_10633((Path)configPath.resolve("creative_tabs.dat"));
        if (rootTag == null) {
            try {
                Files.move(configPath.resolve("groups.dat"), configPath.resolve("creative_tabs.dat"), new CopyOption[0]);
            }
            catch (NoSuchFileException e) {
                return;
            }
            rootTag = class_2507.method_10633((Path)configPath.resolve("creative_tabs.dat"));
            if (rootTag == null) {
                return;
            }
        }
        int currentVersion = class_155.method_16673().method_37912().method_38494();
        int fileVersion = rootTag.method_10550("DataVersion");
        class_2487 compoundTag = rootTag.method_10562("CreativeTabs");
        if (compoundTag.method_33133()) {
            compoundTag = rootTag.method_10562("Groups");
        }
        DataFixer dataFixer = class_310.method_1551().method_1543();
        if (fileVersion >= currentVersion) {
            for (String key : compoundTag.method_10541()) {
                if (class_2960.method_12829((String)("clientcommands:" + key)) == null) {
                    LOGGER.warn("Skipping creative tab with invalid name {}", (Object)key);
                    return;
                }
                class_2487 tab = compoundTag.method_10562(key);
                class_1799 icon = CreativeTabCommand.singleItemFromNbt(tab.method_10562("icon"));
                class_2499 items = tab.method_10554("items", 10);
                tabs.put(key, new Tab(icon, items));
            }
        } else {
            for (String key : compoundTag.method_10541()) {
                if (class_2960.method_12829((String)("clientcommands:" + key)) == null) {
                    LOGGER.warn("Skipping creative tab with invalid name {}", (Object)key);
                    return;
                }
                class_2487 tab = compoundTag.method_10562(key);
                Dynamic oldStackDynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)tab.method_10562("icon"));
                Dynamic newStackDynamic = dataFixer.update(class_1208.field_5712, oldStackDynamic, fileVersion, currentVersion);
                class_1799 icon = CreativeTabCommand.singleItemFromNbt((class_2487)newStackDynamic.getValue());
                class_2499 updatedListTag = new class_2499();
                tab.method_10554("items", 10).forEach(tag -> {
                    Dynamic oldTagDynamic = new Dynamic((DynamicOps)class_2509.field_11560, tag);
                    Dynamic newTagDynamic = dataFixer.update(class_1208.field_5712, oldTagDynamic, fileVersion, currentVersion);
                    updatedListTag.add((Object)((class_2520)newTagDynamic.getValue()));
                });
                tabs.put(key, new Tab(icon, updatedListTag));
            }
        }
    }

    private static class_1799 singleItemFromNbt(class_2487 nbt) {
        class_1799 stack = class_1799.method_7915((class_2487)nbt);
        if (!stack.method_7960()) {
            stack.method_7939(1);
        }
        return stack;
    }

    private record Tab(class_1799 icon, class_2499 items) {
        void registerItemGroup(String key) {
            class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)new class_2960("clientcommands", key), (Object)FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43470((String)key)).method_47320(() -> this.icon).method_47317((displayContext, entries) -> {
                Set existingStacks = class_7708.method_47572();
                for (int i = 0; i < this.items.size(); ++i) {
                    class_1799 stack = CreativeTabCommand.singleItemFromNbt(this.items.method_10602(i));
                    if (stack.method_7960()) continue;
                    stack.method_7939(1);
                    if (!existingStacks.add(stack)) continue;
                    entries.method_45420(stack);
                }
            }).method_47324());
        }
    }
}

