/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.c2c;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.earthcomputer.clientcommands.c2c.C2CPacket;
import net.earthcomputer.clientcommands.c2c.packets.MessageC2CPacket;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public class CCPacketHandler {
    private static final Object2IntMap<Class<? extends C2CPacket>> packetIds = (Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> map.defaultReturnValue(-1));
    private static final List<Function<class_2540, ? extends C2CPacket>> packetFactories = new ArrayList<Function<class_2540, ? extends C2CPacket>>();

    public static <P extends C2CPacket> void register(Class<P> packet, Function<class_2540, P> packetFactory) {
        int id = packetFactories.size();
        int i = packetIds.put(packet, id);
        if (i != -1) {
            String string = "Packet " + packet + " is already registered to ID " + i;
            throw new IllegalArgumentException(string);
        }
        packetFactories.add(packetFactory);
    }

    @Nullable
    public static <P extends C2CPacket> Integer getId(Class<P> packet) {
        int id = packetIds.getInt(packet);
        return id == -1 ? null : Integer.valueOf(id);
    }

    @Nullable
    public static C2CPacket createPacket(int id, class_2540 buf) {
        Function<class_2540, ? extends C2CPacket> function = packetFactories.get(id);
        return function == null ? null : function.apply(buf);
    }

    static {
        CCPacketHandler.register(MessageC2CPacket.class, MessageC2CPacket::new);
    }
}

