/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands;

import com.google.common.collect.Iterables;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_3532;

public class MathUtil {
    private static final double EPSILON = 0.001;

    public static class_243 getClosestPoint(class_2338 blockPos, class_265 voxel, class_243 pos) {
        return MathUtil.getClosestPoint(blockPos, voxel, pos, null);
    }

    public static class_243 getClosestPoint(class_2338 blockPos, class_265 voxel, class_243 pos, class_2350 dir) {
        class_2350[] class_2350Array;
        ClosestPosResult result = new ClosestPosResult();
        if (dir == null) {
            class_2350Array = class_2350.values();
        } else {
            class_2350[] class_2350Array2 = new class_2350[1];
            class_2350Array = class_2350Array2;
            class_2350Array2[0] = dir;
        }
        class_2350[] dirs = class_2350Array;
        voxel.method_1089((x1, y1, z1, x2, y2, z2) -> {
            class_238 box = new class_238(x1, y1, z1, x2, y2, z2).method_996(blockPos);
            for (class_2350 face : dirs) {
                class_238 faceBox = MathUtil.getFace(box, face);
                class_243 val = new class_243(class_3532.method_15350((double)pos.field_1352, (double)faceBox.field_1323, (double)faceBox.field_1320), class_3532.method_15350((double)pos.field_1351, (double)faceBox.field_1322, (double)faceBox.field_1325), class_3532.method_15350((double)pos.field_1350, (double)faceBox.field_1321, (double)faceBox.field_1324));
                double distanceSq = val.method_1025(pos);
                if (!(distanceSq < result.distanceSq)) continue;
                result.val = val;
                result.distanceSq = distanceSq;
            }
        });
        return result.val;
    }

    public static class_243 getClosestVisiblePoint(class_1937 level, class_2338 targetPos, class_243 sourcePos, class_1297 excludingEntity) {
        return MathUtil.getClosestVisiblePoint(level, targetPos, sourcePos, excludingEntity, null);
    }

    public static class_243 getClosestVisiblePoint(class_1937 level, class_2338 targetPos, class_243 sourcePos, class_1297 excludingEntity, class_2350 dir) {
        class_2350[] class_2350Array;
        if (targetPos.method_40081(sourcePos.field_1352, sourcePos.field_1351, sourcePos.field_1350) > 49.0) {
            return null;
        }
        class_238 totalArea = new class_238(sourcePos, class_243.method_24954((class_2382)targetPos));
        ArrayList<class_238> obscurers = new ArrayList<class_238>();
        for (class_2338 pos : class_2338.method_10094((int)class_3532.method_15357((double)totalArea.field_1323), (int)class_3532.method_15357((double)totalArea.field_1322), (int)class_3532.method_15357((double)totalArea.field_1321), (int)class_3532.method_15384((double)totalArea.field_1320), (int)class_3532.method_15384((double)totalArea.field_1325), (int)class_3532.method_15384((double)totalArea.field_1324))) {
            if (pos.equals((Object)targetPos)) continue;
            level.method_8320(pos).method_26218((class_1922)level, pos).method_1089((x1, y1, z1, x2, y2, z2) -> obscurers.add(new class_238(x1, y1, z1, x2, y2, z2).method_996(pos).method_1014(0.001)));
        }
        for (class_1297 entity2 : level.method_8333(excludingEntity, totalArea, entity -> !entity.method_7325() && entity.method_5863())) {
            obscurers.add(entity2.method_5829().method_1014((double)entity2.method_5871() + 0.001));
        }
        ArrayList targetBoxes = new ArrayList();
        level.method_8320(targetPos).method_26218((class_1922)level, targetPos).method_1089((x1, y1, z1, x2, y2, z2) -> targetBoxes.add(new class_238(x1, y1, z1, x2, y2, z2).method_996(targetPos)));
        class_243 resultVal = null;
        double resultDistanceSq = Double.POSITIVE_INFINITY;
        if (dir == null) {
            class_2350Array = class_2350.values();
        } else {
            class_2350[] class_2350Array2 = new class_2350[1];
            class_2350Array = class_2350Array2;
            class_2350Array2[0] = dir;
        }
        class_2350[] dirs = class_2350Array;
        for (class_238 box : targetBoxes) {
            for (class_2350 face : dirs) {
                double distanceSq;
                class_243 val;
                class_238 faceBox = MathUtil.getFace(box.method_1014(-0.001), face);
                class_243 class_2432 = new class_243((double)face.method_10148(), (double)face.method_10164(), (double)face.method_10165());
                if (!(sourcePos.method_1023(faceBox.field_1323, faceBox.field_1322, faceBox.field_1321).method_1026(class_2432) > 0.0) || (val = MathUtil.getClosestVisiblePoint((class_1922)level, Iterables.concat(obscurers, (Iterable)Iterables.transform((Iterable)Iterables.filter(targetBoxes, it -> it != box), b -> b.method_1014(0.001))), faceBox, sourcePos, face)) == null || !((distanceSq = val.method_1025(sourcePos)) < resultDistanceSq)) continue;
                resultVal = val;
                resultDistanceSq = distanceSq;
            }
        }
        return resultVal;
    }

    private static class_243 getClosestVisiblePoint(class_1922 level, Iterable<class_238> obscurers, class_238 face, class_243 sourcePos, class_2350 dir) {
        class_2350.class_2351 xAxis;
        class_2350.class_2351 yAxis = switch (dir.method_10166()) {
            case class_2350.class_2351.field_11048 -> {
                xAxis = class_2350.class_2351.field_11051;
                yield class_2350.class_2351.field_11052;
            }
            case class_2350.class_2351.field_11052 -> {
                xAxis = class_2350.class_2351.field_11048;
                yield class_2350.class_2351.field_11051;
            }
            case class_2350.class_2351.field_11051 -> {
                xAxis = class_2350.class_2351.field_11048;
                yield class_2350.class_2351.field_11052;
            }
            default -> throw new AssertionError();
        };
        double minX = MathUtil.getComponent(face.field_1323, face.field_1322, face.field_1321, xAxis);
        double minY = MathUtil.getComponent(face.field_1323, face.field_1322, face.field_1321, yAxis);
        double maxX = MathUtil.getComponent(face.field_1320, face.field_1325, face.field_1324, xAxis);
        double maxY = MathUtil.getComponent(face.field_1320, face.field_1325, face.field_1324, yAxis);
        Area area = new Area(new Rectangle2D.Double(minX + 0.001, minY + 0.001, maxX - minX - 0.002, maxY - minY - 0.002));
        double f = MathUtil.getComponent(face.field_1323, face.field_1322, face.field_1321, dir.method_10166());
        double s = MathUtil.getComponent(sourcePos, dir.method_10166());
        double sx = MathUtil.getComponent(sourcePos, xAxis);
        double sy = MathUtil.getComponent(sourcePos, yAxis);
        for (class_238 obscurer : obscurers) {
            for (class_2350 obscurerSide : class_2350.values()) {
                class_238 obscurerFace = MathUtil.getFace(obscurer, obscurerSide);
                Path2D.Double path = MathUtil.getShadow(sourcePos, obscurerFace, obscurerSide, f, dir, minX + (maxX - minX) * 0.5, minY + (maxY - minY) * 0.5, xAxis, yAxis);
                if (path == null) continue;
                area.subtract(new Area(path));
            }
        }
        if (area.contains(sx, sy)) {
            return MathUtil.createFromComponents(sx, xAxis, sy, yAxis, f, dir.method_10166());
        }
        double closestX = Double.NaN;
        double closestY = Double.NaN;
        double closestDistanceSq = Double.POSITIVE_INFINITY;
        double[] pointsRet = new double[6];
        double lastX = 0.0;
        double lastY = 0.0;
        double firstX = 0.0;
        double firstY = 0.0;
        PathIterator itr = area.getPathIterator(null);
        while (!itr.isDone()) {
            double curY;
            double curX;
            int segtype = itr.currentSegment(pointsRet);
            if (segtype == 4) {
                curX = firstX;
                curY = firstY;
            } else {
                curX = pointsRet[0];
                curY = pointsRet[1];
            }
            if (segtype == 1 || segtype == 4) {
                double newClosestY;
                double newClosestX;
                double relCurX = curX - lastX;
                double relSx = sx - lastX;
                double relCurY = curY - lastY;
                double relSy = sy - lastY;
                double lambda = (relCurX * relSx + relCurY * relSy) / (relCurX * relCurX + relCurY * relCurY);
                if (lambda <= 0.0) {
                    newClosestX = lastX;
                    newClosestY = lastY;
                } else if (lambda >= 1.0) {
                    newClosestX = curX;
                    newClosestY = curY;
                } else {
                    newClosestX = lastX + lambda * relCurX;
                    newClosestY = lastY + lambda * relCurY;
                }
                double dx = newClosestX - sx;
                double dy = newClosestY - sy;
                double newClosestDistanceSq = dx * dx + dy * dy;
                if (newClosestDistanceSq < closestDistanceSq) {
                    closestDistanceSq = newClosestDistanceSq;
                    closestX = newClosestX;
                    closestY = newClosestY;
                }
            }
            lastX = curX;
            lastY = curY;
            if (segtype == 0) {
                firstX = curX;
                firstY = curY;
            }
            itr.next();
        }
        if (Double.isNaN(closestX)) {
            return null;
        }
        return MathUtil.createFromComponents(closestX, xAxis, closestY, yAxis, f, dir.method_10166());
    }

    private static Path2D.Double getShadow(class_243 sourcePos, class_238 obscurerFace, class_2350 obscurerFaceNormal, double targetPlaneCoord, class_2350 targetPlaneNormal, double targetCenterX, double targetCenterY, class_2350.class_2351 xAxis, class_2350.class_2351 yAxis) {
        double lastInfiniteY;
        double lastInfiniteX;
        double firstInfiniteY;
        double firstInfiniteX;
        double dy;
        double c;
        double dx1;
        double dx2;
        double b;
        double dy2;
        double dz1;
        double dz2;
        double dy3;
        double c2;
        double dx12;
        double dx22;
        double b2;
        double dy22;
        double dz12;
        double dz22;
        int lastInFront;
        int firstInFront;
        double sourceOffset = MathUtil.getComponent(sourcePos, targetPlaneNormal.method_10166());
        double[][] obscurer = new double[4][3];
        boolean[] behindSource = new boolean[4];
        class_2350 dirB = obscurerFaceNormal.method_10166() == class_2350.class_2351.field_11052 ? class_2350.field_11039 : obscurerFaceNormal.method_10170();
        class_2350 dirC = MathUtil.rotateClockwise(obscurerFaceNormal, dirB.method_10166());
        for (int i = 0; i < 4; ++i) {
            class_238 vertex = MathUtil.getFace(MathUtil.getFace(obscurerFace, i < 2 ? dirB : dirB.method_10153()), i == 0 || i == 3 ? dirC : dirC.method_10153());
            obscurer[i][0] = vertex.field_1323;
            obscurer[i][1] = vertex.field_1322;
            obscurer[i][2] = vertex.field_1321;
            double vertexOffset = MathUtil.getComponent(vertex.field_1323, vertex.field_1322, vertex.field_1321, targetPlaneNormal.method_10166());
            behindSource[i] = sourceOffset < targetPlaneCoord ? vertexOffset < sourceOffset : vertexOffset > sourceOffset;
        }
        if (behindSource[0] && behindSource[1] && behindSource[2] && behindSource[3]) {
            return null;
        }
        if (!behindSource[0] && !behindSource[3] && (behindSource[1] || behindSource[2])) {
            firstInFront = behindSource[2] ? 3 : 2;
            lastInFront = behindSource[1] ? 0 : 1;
        } else {
            firstInFront = 0;
            while (behindSource[firstInFront]) {
                ++firstInFront;
            }
            lastInFront = 3;
            while (behindSource[lastInFront]) {
                --lastInFront;
            }
        }
        double firstShadowX = 0.0;
        double firstShadowY = 0.0;
        double lastShadowX = 0.0;
        double lastShadowY = 0.0;
        Path2D.Double path = new Path2D.Double(1, 6);
        for (int i = firstInFront; i <= lastInFront; ++i) {
            double lambda = (targetPlaneCoord - sourceOffset) / (MathUtil.getComponent(obscurer[i][0], obscurer[i][1], obscurer[i][2], targetPlaneNormal.method_10166()) - sourceOffset);
            if (!Double.isFinite(lambda)) {
                return null;
            }
            class_243 projected = sourcePos.method_1031((obscurer[i][0] - sourcePos.field_1352) * lambda, (obscurer[i][1] - sourcePos.field_1351) * lambda, (obscurer[i][2] - sourcePos.field_1350) * lambda);
            double x = MathUtil.getComponent(projected, xAxis);
            double y = MathUtil.getComponent(projected, yAxis);
            if (i == firstInFront) {
                path.moveTo(x, y);
                firstShadowX = x;
                firstShadowY = y;
            } else {
                path.lineTo(x, y);
            }
            if (i != lastInFront) continue;
            lastShadowX = x;
            lastShadowY = y;
        }
        if (firstInFront == 0 && lastInFront == 3) {
            path.closePath();
            return path;
        }
        int lastBehind = firstInFront == 0 ? 3 : firstInFront - 1;
        double dy1 = obscurer[lastBehind][1] - obscurer[firstInFront][1];
        double a = dy1 * (dz22 = obscurer[firstInFront][2] - sourcePos.field_1350) - (dz12 = obscurer[lastBehind][2] - obscurer[firstInFront][2]) * (dy22 = obscurer[firstInFront][1] - sourcePos.field_1351);
        double dx = -MathUtil.getComponent(a, b2 = dz12 * (dx22 = obscurer[firstInFront][0] - sourcePos.field_1352) - (dx12 = obscurer[lastBehind][0] - obscurer[firstInFront][0]) * dz22, c2 = dx12 * dy22 - dy1 * dx22, xAxis);
        double n = Math.sqrt(dx * dx + (dy3 = MathUtil.getComponent(a, b2, c2, yAxis)) * dy3);
        if (n < 0.001) {
            return null;
        }
        double lastDx = dx / n;
        double lastDy = dy3 / n;
        int firstBehind = lastInFront == 3 ? 0 : lastInFront + 1;
        double dy12 = obscurer[firstBehind][1] - obscurer[lastInFront][1];
        double a2 = dy12 * (dz2 = obscurer[lastInFront][2] - sourcePos.field_1350) - (dz1 = obscurer[firstBehind][2] - obscurer[lastInFront][2]) * (dy2 = obscurer[lastInFront][1] - sourcePos.field_1351);
        double dx3 = -MathUtil.getComponent(a2, b = dz1 * (dx2 = obscurer[lastInFront][0] - sourcePos.field_1352) - (dx1 = obscurer[firstBehind][0] - obscurer[lastInFront][0]) * dz2, c = dx1 * dy2 - dy12 * dx2, xAxis);
        double n2 = Math.sqrt(dx3 * dx3 + (dy = MathUtil.getComponent(a2, b, c, yAxis)) * dy);
        if (n2 < 0.001) {
            return null;
        }
        double firstDy = dy / n2;
        double firstDx = dx3 / n2;
        double det = (lastShadowX - targetCenterX) * (lastShadowY + firstDy - targetCenterY) - (lastShadowX + firstDx - targetCenterX) * (lastShadowY - targetCenterY);
        double descriminant = 100.0 - det * det;
        if (descriminant < 0.0) {
            double dx4 = lastShadowX - targetCenterX;
            double dy4 = lastShadowY - targetCenterY;
            double n3 = Math.sqrt(dx4 * dx4 + dy4 * dy4);
            firstInfiniteX = targetCenterX + dx4 / n3 * 10.0;
            firstInfiniteY = targetCenterY + dy4 / n3 * 10.0;
        } else {
            double y2;
            descriminant = Math.sqrt(descriminant);
            double x1 = firstDy < 0.0 ? det * firstDy - firstDx * descriminant : det * firstDy + firstDx * descriminant;
            double x2 = firstDy < 0.0 ? det * firstDy + firstDx * descriminant : det * firstDy - firstDx * descriminant;
            double y1 = -det * firstDx + Math.abs(firstDy) * descriminant;
            if (firstDx * x1 + firstDy * y1 > firstDx * x2 + firstDy * (y2 = -det * firstDx - Math.abs(firstDy) * descriminant)) {
                firstInfiniteX = x1 + targetCenterX;
                firstInfiniteY = y1 + targetCenterY;
            } else {
                firstInfiniteX = x2 + targetCenterX;
                firstInfiniteY = y2 + targetCenterY;
            }
        }
        double det2 = (firstShadowX - targetCenterX) * (firstShadowY + lastDy - targetCenterY) - (firstShadowX + lastDx - targetCenterX) * (firstShadowY - targetCenterY);
        double descriminant2 = 100.0 - det2 * det2;
        if (descriminant2 < 0.0) {
            double dx5 = firstShadowX - targetCenterX;
            double dy5 = firstShadowY - targetCenterY;
            double n4 = Math.sqrt(dx5 * dx5 + dy5 * dy5);
            lastInfiniteX = targetCenterX + dx5 / n4 * 10.0;
            lastInfiniteY = targetCenterY + dy5 / n4 * 10.0;
        } else {
            double y2;
            descriminant2 = Math.sqrt(descriminant2);
            double x1 = lastDy < 0.0 ? det2 * lastDy - lastDx * descriminant2 : det2 * lastDy + lastDx * descriminant2;
            double x2 = lastDy < 0.0 ? det2 * lastDy + lastDx * descriminant2 : det2 * lastDy - lastDx * descriminant2;
            double y1 = -det2 * lastDx + Math.abs(lastDy) * descriminant2;
            if (lastDx * x1 + lastDy * y1 > lastDx * x2 + lastDy * (y2 = -det2 * lastDx - Math.abs(lastDy) * descriminant2)) {
                lastInfiniteX = x1 + targetCenterX;
                lastInfiniteY = y1 + targetCenterY;
            } else {
                lastInfiniteX = x2 + targetCenterX;
                lastInfiniteY = y2 + targetCenterY;
            }
        }
        boolean clockwise = firstDx * lastDy < firstDy * lastDx;
        double firstAngle = Math.atan2(firstInfiniteY - targetCenterY, firstInfiniteX - targetCenterX);
        double targetAngle = Math.atan2(lastInfiniteY - targetCenterY, lastInfiniteX - targetCenterX);
        double angleDifference = (clockwise ? firstAngle - targetAngle : targetAngle - firstAngle) % Math.PI * 2.0;
        if (angleDifference < 0.0) {
            angleDifference += Math.PI * 2;
        }
        for (double dTheta = 0.0; dTheta < angleDifference; dTheta += 1.0471975511965976) {
            double theta = clockwise ? firstAngle - dTheta : firstAngle + dTheta;
            path.moveTo(10.0 * Math.cos(theta) + targetCenterX, 10.0 * Math.sin(theta) + targetCenterY);
        }
        path.moveTo(10.0 * Math.cos(targetAngle) + targetCenterX, 10.0 * Math.sin(targetAngle + targetCenterY));
        path.closePath();
        return path;
    }

    private static double getComponent(class_243 vec, class_2350.class_2351 axis) {
        return MathUtil.getComponent(vec.field_1352, vec.field_1351, vec.field_1350, axis);
    }

    private static double getComponent(double x, double y, double z, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> x;
            case class_2350.class_2351.field_11052 -> y;
            case class_2350.class_2351.field_11051 -> z;
        };
    }

    private static class_243 createFromComponents(double a, class_2350.class_2351 aAxis, double b, class_2350.class_2351 bAxis, double c, class_2350.class_2351 cAxis) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        switch (aAxis) {
            case field_11048: {
                x = a;
                break;
            }
            case field_11052: {
                y = a;
                break;
            }
            case field_11051: {
                z = a;
            }
        }
        switch (bAxis) {
            case field_11048: {
                x = b;
                break;
            }
            case field_11052: {
                y = b;
                break;
            }
            case field_11051: {
                z = b;
            }
        }
        switch (cAxis) {
            case field_11048: {
                x = c;
                break;
            }
            case field_11052: {
                y = c;
                break;
            }
            case field_11051: {
                z = c;
            }
        }
        return new class_243(x, y, z);
    }

    private static class_238 getFace(class_238 box, class_2350 dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11039 -> new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1323, box.field_1325, box.field_1324);
            case class_2350.field_11034 -> new class_238(box.field_1320, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
            case class_2350.field_11033 -> new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1322, box.field_1324);
            case class_2350.field_11036 -> new class_238(box.field_1323, box.field_1325, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
            case class_2350.field_11043 -> new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1321);
            case class_2350.field_11035 -> new class_238(box.field_1323, box.field_1322, box.field_1324, box.field_1320, box.field_1325, box.field_1324);
        };
    }

    public static class_2350 rotateClockwise(class_2350 dir, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                if (dir != class_2350.field_11039 && dir != class_2350.field_11034) {
                    return MathUtil.rotateXClockwise(dir);
                }
                return dir;
            }
            case field_11052: {
                if (dir != class_2350.field_11036 && dir != class_2350.field_11033) {
                    return dir.method_10170();
                }
                return dir;
            }
            case field_11051: {
                if (dir != class_2350.field_11043 && dir != class_2350.field_11035) {
                    return MathUtil.rotateZClockwise(dir);
                }
                return dir;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axis);
    }

    public static class_2350 rotateXClockwise(class_2350 dir) {
        return switch (dir) {
            case class_2350.field_11043 -> class_2350.field_11033;
            case class_2350.field_11035 -> class_2350.field_11036;
            case class_2350.field_11036 -> class_2350.field_11043;
            case class_2350.field_11033 -> class_2350.field_11035;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + dir);
        };
    }

    public static class_2350 rotateZClockwise(class_2350 dir) {
        return switch (dir) {
            case class_2350.field_11034 -> class_2350.field_11033;
            case class_2350.field_11039 -> class_2350.field_11036;
            case class_2350.field_11036 -> class_2350.field_11034;
            case class_2350.field_11033 -> class_2350.field_11039;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + dir);
        };
    }

    private static class ClosestPosResult {
        class_243 val;
        double distanceSq = Double.POSITIVE_INFINITY;

        private ClosestPosResult() {
        }
    }
}

