/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import dev.xpple.betterconfig.api.ModConfigBuilder;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.command.AliasCommand;
import net.earthcomputer.clientcommands.command.AreaStatsCommand;
import net.earthcomputer.clientcommands.command.AuditMixinsCommand;
import net.earthcomputer.clientcommands.command.BookCommand;
import net.earthcomputer.clientcommands.command.CEnchantCommand;
import net.earthcomputer.clientcommands.command.CFunctionCommand;
import net.earthcomputer.clientcommands.command.CGameModeCommand;
import net.earthcomputer.clientcommands.command.CGiveCommand;
import net.earthcomputer.clientcommands.command.CParticleCommand;
import net.earthcomputer.clientcommands.command.CPlaySoundCommand;
import net.earthcomputer.clientcommands.command.CStopSoundCommand;
import net.earthcomputer.clientcommands.command.CTeleportCommand;
import net.earthcomputer.clientcommands.command.CTellRawCommand;
import net.earthcomputer.clientcommands.command.CTimeCommand;
import net.earthcomputer.clientcommands.command.CTitleCommand;
import net.earthcomputer.clientcommands.command.CalcCommand;
import net.earthcomputer.clientcommands.command.CalcStackCommand;
import net.earthcomputer.clientcommands.command.ChatCommand;
import net.earthcomputer.clientcommands.command.ChorusCommand;
import net.earthcomputer.clientcommands.command.CrackRNGCommand;
import net.earthcomputer.clientcommands.command.CreativeTabCommand;
import net.earthcomputer.clientcommands.command.FindBlockCommand;
import net.earthcomputer.clientcommands.command.FindCommand;
import net.earthcomputer.clientcommands.command.FindItemCommand;
import net.earthcomputer.clientcommands.command.FishCommand;
import net.earthcomputer.clientcommands.command.FovCommand;
import net.earthcomputer.clientcommands.command.GammaCommand;
import net.earthcomputer.clientcommands.command.GetDataCommand;
import net.earthcomputer.clientcommands.command.GhostBlockCommand;
import net.earthcomputer.clientcommands.command.GlowCommand;
import net.earthcomputer.clientcommands.command.HotbarCommand;
import net.earthcomputer.clientcommands.command.KitCommand;
import net.earthcomputer.clientcommands.command.ListenCommand;
import net.earthcomputer.clientcommands.command.LookCommand;
import net.earthcomputer.clientcommands.command.MoteCommand;
import net.earthcomputer.clientcommands.command.NoteCommand;
import net.earthcomputer.clientcommands.command.PermissionLevelCommand;
import net.earthcomputer.clientcommands.command.PingCommand;
import net.earthcomputer.clientcommands.command.PluginsCommand;
import net.earthcomputer.clientcommands.command.PosCommand;
import net.earthcomputer.clientcommands.command.RelogCommand;
import net.earthcomputer.clientcommands.command.RenderCommand;
import net.earthcomputer.clientcommands.command.ShrugCommand;
import net.earthcomputer.clientcommands.command.SignSearchCommand;
import net.earthcomputer.clientcommands.command.SnakeCommand;
import net.earthcomputer.clientcommands.command.StartupCommand;
import net.earthcomputer.clientcommands.command.TaskCommand;
import net.earthcomputer.clientcommands.command.TooltipCommand;
import net.earthcomputer.clientcommands.command.TranslateCommand;
import net.earthcomputer.clientcommands.command.UsageTreeCommand;
import net.earthcomputer.clientcommands.command.UuidCommand;
import net.earthcomputer.clientcommands.command.VarCommand;
import net.earthcomputer.clientcommands.command.WeatherCommand;
import net.earthcomputer.clientcommands.command.WhisperEncryptedCommand;
import net.earthcomputer.clientcommands.command.WikiCommand;
import net.earthcomputer.clientcommands.features.MappingsHelper;
import net.earthcomputer.clientcommands.render.RenderQueue;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import org.slf4j.Logger;

public class ClientCommands
implements ClientModInitializer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Path configDir;
    private static final Set<String> clientcommandsCommands;
    public static final class_2960 COMMAND_EXECUTION_PACKET_ID;
    private static final Set<String> COMMANDS_TO_NOT_SEND_TO_SERVER;
    public static final boolean SCRAMBLE_WINDOW_TITLE;
    private static final Set<String> CHAT_COMMAND_USERS;

    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register(ClientCommands::registerCommands);
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            context.matrixStack().method_22903();
            class_243 cameraPos = context.camera().method_19326();
            context.matrixStack().method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
            RenderQueue.render(RenderQueue.Layer.ON_TOP, Objects.requireNonNull(context.consumers()).getBuffer(RenderQueue.NO_DEPTH_LAYER), context.matrixStack(), context.tickDelta());
            context.matrixStack().method_22909();
        });
        configDir = FabricLoader.getInstance().getConfigDir().resolve("clientcommands");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create config dir", (Throwable)e);
        }
        new ModConfigBuilder("clientcommands", Configs.class).build();
        CreativeTabCommand.registerItemGroups();
        MappingsHelper.load();
    }

    private static Set<String> getCommands(CommandDispatcher<?> dispatcher) {
        return dispatcher.getRoot().getChildren().stream().flatMap(node -> {
            Stream<Object> stream;
            if (node instanceof LiteralCommandNode) {
                LiteralCommandNode literal = (LiteralCommandNode)node;
                stream = Stream.of(literal.getLiteral());
            } else {
                stream = Stream.empty();
            }
            return stream;
        }).collect(Collectors.toSet());
    }

    public static void sendCommandExecutionToServer(String command) {
        StringReader reader = new StringReader(command);
        reader.skipWhitespace();
        String theCommand = reader.readUnquotedString();
        if (clientcommandsCommands.contains(theCommand) && !COMMANDS_TO_NOT_SEND_TO_SERVER.contains(theCommand) && ClientPlayNetworking.canSend((class_2960)COMMAND_EXECUTION_PACKET_ID)) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10814(command);
            ClientPlayNetworking.send((class_2960)COMMAND_EXECUTION_PACKET_ID, (class_2540)buf);
        }
    }

    public static boolean isClientcommandsCommand(String commandName) {
        return clientcommandsCommands.contains(commandName);
    }

    public static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 context) {
        Set<String> existingCommands = ClientCommands.getCommands(dispatcher);
        AliasCommand.register(dispatcher);
        AreaStatsCommand.register(dispatcher, context);
        AuditMixinsCommand.register(dispatcher);
        BookCommand.register(dispatcher);
        CalcCommand.register(dispatcher);
        CalcStackCommand.register(dispatcher, context);
        CEnchantCommand.register(dispatcher);
        CFunctionCommand.register(dispatcher);
        CGameModeCommand.register(dispatcher);
        CGiveCommand.register(dispatcher, context);
        ChorusCommand.register(dispatcher);
        CParticleCommand.register(dispatcher);
        CPlaySoundCommand.register(dispatcher);
        CrackRNGCommand.register(dispatcher);
        CreativeTabCommand.register(dispatcher, context);
        CStopSoundCommand.register(dispatcher);
        CTeleportCommand.register(dispatcher);
        CTellRawCommand.register(dispatcher);
        CTimeCommand.register(dispatcher);
        CTitleCommand.register(dispatcher);
        FindBlockCommand.register(dispatcher, context);
        FindCommand.register(dispatcher);
        FindItemCommand.register(dispatcher, context);
        FishCommand.register(dispatcher, context);
        FovCommand.register(dispatcher);
        GammaCommand.register(dispatcher);
        GetDataCommand.register(dispatcher);
        GhostBlockCommand.register(dispatcher, context);
        GlowCommand.register(dispatcher);
        HotbarCommand.register(dispatcher);
        KitCommand.register(dispatcher);
        ListenCommand.register(dispatcher);
        LookCommand.register(dispatcher);
        MoteCommand.register(dispatcher);
        NoteCommand.register(dispatcher);
        PermissionLevelCommand.register(dispatcher);
        PingCommand.register(dispatcher);
        PluginsCommand.register(dispatcher);
        PosCommand.register(dispatcher);
        RelogCommand.register(dispatcher);
        RenderCommand.register(dispatcher);
        ShrugCommand.register(dispatcher);
        SignSearchCommand.register(dispatcher);
        SnakeCommand.register(dispatcher);
        StartupCommand.register(dispatcher);
        TaskCommand.register(dispatcher);
        TooltipCommand.register(dispatcher, context);
        TranslateCommand.register(dispatcher);
        UsageTreeCommand.register(dispatcher);
        UuidCommand.register(dispatcher);
        VarCommand.register(dispatcher);
        WeatherCommand.register(dispatcher);
        WhisperEncryptedCommand.register(dispatcher);
        WikiCommand.register(dispatcher);
        Calendar calendar = Calendar.getInstance();
        boolean registerChatCommand = calendar.get(2) == 3 && calendar.get(5) == 1;
        registerChatCommand |= CHAT_COMMAND_USERS.contains(String.valueOf(class_310.method_1551().method_1548().method_44717()));
        if (registerChatCommand |= Boolean.getBoolean("clientcommands.debugChatCommand")) {
            ChatCommand.register(dispatcher);
        }
        clientcommandsCommands.clear();
        for (String command : ClientCommands.getCommands(dispatcher)) {
            if (existingCommands.contains(command)) continue;
            clientcommandsCommands.add(command);
        }
    }

    static {
        clientcommandsCommands = new HashSet<String>();
        COMMAND_EXECUTION_PACKET_ID = new class_2960("clientcommands", "command_execution");
        COMMANDS_TO_NOT_SEND_TO_SERVER = Set.of("cwe", "cnote");
        SCRAMBLE_WINDOW_TITLE = (Boolean)class_156.method_656(() -> {
            String playerUUID = String.valueOf(class_310.method_1551().method_1548().method_44717());
            Set<String> victims = Set.of("fa68270b-1071-46c6-ac5c-6c4a0b777a96", "d4557649-e553-413e-a019-56d14548df96", "8dc3d945-cf90-47c1-a122-a576319d05a7", "c5d72740-cabc-42d1-b789-27859041d553", "e4093360-a200-4f99-aa13-be420b8d9a79", "083fb87e-c9e4-4489-8fb7-a45b06bfca90", "973e8f6e-2f51-4307-97dc-56fdc71d194f");
            return victims.contains(playerUUID) || Boolean.getBoolean("clientcommands.scrambleWindowTitle");
        });
        CHAT_COMMAND_USERS = Set.of("b793c3b9-425f-4dd8-a056-9dec4d835e24", "0071ccd7-467f-4e71-8237-cb15f229a1ff", "c3bca648-b8ce-491d-bf6a-36bb42c5a70b");
    }
}

