/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.mcfeature.structure.generator.structure;

import com.seedfinding.mccore.rand.ChunkRand;
import com.seedfinding.mccore.util.data.Pair;
import com.seedfinding.mccore.util.pos.BPos;
import com.seedfinding.mccore.version.MCVersion;
import com.seedfinding.mccore.version.UnsupportedVersion;
import com.seedfinding.mcfeature.structure.generator.Generator;
import com.seedfinding.mcterrain.TerrainGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class FortressGenerator
extends Generator {
    private static final Random rand = new Random();
    private static final int NORTH = 0;
    private static final int EAST = 1;
    private static final int SOUTH = 2;
    private static final int WEST = 3;
    private static final int START = 0;
    private static final int BRIDGE_FIRST = 1;
    private static final int BRIDGE_STRAIGHT = 1;
    private static final int BRIDGE_CROSSING = 2;
    private static final int BRIDGE_FORTIFIED_CROSSING = 3;
    private static final int BRIDGE_STAIRS = 4;
    private static final int BRIDGE_SPAWNER = 5;
    private static final int BRIDGE_CORRIDOR_ENTRANCE = 6;
    private static final int BRIDGE_PIECES_COUNT = 6;
    private static final int CORRIDOR_FIRST = 7;
    private static final int CORRIDOR_STRAIGHT = 7;
    private static final int CORRIDOR_CROSSING = 8;
    private static final int CORRIDOR_TURN_RIGHT = 9;
    private static final int CORRIDOR_TURN_LEFT = 10;
    private static final int CORRIDOR_STAIRS = 11;
    private static final int CORRIDOR_T_CROSSING = 12;
    private static final int CORRIDOR_NETHER_WART = 13;
    private static final int CORRIDOR_PIECES_COUNT = 7;
    private static final int END = 14;
    private static final int PIECES_COUNT = 15;
    private static final int[] BRIDGE_WEIGHTS = new int[]{30, 10, 10, 10, 5, 5};
    private static final int[] BRIDGE_MAXS = new int[]{0, 4, 4, 3, 2, 1};
    private static final boolean[] BRIDGE_ALLOW_CONSECUTIVE = new boolean[]{true, false, false, false, false, false};
    private static final int[] CORRIDOR_WEIGHTS = new int[]{25, 15, 5, 5, 10, 7, 5};
    private static final int[] CORRIDOR_MAXS = new int[]{0, 5, 10, 10, 3, 2, 2};
    private static final boolean[] CORRIDOR_ALLOW_CONSECUTIVE = new boolean[]{true, false, false, false, true, false, false};
    private static final Creator[] CREATORS = new Creator[]{null, FortressGenerator::createBridgeStraight, FortressGenerator::createBridgeCrossing, FortressGenerator::createBridgeFortifiedCrossing, FortressGenerator::createBridgeStairs, FortressGenerator::createBridgeSpawner, FortressGenerator::createBridgeCorridorEntrance, FortressGenerator::createCorridorStraight, FortressGenerator::createCorridorCrossing, FortressGenerator::createCorridorTurnRight, FortressGenerator::createCorridorTurnLeft, FortressGenerator::createCorridorStairs, FortressGenerator::createCorridorTCrossing, FortressGenerator::createCorridorNetherWart};
    private static final Runnable[] POST_CREATORS = new Runnable[]{() -> {}, () -> {}, () -> {}, () -> {}, () -> {}, () -> {}, () -> {}, () -> {}, () -> {}, () -> rand.nextInt(3), () -> rand.nextInt(3), () -> {}, () -> {}, () -> {}};
    private static final List<PieceInfo>[] placements = new List[15];
    private static final List<PieceInfo> pieceQueue = new ArrayList<PieceInfo>();
    private static PieceInfo start;
    private static int lastPlaced;
    private static final Extender[] EXTENDERS;

    public FortressGenerator(MCVersion version) {
        super(version);
    }

    private static void genFortress(int chunkX, int chunkZ, MCVersion version) {
        if (version.isOlderThan(MCVersion.v1_12)) {
            throw new UnsupportedVersion(version, "fortress generator.");
        }
        start = FortressGenerator.createStart((chunkX << 4) + 2, 64, (chunkZ << 4) + 2);
        placements[0].add(start);
        FortressGenerator.extendBridgeCrossing(start);
        while (!pieceQueue.isEmpty()) {
            int i = rand.nextInt(pieceQueue.size());
            PieceInfo piece = pieceQueue.remove(i);
            assert (EXTENDERS[piece.type] != null);
            EXTENDERS[piece.type].extend(piece);
        }
    }

    private static PieceInfo createStart(int x, int y, int z) {
        return new PieceInfo(0, 0, x, y, z, x + 19 - 1, 73, z + 19 - 1, rand.nextInt(4));
    }

    private static PieceInfo createBridgeStraight(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(1, depth, x, y, z, -1, -3, 0, 5, 10, 19, facing);
    }

    private static PieceInfo createBridgeCrossing(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(2, depth, x, y, z, -8, -3, 0, 19, 10, 19, facing);
    }

    private static PieceInfo createBridgeFortifiedCrossing(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(3, depth, x, y, z, -2, 0, 0, 7, 9, 7, facing);
    }

    private static PieceInfo createBridgeStairs(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(4, depth, x, y, z, -2, 0, 0, 7, 11, 7, facing);
    }

    private static PieceInfo createBridgeSpawner(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(5, depth, x, y, z, -2, 0, 0, 7, 8, 9, facing);
    }

    private static PieceInfo createBridgeCorridorEntrance(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(6, depth, x, y, z, -5, -3, 0, 13, 14, 13, facing);
    }

    private static PieceInfo createCorridorStraight(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(7, depth, x, y, z, -1, 0, 0, 5, 7, 5, facing);
    }

    private static PieceInfo createCorridorCrossing(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(8, depth, x, y, z, -1, 0, 0, 5, 7, 5, facing);
    }

    private static PieceInfo createCorridorTurnRight(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(9, depth, x, y, z, -1, 0, 0, 5, 7, 5, facing);
    }

    private static PieceInfo createCorridorTurnLeft(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(10, depth, x, y, z, -1, 0, 0, 5, 7, 5, facing);
    }

    private static PieceInfo createCorridorStairs(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(11, depth, x, y, z, -1, -7, 0, 5, 14, 10, facing);
    }

    private static PieceInfo createCorridorTCrossing(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(12, depth, x, y, z, -3, 0, 0, 9, 7, 9, facing);
    }

    private static PieceInfo createCorridorNetherWart(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(13, depth, x, y, z, -5, -3, 0, 13, 14, 13, facing);
    }

    private static PieceInfo createEnd(int x, int y, int z, int depth, int facing) {
        return FortressGenerator.createRotated(14, depth, x, y, z, -1, -3, 0, 5, 10, 8, facing);
    }

    private static PieceInfo createRotated(int type, int depth, int x, int y, int z, int relXMin, int relYMin, int relZMin, int relXMax, int relYMax, int relZMax, int facing) {
        int zMax;
        int zMin;
        int xMax;
        int xMin;
        switch (facing) {
            case 0: 
            case 2: {
                xMin = x + relXMin;
                xMax = x + relXMax - 1 + relXMin;
                break;
            }
            case 3: {
                xMin = x - relZMax + 1 + relZMin;
                xMax = x + relZMin;
                break;
            }
            case 1: {
                xMin = x + relZMin;
                xMax = x + relZMax - 1 + relZMin;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        int yMin = y + relYMin;
        int yMax = y + relYMax - 1 + relYMin;
        switch (facing) {
            case 0: {
                zMin = z - relZMax + 1 + relZMin;
                zMax = z + relZMin;
                break;
            }
            case 2: {
                zMin = z + relZMin;
                zMax = z + relZMax - 1 + relZMin;
                break;
            }
            case 1: 
            case 3: {
                zMin = z + relXMin;
                zMax = z + relXMax - 1 + relXMin;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new PieceInfo(type, depth, xMin, yMin, zMin, xMax, yMax, zMax, facing);
    }

    private static void extendBridgeStraight(PieceInfo pieceInfo) {
        FortressGenerator.extendForwards(pieceInfo, 1, 3, false);
    }

    private static void extendBridgeCrossing(PieceInfo pieceInfo) {
        FortressGenerator.extendForwards(pieceInfo, 8, 3, false);
        FortressGenerator.extendLeft(pieceInfo, 8, 3, false);
        FortressGenerator.extendRight(pieceInfo, 8, 3, false);
    }

    private static void extendBridgeFortifiedCrossing(PieceInfo pieceInfo) {
        FortressGenerator.extendForwards(pieceInfo, 2, 0, false);
        FortressGenerator.extendLeft(pieceInfo, 2, 0, false);
        FortressGenerator.extendRight(pieceInfo, 2, 0, false);
    }

    private static void extendBridgeStairs(PieceInfo pieceInfo) {
        FortressGenerator.extendRight(pieceInfo, 2, 6, false);
    }

    private static void extendBridgeSpawner(PieceInfo pieceInfo) {
    }

    private static void extendEnd(PieceInfo pieceInfo) {
    }

    private static void extendBridgeCorridorEntrance(PieceInfo pieceInfo) {
        FortressGenerator.extendForwards(pieceInfo, 5, 3, true);
    }

    private static void extendCorridorStraight(PieceInfo pieceInfo) {
        FortressGenerator.extendForwards(pieceInfo, 1, 0, true);
    }

    private static void extendCorridorCrossing(PieceInfo pieceInfo) {
        FortressGenerator.extendForwards(pieceInfo, 1, 0, true);
        FortressGenerator.extendLeft(pieceInfo, 1, 0, true);
        FortressGenerator.extendRight(pieceInfo, 1, 0, true);
    }

    private static void extendCorridorTurnRight(PieceInfo pieceInfo) {
        FortressGenerator.extendRight(pieceInfo, 1, 0, true);
    }

    private static void extendCorridorTurnLeft(PieceInfo pieceInfo) {
        FortressGenerator.extendLeft(pieceInfo, 1, 0, true);
    }

    private static void extendCorridorStairs(PieceInfo pieceInfo) {
        FortressGenerator.extendForwards(pieceInfo, 1, 0, true);
    }

    private static void extendCorridorTCrossing(PieceInfo pieceInfo) {
        int horOffset = pieceInfo.facing == 3 || pieceInfo.facing == 0 ? 5 : 1;
        FortressGenerator.extendLeft(pieceInfo, horOffset, 0, rand.nextInt(8) > 0);
        FortressGenerator.extendRight(pieceInfo, horOffset, 0, rand.nextInt(8) > 0);
    }

    private static void extendCorridorNetherWart(PieceInfo pieceInfo) {
        FortressGenerator.extendForwards(pieceInfo, 5, 3, true);
        FortressGenerator.extendForwards(pieceInfo, 5, 11, true);
    }

    private static void extendForwards(PieceInfo pieceInfo, int horOffset, int vertOffset, boolean inCorridor) {
        switch (pieceInfo.facing) {
            case 0: {
                FortressGenerator.extend(pieceInfo.xMin + horOffset, pieceInfo.yMin + vertOffset, pieceInfo.zMin - 1, pieceInfo.facing, pieceInfo.depth + 1, inCorridor);
                break;
            }
            case 2: {
                FortressGenerator.extend(pieceInfo.xMin + horOffset, pieceInfo.yMin + vertOffset, pieceInfo.zMax + 1, pieceInfo.facing, pieceInfo.depth + 1, inCorridor);
                break;
            }
            case 3: {
                FortressGenerator.extend(pieceInfo.xMin - 1, pieceInfo.yMin + vertOffset, pieceInfo.zMin + horOffset, pieceInfo.facing, pieceInfo.depth + 1, inCorridor);
                break;
            }
            case 1: {
                FortressGenerator.extend(pieceInfo.xMax + 1, pieceInfo.yMin + vertOffset, pieceInfo.zMin + horOffset, pieceInfo.facing, pieceInfo.depth + 1, inCorridor);
            }
        }
    }

    private static void extendLeft(PieceInfo pieceInfo, int horOffset, int vertOffset, boolean inCorridor) {
        switch (pieceInfo.facing) {
            case 0: 
            case 2: {
                FortressGenerator.extend(pieceInfo.xMin - 1, pieceInfo.yMin + vertOffset, pieceInfo.zMin + horOffset, 3, pieceInfo.depth + 1, inCorridor);
                break;
            }
            case 1: 
            case 3: {
                FortressGenerator.extend(pieceInfo.xMin + horOffset, pieceInfo.yMin + vertOffset, pieceInfo.zMin - 1, 0, pieceInfo.depth + 1, inCorridor);
            }
        }
    }

    private static void extendRight(PieceInfo pieceInfo, int horOffset, int vertOffset, boolean inCorridor) {
        switch (pieceInfo.facing) {
            case 0: 
            case 2: {
                FortressGenerator.extend(pieceInfo.xMax + 1, pieceInfo.yMin + vertOffset, pieceInfo.zMin + horOffset, 1, pieceInfo.depth + 1, inCorridor);
                break;
            }
            case 1: 
            case 3: {
                FortressGenerator.extend(pieceInfo.xMin + horOffset, pieceInfo.yMin + vertOffset, pieceInfo.zMax + 1, 2, pieceInfo.depth + 1, inCorridor);
            }
        }
    }

    private static void extend(int x, int y, int z, int facing, int depth, boolean inCorridor) {
        PieceInfo pieceInfo;
        if (Math.abs(x - start.xMin) <= 112 && Math.abs(z - start.zMin) <= 112) {
            boolean[] allowConsecutives;
            int[] maxs;
            int[] weights;
            int pieceCount;
            int first;
            if (inCorridor) {
                first = 7;
                pieceCount = 7;
                weights = CORRIDOR_WEIGHTS;
                maxs = CORRIDOR_MAXS;
                allowConsecutives = CORRIDOR_ALLOW_CONSECUTIVE;
            } else {
                first = 1;
                pieceCount = 6;
                weights = BRIDGE_WEIGHTS;
                maxs = BRIDGE_MAXS;
                allowConsecutives = BRIDGE_ALLOW_CONSECUTIVE;
            }
            boolean anyValid = false;
            int totalWeight = 0;
            for (int i = 0; i < pieceCount; ++i) {
                if (maxs[i] > 0 && placements[first + i].size() >= maxs[i]) continue;
                if (maxs[i] > 0) {
                    anyValid = true;
                }
                totalWeight += weights[i];
            }
            if (anyValid && totalWeight > 0 && depth <= 30) {
                int tries = 0;
                block1: while (tries < 5) {
                    ++tries;
                    int n = rand.nextInt(totalWeight);
                    for (int i = 0; i < pieceCount; ++i) {
                        if (maxs[i] > 0 && placements[first + i].size() >= maxs[i] || (n -= weights[i]) >= 0) continue;
                        if (lastPlaced == first + i && !allowConsecutives[i]) continue block1;
                        Creator creator = CREATORS[first + i];
                        System.out.println("Creating fortress piece " + (first + i) + " at (" + x + ", " + y + ", " + z + ") facing " + facing + " with depth " + depth + " queue size: " + pieceQueue.size() + " last placed: " + lastPlaced);
                        PieceInfo pieceInfo2 = creator.create(x, y, z, depth, facing);
                        if (FortressGenerator.intersectsAny(pieceInfo2.xMin, pieceInfo2.yMin, pieceInfo2.zMin, pieceInfo2.xMax, pieceInfo2.yMax, pieceInfo2.zMax)) continue;
                        POST_CREATORS[first + i].run();
                        lastPlaced = first + i;
                        placements[first + i].add(pieceInfo2);
                        pieceQueue.add(pieceInfo2);
                        return;
                    }
                }
            }
        }
        if (!FortressGenerator.intersectsAny((pieceInfo = FortressGenerator.createEnd(x, y, z, depth, facing)).xMin, pieceInfo.yMin, pieceInfo.zMin, pieceInfo.xMax, pieceInfo.yMax, pieceInfo.zMax)) {
            rand.nextInt();
            placements[14].add(pieceInfo);
            pieceQueue.add(pieceInfo);
        }
    }

    private static boolean intersectsAny(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        for (List<PieceInfo> pieceInfoList : placements) {
            for (PieceInfo pieceInfo : pieceInfoList) {
                if (pieceInfo.xMin > xMax || pieceInfo.xMax < xMin || pieceInfo.zMin > zMax || pieceInfo.zMax < zMin || pieceInfo.yMin > yMax || pieceInfo.yMax < yMin) continue;
                return true;
            }
        }
        return false;
    }

    private static void setSeed(long worldSeed, int chunkX, int chunkZ) {
        rand.setSeed((long)(chunkX >> 4 ^ chunkZ >> 4 << 4) ^ worldSeed);
        rand.nextInt();
        rand.nextInt(3);
        rand.nextInt(8);
        rand.nextInt(8);
    }

    public static void main(String[] args) {
        FortressGenerator.setSeed(5896870166552931055L, -21, -5);
        FortressGenerator.genFortress(-21, -5, MCVersion.v1_12);
    }

    @Override
    public boolean generate(TerrainGenerator generator, int chunkX, int chunkZ, ChunkRand rand) {
        return true;
    }

    @Override
    public List<Pair<Generator.ILootType, BPos>> getChestsPos() {
        return null;
    }

    @Override
    public List<Pair<Generator.ILootType, BPos>> getLootPos() {
        return this.getChestsPos();
    }

    @Override
    public Generator.ILootType[] getLootTypes() {
        return new Generator.ILootType[0];
    }

    static {
        EXTENDERS = new Extender[]{null, FortressGenerator::extendBridgeStraight, FortressGenerator::extendBridgeCrossing, FortressGenerator::extendBridgeFortifiedCrossing, FortressGenerator::extendBridgeStairs, FortressGenerator::extendBridgeSpawner, FortressGenerator::extendBridgeCorridorEntrance, FortressGenerator::extendCorridorStraight, FortressGenerator::extendCorridorCrossing, FortressGenerator::extendCorridorTurnRight, FortressGenerator::extendCorridorTurnLeft, FortressGenerator::extendCorridorStairs, FortressGenerator::extendCorridorTCrossing, FortressGenerator::extendCorridorNetherWart, FortressGenerator::extendEnd};
        Arrays.setAll(placements, i -> new ArrayList());
    }

    private static class PieceInfo {
        private final int type;
        private final int depth;
        private final int xMin;
        private final int yMin;
        private final int zMin;
        private final int xMax;
        private final int yMax;
        private final int zMax;
        private final int facing;

        public PieceInfo(int type, int depth, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, int facing) {
            this.type = type;
            this.depth = depth;
            this.xMin = xMin;
            this.yMin = yMin;
            this.zMin = zMin;
            this.xMax = xMax;
            this.yMax = yMax;
            this.zMax = zMax;
            this.facing = facing;
        }
    }

    @FunctionalInterface
    private static interface Extender {
        public void extend(PieceInfo var1);
    }

    @FunctionalInterface
    private static interface Creator {
        public PieceInfo create(int var1, int var2, int var3, int var4, int var5);
    }
}

