/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.mcfeature.loot.effect;

import com.seedfinding.mccore.util.data.Pair;
import com.seedfinding.mcfeature.loot.effect.Effects;
import com.seedfinding.mcfeature.loot.effect.attribute.Attribute;
import com.seedfinding.mcfeature.loot.effect.attribute.AttributeModifier;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Effect {
    private final Map<Attribute, AttributeModifier> attributeModifiers = new HashMap<Attribute, AttributeModifier>();
    private final EffectType category;
    private final int color;
    private String description;

    protected Effect(EffectType effectType, int color) {
        this.category = effectType;
        this.color = color;
    }

    public EffectType getCategory() {
        return this.category;
    }

    public int getColor() {
        return this.color;
    }

    public Map<Attribute, AttributeModifier> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = Effects.getEffects().entrySet().stream().filter(e -> ((Effect)e.getValue()).equals(this)).map(Map.Entry::getKey).map(Pair::getSecond).findFirst().orElse(null);
        }
        return this.description;
    }

    public boolean isInstantenous() {
        return false;
    }

    public Effect addAttributeModifier(Attribute attribute, String name, double amount, AttributeModifier.Operation operation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(name), this::getDescription, amount, operation);
        this.attributeModifiers.put(attribute, attributemodifier);
        return this;
    }

    public String toString() {
        return "Effect{category=" + (Object)((Object)this.category) + ", description='" + this.getDescription() + '\'' + '}';
    }

    public static class AttackDamageEffect
    extends Effect {
        protected final double multiplier;

        protected AttackDamageEffect(EffectType effectType, int color, double multiplier) {
            super(effectType, color);
            this.multiplier = multiplier;
        }
    }

    public static class AbsorptionEffect
    extends Effect {
        protected AbsorptionEffect(EffectType effectType, int color) {
            super(effectType, color);
        }
    }

    public static class HealthBoostEffect
    extends Effect {
        public HealthBoostEffect(EffectType effectType, int color) {
            super(effectType, color);
        }
    }

    public static class InstantEffect
    extends Effect {
        public InstantEffect(EffectType effectType, int color) {
            super(effectType, color);
        }

        @Override
        public boolean isInstantenous() {
            return true;
        }
    }

    public static enum EffectType {
        BENEFICIAL,
        HARMFUL,
        NEUTRAL;

    }
}

