/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.mcbiome.device;

import com.seedfinding.mcbiome.device.Restriction;
import com.seedfinding.mcbiome.layer.IntBiomeLayer;
import com.seedfinding.mcmath.util.Mth;
import java.util.Arrays;
import java.util.List;

public abstract class BoundRestriction
extends Restriction {
    private final long salt;
    private final long bound;
    private final long min;
    private final long max;
    private final int shortBound;
    private final long shortMin;
    private final long shortMax;

    public BoundRestriction(String name, int x, int z, long salt, long bound, long value) {
        this(name, x, z, salt, bound, value, value);
    }

    public BoundRestriction(String name, int x, int z, long salt, long bound, long min, long max) {
        super(name, x, z);
        if (max >= bound) {
            System.err.println("Using " + max + " as maximum for bound " + bound + "? Go Fix.");
            max = bound - 1L;
        }
        if (min < 0L) {
            System.err.println("Using " + min + " as minimum for bound " + bound + "? Go Fix.");
            min = 0L;
        }
        this.salt = salt;
        this.bound = bound;
        this.min = min;
        this.max = max;
        this.shortBound = Long.numberOfTrailingZeros(this.bound);
        long a = Mth.mask(this.min, this.shortBound);
        long b = Mth.mask(this.max, this.shortBound);
        this.shortMin = Math.min(a, b);
        this.shortMax = Math.max(a, b);
    }

    @Override
    public List<Integer> getBitPoints() {
        if (this.shortBound == 0) {
            return super.getBitPoints();
        }
        return Arrays.asList(24 + this.shortBound, 64);
    }

    @Override
    public boolean testSeed(long seed, long bits) {
        long localSeed = IntBiomeLayer.getLocalSeed(seed, this.salt, this.getX(), this.getZ());
        if (bits == 64L) {
            int val = (int)Math.floorMod(localSeed >> 24, this.bound);
            return (long)val >= this.min && (long)val <= this.max;
        }
        if (bits >= (long)(24 + this.shortBound)) {
            int val = (int)Mth.mask(localSeed >> 24, this.shortBound);
            return (long)val >= this.shortMin && (long)val <= this.shortMax;
        }
        return false;
    }
}

