/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.network;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import com.noxcrew.noxesium.network.NoxesiumPacketHandler;
import com.noxcrew.noxesium.network.clientbound.ClientboundChangeServerRulesPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundCustomSoundModifyPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundCustomSoundStartPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundCustomSoundStopPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundMccGameStatePacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundMccServerPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundNoxesiumPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundResetPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundResetServerRulesPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundServerInformationPacket;
import com.noxcrew.noxesium.network.serverbound.ServerboundClientInformationPacket;
import com.noxcrew.noxesium.network.serverbound.ServerboundClientSettingsPacket;
import com.noxcrew.noxesium.network.serverbound.ServerboundNoxesiumPacket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class NoxesiumPackets {
    private static final Map<String, Pair<String, PacketType<?>>> clientboundPackets = new HashMap();
    private static final Map<String, String> serverboundPackets = new HashMap<String, String>();
    private static final Set<String> registeredGroups = new HashSet<String>();
    public static final String PACKET_NAMESPACE = "noxesium-v1";
    public static final PacketType<ClientboundChangeServerRulesPacket> CLIENT_CHANGE_SERVER_RULES = NoxesiumPackets.client("change_server_rules", ClientboundChangeServerRulesPacket::new);
    public static final PacketType<ClientboundResetServerRulesPacket> CLIENT_RESET_SERVER_RULES = NoxesiumPackets.client("reset_server_rules", ClientboundResetServerRulesPacket::new);
    public static final PacketType<ClientboundResetPacket> CLIENT_RESET = NoxesiumPackets.client("reset", ClientboundResetPacket::new);
    public static final PacketType<ClientboundServerInformationPacket> CLIENT_SERVER_INFO = NoxesiumPackets.client("server_info", ClientboundServerInformationPacket::new);
    public static final PacketType<ClientboundMccServerPacket> CLIENT_MCC_SERVER = NoxesiumPackets.client("mcc_server", ClientboundMccServerPacket::new);
    public static final PacketType<ClientboundMccGameStatePacket> CLIENT_MCC_GAME_STATE = NoxesiumPackets.client("mcc_game_state", ClientboundMccGameStatePacket::new);
    public static final PacketType<ClientboundCustomSoundStartPacket> CLIENT_START_SOUND = NoxesiumPackets.client("start_sound", ClientboundCustomSoundStartPacket::new);
    public static final PacketType<ClientboundCustomSoundModifyPacket> CLIENT_MODIFY_SOUND = NoxesiumPackets.client("modify_sound", ClientboundCustomSoundModifyPacket::new);
    public static final PacketType<ClientboundCustomSoundStopPacket> CLIENT_STOP_SOUND = NoxesiumPackets.client("stop_sound", ClientboundCustomSoundStopPacket::new);
    public static final PacketType<ServerboundClientInformationPacket> SERVER_CLIENT_INFO = NoxesiumPackets.server("client_info");
    public static final PacketType<ServerboundClientSettingsPacket> SERVER_CLIENT_SETTINGS = NoxesiumPackets.server("client_settings");

    public static <T extends ClientboundNoxesiumPacket> PacketType<T> client(String id, Function<class_2540, T> constructor) {
        return NoxesiumPackets.client(id, "universal", constructor);
    }

    public static <T extends ClientboundNoxesiumPacket> PacketType<T> client(String id, BiFunction<class_2540, Integer, T> constructor) {
        return NoxesiumPackets.client(id, "universal", buffer -> {
            int version = buffer.method_10816();
            return (ClientboundNoxesiumPacket)constructor.apply((class_2540)buffer, version);
        });
    }

    public static <T extends ClientboundNoxesiumPacket> PacketType<T> client(String id, String group, Function<class_2540, T> constructor) {
        Preconditions.checkArgument((!clientboundPackets.containsKey(id) ? 1 : 0) != 0);
        Preconditions.checkArgument((!serverboundPackets.containsKey(id) ? 1 : 0) != 0);
        PacketType type = PacketType.create((class_2960)new class_2960(PACKET_NAMESPACE, id), buffer -> {
            ClientboundNoxesiumPacket result = (ClientboundNoxesiumPacket)constructor.apply((class_2540)buffer);
            int dangling = buffer.readableBytes();
            if (dangling > 0) {
                buffer.readBytes(dangling);
            }
            return result;
        });
        clientboundPackets.put(id, Pair.of((Object)group, (Object)type));
        return type;
    }

    public static <T extends ServerboundNoxesiumPacket> PacketType<T> server(String id) {
        return NoxesiumPackets.server(id, "universal");
    }

    public static <T extends ServerboundNoxesiumPacket> PacketType<T> server(String id, String group) {
        Preconditions.checkArgument((!clientboundPackets.containsKey(id) ? 1 : 0) != 0);
        Preconditions.checkArgument((!serverboundPackets.containsKey(id) ? 1 : 0) != 0);
        PacketType type = PacketType.create((class_2960)new class_2960(PACKET_NAMESPACE, id), buffer -> {
            throw new UnsupportedOperationException("Serverbound Noxesium packets cannot be de-serialized!");
        });
        serverboundPackets.put(type.getId().toString(), group);
        return type;
    }

    public static void registerPackets(String group) {
        Preconditions.checkArgument((!registeredGroups.contains(group) ? 1 : 0) != 0, (Object)("Cannot double register packets for group " + group));
        boolean universal = Objects.equals(group, "universal");
        for (Pair<String, PacketType<?>> packet : clientboundPackets.values()) {
            if (!Objects.equals(group, packet.getFirst())) continue;
            PacketType type = (PacketType)packet.getSecond();
            NoxesiumPacketHandler handler = new NoxesiumPacketHandler();
            if (universal) {
                ClientPlayNetworking.registerGlobalReceiver((PacketType)type, (ClientPlayNetworking.PlayPacketHandler)handler);
                continue;
            }
            ClientPlayNetworking.registerReceiver((PacketType)type, (ClientPlayNetworking.PlayPacketHandler)handler);
        }
        registeredGroups.add(group);
    }

    public static boolean canSend(PacketType<?> type) {
        String group = serverboundPackets.get(type.getId().toString());
        Preconditions.checkNotNull((Object)group, (Object)("Could not find the packet type " + type.getId().toString()));
        return registeredGroups.contains(group);
    }
}

