/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.skull;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.noxcrew.noxesium.NoxesiumMod;
import com.noxcrew.noxesium.feature.skull.GameProfileFetcher;
import com.noxcrew.noxesium.feature.skull.SkullConfig;
import com.noxcrew.noxesium.feature.skull.SkullFontModule;
import com.noxcrew.noxesium.feature.skull.SkullProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;

public class SkullContents
extends class_2588 {
    public static final MapCodec<SkullContents> INNER_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_4844.field_41525.optionalFieldOf("uuid").forGetter(skull -> Optional.ofNullable(skull.getUuid())), (App)Codec.STRING.optionalFieldOf("texture").forGetter(skull -> Optional.ofNullable(skull.getTexture())), (App)Codec.BOOL.optionalFieldOf("grayscale", (Object)false).forGetter(SkullContents::isGrayscale), (App)Codec.INT.optionalFieldOf("advance", (Object)0).forGetter(SkullContents::getAdvance), (App)Codec.INT.optionalFieldOf("ascent", (Object)0).forGetter(SkullContents::getAscent), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(SkullContents::getScale)).apply((Applicative)instance, SkullContents::new));
    public static final MapCodec<SkullContents> CODEC = INNER_CODEC.fieldOf("skull");
    public static final class_7417.class_8823<SkullContents> TYPE = new class_7417.class_8823(CODEC, "skull");
    @Nullable
    private final UUID uuid;
    private final CompletableFuture<String> texture;
    private final boolean grayscale;
    private final int advance;
    private final int ascent;
    private final float scale;
    private final SkullConfig config;

    public SkullContents(@Nullable UUID uuid, CompletableFuture<String> texture, boolean grayscale, int advance, int ascent, float scale) {
        super("", null, new Object[0]);
        this.uuid = uuid;
        this.texture = texture;
        this.grayscale = grayscale;
        this.advance = advance;
        this.ascent = ascent;
        this.scale = scale;
        this.config = new SkullConfig(texture, new SkullProperties(this));
    }

    public SkullContents(Optional<UUID> uuid, Optional<String> textureIn, boolean grayscale, int advance, int ascent, float scale) {
        super("", null, new Object[0]);
        CompletableFuture<String> texture = new CompletableFuture<String>();
        if (textureIn.isPresent()) {
            texture.complete(textureIn.get());
        } else if (uuid.isPresent()) {
            try {
                GameProfile gameprofile = new GameProfile(uuid.get(), "dummy_mcdummyface");
                GameProfileFetcher.updateGameProfile(gameprofile, profile -> {
                    Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
                    if (property != null) {
                        texture.complete(property.value());
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.uuid = uuid.orElse(null);
        this.texture = texture;
        this.grayscale = grayscale;
        this.advance = advance;
        this.ascent = ascent;
        this.scale = scale;
        this.config = new SkullConfig(texture, new SkullProperties(this));
    }

    public class_7417.class_8823<?> method_54163() {
        return TYPE;
    }

    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public String getTexture() {
        return this.texture.getNow(null);
    }

    public boolean isGrayscale() {
        return this.grayscale;
    }

    public int getAdvance() {
        return this.advance;
    }

    public int getAscent() {
        return this.ascent;
    }

    public float getScale() {
        return this.scale;
    }

    public String getText() {
        return Character.toString(NoxesiumMod.getInstance().getModule(SkullFontModule.class).claim(this.config));
    }

    public SkullConfig getConfig() {
        return this.config;
    }

    public SkullProperties getProperties() {
        return this.config.properties();
    }

    public <T> Optional<T> method_27659(class_5348.class_5245<T> contentConsumer) {
        return contentConsumer.accept(this.getText());
    }

    public <T> Optional<T> method_27660(class_5348.class_5246<T> styledContentConsumer, class_2583 style) {
        return styledContentConsumer.accept(style.method_27704(SkullFontModule.RESOURCE_LOCATION), this.getText());
    }

    public class_5250 method_10890(@Nullable class_2168 commandSourceStack, @Nullable class_1297 entity, int i) {
        return class_2561.method_43470((String)this.getText()).method_10862(class_2583.field_24360.method_27704(SkullFontModule.RESOURCE_LOCATION));
    }

    public String toString() {
        return "skull{texture='" + this.texture + "', grayscale='" + this.grayscale + "', advance='" + this.advance + "', ascent='" + this.ascent + "', scale='" + this.scale + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkullContents)) {
            return false;
        }
        SkullContents that = (SkullContents)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return this.grayscale == that.grayscale && this.advance == that.advance && this.ascent == that.ascent && Float.compare(that.scale, this.scale) == 0 && Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uuid, this.grayscale, this.advance, this.ascent, Float.valueOf(this.scale));
    }
}

