/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.render.font;

import com.noxcrew.noxesium.feature.render.cache.ElementCache;
import com.noxcrew.noxesium.mixin.component.ext.FontSetExt;
import com.noxcrew.noxesium.mixin.performance.render.ext.BakedGlyphExt;
import com.noxcrew.noxesium.mixin.performance.render.ext.FontExt;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_377;
import net.minecraft.class_379;
import net.minecraft.class_382;
import net.minecraft.class_384;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5224;
import net.minecraft.class_5251;
import net.minecraft.class_5481;
import net.minecraft.class_5819;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BakedComponent {
    private static final Vector3f SHADOW_OFFSET = new Vector3f(0.0f, 0.0f, 0.03f);
    public static final BakedComponent EMPTY = new BakedComponent((class_2561)class_2561.method_43473());
    private final StringRenderOutput renderOutput;
    public final int width;
    public final boolean needsCustomReRendering;
    private final boolean shadow;

    public BakedComponent(class_2561 component) {
        this(component, class_310.method_1551().field_1772);
    }

    public BakedComponent(class_2561 component, class_327 font) {
        this(component.method_30937(), font);
    }

    public BakedComponent(class_5481 component, class_327 font) {
        this(component, font, false, true);
    }

    public BakedComponent(class_5481 component, class_327 font, boolean forceRenderCharactersSeparate, boolean shadow) {
        this.renderOutput = new StringRenderOutput(font, forceRenderCharactersSeparate);
        component.accept((class_5224)this.renderOutput);
        this.width = font.method_30880(component);
        this.needsCustomReRendering = this.renderOutput.doesContainObfuscation();
        this.shadow = shadow;
    }

    public boolean shouldDraw(boolean dynamic) {
        if (this.needsCustomReRendering) {
            return dynamic;
        }
        return !dynamic;
    }

    public int draw(class_332 graphics, class_327 font, int x, int y, int color) {
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        class_4597.class_4598 bufferSource = graphics.method_51450();
        int newColor = BakedComponent.adjustColor(color);
        Matrix4f matrixCopy = matrix;
        if (this.shadow) {
            matrixCopy = new Matrix4f((Matrix4fc)matrix);
            this.renderOutput.finish(font, x, y, newColor, true, matrix, (class_4597)bufferSource);
            matrixCopy.translate((Vector3fc)SHADOW_OFFSET);
        }
        if (!ElementCache.hasDrawnSomething) {
            ElementCache.hasDrawnSomething = true;
        }
        float fx = this.renderOutput.finish(font, x, y, newColor, false, matrixCopy, (class_4597)bufferSource);
        return (int)fx + (this.shadow ? 1 : 0);
    }

    private static int adjustColor(int i) {
        return (i & 0xFC000000) == 0 ? i | 0xFF000000 : i;
    }

    private static class StringRenderOutput
    implements class_5224 {
        private static final class_327.class_6415 DISPLAY_MODE = class_327.class_6415.field_33993;
        private static final int PACKED_LIGHT_COORDS = 0xF000F0;
        private static final class_5819 RANDOM = class_5819.method_43047();
        private final List<FontCharacter> characters = new ArrayList<FontCharacter>();
        private final FontExt font;
        private final class_382 baseBakedGlyph;
        private final BakedGlyphExt baseBakedGlyphExt;
        private final boolean forceFlush;
        private float x;
        private boolean containsObfuscation = false;

        public StringRenderOutput(class_327 font, boolean forceFlush) {
            this.font = (FontExt)font;
            this.baseBakedGlyph = this.font.invokeGetFontSet(class_2583.field_24359).method_22943();
            this.baseBakedGlyphExt = (BakedGlyphExt)this.baseBakedGlyph;
            this.forceFlush = forceFlush;
        }

        public boolean doesContainObfuscation() {
            return this.containsObfuscation;
        }

        public boolean accept(int position, class_2583 style, int codePoint) {
            boolean obfuscated;
            class_377 fontset = this.font.invokeGetFontSet(style.method_27708());
            class_379 glyphinfo = fontset.method_2011(codePoint, this.font.getFilterFishyGlyphs());
            boolean bold = style.method_10984();
            class_5251 textcolor = style.method_10973();
            Float r = null;
            Float g = null;
            Float b = null;
            if (textcolor != null) {
                int color = textcolor.method_27716();
                r = Float.valueOf((float)(color >> 16 & 0xFF) / 255.0f);
                g = Float.valueOf((float)(color >> 8 & 0xFF) / 255.0f);
                b = Float.valueOf((float)(color & 0xFF) / 255.0f);
            }
            float advance = glyphinfo.method_16798(bold);
            class_382 bakedGlyph = fontset.method_2014(codePoint);
            boolean bl = obfuscated = style.method_10987() && codePoint != 32;
            if (obfuscated) {
                this.containsObfuscation = true;
            }
            this.characters.add(new FontCharacter(this.getTexture(bakedGlyph.method_24045(DISPLAY_MODE)), fontset, glyphinfo, bakedGlyph, r, g, b, obfuscated, bold, style.method_10966(), style.method_10986(), style.method_10965(), this.x, this.x + advance, class_3532.method_15386((float)(bold ? glyphinfo.method_16798(false) : advance))));
            this.x += advance;
            return true;
        }

        public float finish(class_327 font, float x, float y, int color, boolean shadow, Matrix4f matrix, class_4597 bufferSource) {
            FontExt ext = (FontExt)font;
            float right = x;
            float dimFactor = shadow ? 0.25f : 1.0f;
            float decorationOffset = shadow ? 1.0f : 0.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f * dimFactor;
            float g = (float)(color >> 8 & 0xFF) / 255.0f * dimFactor;
            float b = (float)(color & 0xFF) / 255.0f * dimFactor;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            class_4588 baseVertexconsumer = bufferSource.getBuffer(this.baseBakedGlyph.method_24045(DISPLAY_MODE));
            for (FontCharacter character : this.characters) {
                class_382 bakedglyph;
                class_382 class_3822 = bakedglyph = character.obfuscated ? this.getRandomGlyph(character.fontSet, character.nonBoldAdvance) : character.bakedGlyph;
                if (!(bakedglyph instanceof class_384)) {
                    float boldOffset = character.bold ? character.glyphInfo.method_16799() : 0.0f;
                    float shadowOffset = shadow ? character.glyphInfo.method_16800() : 0.0f;
                    class_1921 renderType = bakedglyph.method_24045(DISPLAY_MODE);
                    if (this.forceFlush && bufferSource instanceof class_4597.class_4598) {
                        class_4597.class_4598 source = (class_4597.class_4598)bufferSource;
                        source.method_22994(renderType);
                    }
                    class_4588 vertexconsumer = bufferSource.getBuffer(renderType);
                    ext.invokeRenderChar(bakedglyph, character.bold, character.italic, boldOffset, x + character.left + shadowOffset, y + shadowOffset, matrix, vertexconsumer, character.r == null ? r : character.r.floatValue() * dimFactor, character.g == null ? g : character.g.floatValue() * dimFactor, character.b == null ? b : character.b.floatValue() * dimFactor, a, 0xF000F0);
                    if (this.forceFlush && bufferSource instanceof class_4597.class_4598) {
                        class_4597.class_4598 source = (class_4597.class_4598)bufferSource;
                        source.method_22994(renderType);
                        baseVertexconsumer = bufferSource.getBuffer(this.baseBakedGlyph.method_24045(DISPLAY_MODE));
                    }
                }
                if (character.strikethrough) {
                    this.render(x + character.left + decorationOffset - 1.0f, y + decorationOffset + 4.5f, x + character.right + decorationOffset, y + decorationOffset + 4.5f - 1.0f, 0.01f, Float.valueOf(character.r == null ? r : character.r.floatValue() * dimFactor), Float.valueOf(character.g == null ? g : character.g.floatValue() * dimFactor), Float.valueOf(character.b == null ? b : character.b.floatValue() * dimFactor), a, matrix, baseVertexconsumer, 0xF000F0);
                }
                if (character.underline) {
                    this.render(x + character.left + decorationOffset - 1.0f, y + decorationOffset + 9.0f, x + character.right + decorationOffset, y + decorationOffset + 9.0f - 1.0f, 0.01f, Float.valueOf(character.r == null ? r : character.r.floatValue() * dimFactor), Float.valueOf(character.g == null ? g : character.g.floatValue() * dimFactor), Float.valueOf(character.b == null ? b : character.b.floatValue() * dimFactor), a, matrix, baseVertexconsumer, 0xF000F0);
                }
                right = Math.max(right, character.right + x);
            }
            return right;
        }

        private class_2960 getTexture(class_1921 type) {
            if (type instanceof class_1921.class_4687) {
                class_1921.class_4687 composite = (class_1921.class_4687)type;
                class_4668.class_5939 class_59392 = composite.method_35784().field_21406;
                if (class_59392 instanceof class_4668.class_4683) {
                    class_4668.class_4683 textureShard = (class_4668.class_4683)class_59392;
                    return textureShard.method_23564().orElse(new class_2960("")).method_48331("/" + type.field_21363);
                }
            }
            return new class_2960("/" + type.field_21363);
        }

        private class_382 getRandomGlyph(class_377 fontSet, int advance) {
            FontSetExt ext = (FontSetExt)fontSet;
            IntList intList = (IntList)ext.getGlyphsByWidth().get(advance);
            return intList != null && !intList.isEmpty() ? fontSet.method_2014(intList.getInt(RANDOM.method_43048(intList.size()))) : ext.getMissingGlyph();
        }

        private void render(float x, float y, float x2, float y2, float depth, Float r, Float g, Float b, float a, Matrix4f matrix, class_4588 vertexConsumer, int i) {
            vertexConsumer.method_22918(matrix, x, y, depth).method_22915(r.floatValue(), g.floatValue(), b.floatValue(), a).method_22913(this.baseBakedGlyphExt.getU0(), this.baseBakedGlyphExt.getV0()).method_22916(i).method_1344();
            vertexConsumer.method_22918(matrix, x2, y, depth).method_22915(r.floatValue(), g.floatValue(), b.floatValue(), a).method_22913(this.baseBakedGlyphExt.getU0(), this.baseBakedGlyphExt.getV1()).method_22916(i).method_1344();
            vertexConsumer.method_22918(matrix, x2, y2, depth).method_22915(r.floatValue(), g.floatValue(), b.floatValue(), a).method_22913(this.baseBakedGlyphExt.getU1(), this.baseBakedGlyphExt.getV1()).method_22916(i).method_1344();
            vertexConsumer.method_22918(matrix, x, y2, depth).method_22915(r.floatValue(), g.floatValue(), b.floatValue(), a).method_22913(this.baseBakedGlyphExt.getU1(), this.baseBakedGlyphExt.getV0()).method_22916(i).method_1344();
        }

        public record FontCharacter(class_2960 texture, class_377 fontSet, class_379 glyphInfo, class_382 bakedGlyph, Float r, Float g, Float b, boolean obfuscated, boolean bold, boolean italic, boolean strikethrough, boolean underline, float left, float right, int nonBoldAdvance) {
        }
    }
}

