/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.render.cache.title;

import com.noxcrew.noxesium.feature.render.cache.ElementCache;
import com.noxcrew.noxesium.feature.render.cache.title.TitleInformation;
import com.noxcrew.noxesium.feature.render.font.BakedComponent;
import com.noxcrew.noxesium.mixin.performance.render.ext.GuiExt;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5253;

public class TitleCache
extends ElementCache<TitleInformation> {
    private static TitleCache instance;

    public static TitleCache getInstance() {
        if (instance == null) {
            instance = new TitleCache();
        }
        return instance;
    }

    public TitleCache() {
        this.registerVariable("alpha", (minecraft, partialTicks) -> {
            class_329 gui = minecraft.field_1705;
            GuiExt guiExt = (GuiExt)gui;
            int alpha = 255;
            float ticksElapsed = (float)guiExt.getTitleTime() - partialTicks.floatValue();
            if (guiExt.getTitleTime() > guiExt.getTitleFadeOutTime() + guiExt.getTitleStayTime()) {
                float fadeFactor = (float)(guiExt.getTitleFadeInTime() + guiExt.getTitleStayTime() + guiExt.getTitleFadeOutTime()) - ticksElapsed;
                alpha = (int)(fadeFactor * 255.0f / (float)guiExt.getTitleFadeInTime());
            }
            if (guiExt.getTitleTime() <= guiExt.getTitleFadeOutTime()) {
                alpha = (int)(ticksElapsed * 255.0f / (float)guiExt.getTitleFadeOutTime());
            }
            return class_3532.method_15340((int)alpha, (int)0, (int)255);
        });
        this.registerVariable("title_visible", (minecraft, partialTicks) -> ((GuiExt)minecraft.field_1705).getTitleTime() >= 0);
    }

    @Override
    protected TitleInformation createCache(class_310 minecraft, class_327 font) {
        class_329 gui = minecraft.field_1705;
        GuiExt guiExt = (GuiExt)gui;
        if (guiExt.getTitle() == null || guiExt.getTitleTime() <= 0) {
            return TitleInformation.EMPTY;
        }
        return new TitleInformation(new BakedComponent(guiExt.getTitle(), font), guiExt.getSubtitle() == null ? null : new BakedComponent(guiExt.getSubtitle(), font), (Integer)this.getVariable("alpha"));
    }

    @Override
    protected void render(class_332 graphics, TitleInformation cache, class_310 minecraft, int screenWidth, int screenHeight, class_327 font, float partialTicks, boolean dynamic) {
        int alpha = cache.alpha();
        if (alpha > 8) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)(screenWidth / 2), (float)(screenHeight / 2), 0.0f);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(4.0f, 4.0f, 4.0f);
            int trueAlpha = alpha << 24 & 0xFF000000;
            int background = minecraft.field_1690.method_19345(0.0f);
            int backgroundColor = class_5253.class_5254.method_27763((int)background, (int)(0xFFFFFF | trueAlpha));
            int titleWidth = cache.title().width;
            if (!dynamic) {
                int offset = -10;
                if (background != 0) {
                    int left = -titleWidth / 2;
                    graphics.method_25294(left - 2, offset - 2, left + titleWidth + 2, offset + 9 + 2, backgroundColor);
                }
            }
            if (cache.title().shouldDraw(dynamic)) {
                cache.title().draw(graphics, font, -titleWidth / 2, -10, 0xFFFFFF | trueAlpha);
            }
            graphics.method_51448().method_22909();
            if (cache.subtitle() != null) {
                graphics.method_51448().method_22905(2.0f, 2.0f, 2.0f);
                int subtitleWidth = cache.subtitle().width;
                if (!dynamic) {
                    int offset = 5;
                    if (background != 0) {
                        int left = -subtitleWidth / 2;
                        graphics.method_25294(left - 2, offset - 2, left + subtitleWidth + 2, offset + 9 + 2, backgroundColor);
                    }
                }
                if (cache.subtitle().shouldDraw(dynamic)) {
                    cache.subtitle().draw(graphics, font, -subtitleWidth / 2, 5, 0xFFFFFF | trueAlpha);
                }
            }
            graphics.method_51448().method_22909();
        }
    }
}

