/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.render.cache.tablist;

import com.noxcrew.noxesium.feature.render.cache.ElementInformation;
import com.noxcrew.noxesium.feature.render.font.BakedComponent;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_266;
import net.minecraft.class_640;
import org.jetbrains.annotations.Nullable;

public record TabListInformation(@Nullable List<BakedComponent> header, @Nullable List<BakedComponent> footer, List<class_640> players, List<UUID> blinking, Map<UUID, BakedComponent> names, Map<UUID, Integer> scoreValues, Map<UUID, BakedComponent> scores, int columnWidth, int maxNameWidth, int maxScoreWidth, int width, int left, int playersPerColumn, boolean showSkins, @Nullable class_266 objective) implements ElementInformation
{
    public static final TabListInformation EMPTY = new TabListInformation(List.of(), List.of(), List.of(), List.of(), Map.of(), Map.of(), Map.of(), 0, 0, 0, 0, 0, 0, true, null);

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    public static class HealthState {
        private static final long DISPLAY_UPDATE_DELAY = 20L;
        private static final long DECREASE_BLINK_DURATION = 20L;
        private static final long INCREASE_BLINK_DURATION = 10L;
        private int lastValue;
        private int displayedValue;
        private long lastUpdateTick;
        private long blinkUntilTick;

        public HealthState(int display) {
            this.displayedValue = display;
            this.lastValue = display;
        }

        public boolean update(int value, long currentTick) {
            if (value != this.lastValue) {
                long blinkTime = value < this.lastValue ? 20L : 10L;
                this.blinkUntilTick = currentTick + blinkTime;
                this.lastValue = value;
                this.lastUpdateTick = currentTick;
            }
            if (currentTick - this.lastUpdateTick > 20L) {
                this.displayedValue = value;
            }
            return !this.isDoneBlinking(currentTick);
        }

        public int displayedValue() {
            return this.displayedValue;
        }

        public boolean isBlinking(long currentTick) {
            return this.blinkUntilTick > currentTick && (this.blinkUntilTick - currentTick) % 6L >= 3L;
        }

        public boolean isDoneBlinking(long currentTick) {
            return this.blinkUntilTick <= currentTick;
        }
    }
}

