/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.render.cache.tablist;

import com.mojang.authlib.GameProfile;
import com.noxcrew.noxesium.feature.render.cache.ElementCache;
import com.noxcrew.noxesium.feature.render.cache.tablist.TabListInformation;
import com.noxcrew.noxesium.feature.render.font.BakedComponent;
import com.noxcrew.noxesium.mixin.performance.render.ext.PlayerTabOverlayExt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_355;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_640;
import net.minecraft.class_7532;
import net.minecraft.class_8144;
import net.minecraft.class_8646;
import net.minecraft.class_9013;
import net.minecraft.class_9015;
import net.minecraft.class_9022;
import net.minecraft.class_9025;
import net.minecraft.class_922;

public class TabListCache
extends ElementCache<TabListInformation> {
    private static final class_2960 PING_UNKNOWN_SPRITE = new class_2960("icon/ping_unknown");
    private static final class_2960 PING_1_SPRITE = new class_2960("icon/ping_1");
    private static final class_2960 PING_2_SPRITE = new class_2960("icon/ping_2");
    private static final class_2960 PING_3_SPRITE = new class_2960("icon/ping_3");
    private static final class_2960 PING_4_SPRITE = new class_2960("icon/ping_4");
    private static final class_2960 PING_5_SPRITE = new class_2960("icon/ping_5");
    private static final class_2960 HEART_CONTAINER_BLINKING_SPRITE = new class_2960("hud/heart/container_blinking");
    private static final class_2960 HEART_CONTAINER_SPRITE = new class_2960("hud/heart/container");
    private static final class_2960 HEART_FULL_BLINKING_SPRITE = new class_2960("hud/heart/full_blinking");
    private static final class_2960 HEART_HALF_BLINKING_SPRITE = new class_2960("hud/heart/half_blinking");
    private static final class_2960 HEART_ABSORBING_FULL_BLINKING_SPRITE = new class_2960("hud/heart/absorbing_full_blinking");
    private static final class_2960 HEART_FULL_SPRITE = new class_2960("hud/heart/full");
    private static final class_2960 HEART_ABSORBING_HALF_BLINKING_SPRITE = new class_2960("hud/heart/absorbing_half_blinking");
    private static final class_2960 HEART_HALF_SPRITE = new class_2960("hud/heart/half");
    private static final Comparator<class_640> PLAYER_COMPARATOR = Comparator.comparingInt(player -> player.method_2958() == class_1934.field_9219 ? 1 : 0).thenComparing(player -> (String)class_8144.method_49078((Object)player.method_2955(), class_268::method_1197, (Object)"")).thenComparing(player -> player.method_2966().getName(), String::compareToIgnoreCase);
    private static TabListCache instance;
    private final Map<UUID, TabListInformation.HealthState> healthStates = new HashMap<UUID, TabListInformation.HealthState>();
    private static final int BASE_OFFSET = 10;

    public static TabListCache getInstance() {
        if (instance == null) {
            instance = new TabListCache();
        }
        return instance;
    }

    public TabListCache() {
        this.registerVariable("blinking", (minecraft, partialTicks) -> {
            if (!this.healthStates.isEmpty()) {
                ArrayList<UUID> blinking = new ArrayList<UUID>();
                List<class_640> players = minecraft.field_1724 == null ? List.of() : minecraft.field_1724.field_3944.method_45732().stream().sorted(PLAYER_COMPARATOR).limit(80L).toList();
                Set uuids = players.stream().map(playerInfo -> playerInfo.method_2966().getId()).collect(Collectors.toSet());
                this.healthStates.keySet().removeIf(uUID -> !uuids.contains(uUID));
                class_269 scoreboard = minecraft.field_1687.method_8428();
                class_266 objective = scoreboard.method_1189(class_8646.field_45156);
                if (objective != null && objective.method_1118() == class_274.class_275.field_1471) {
                    for (class_640 player : players) {
                        class_9015 scoreHolder = class_9015.method_55420((GameProfile)player.method_2966());
                        int score = objective.method_1117().method_1180(scoreHolder, objective).method_55409();
                        TabListInformation.HealthState state = this.healthStates.computeIfAbsent(player.method_2966().getId(), playerId -> new TabListInformation.HealthState(score));
                        if (!state.update(score, minecraft.field_1705.method_1738())) continue;
                        blinking.add(player.method_2966().getId());
                    }
                }
                return blinking;
            }
            return List.of();
        });
    }

    public boolean isObjectiveRelevant(class_266 objective) {
        if (this.cache == null || ((TabListInformation)this.cache).objective() == null) {
            return false;
        }
        return ((TabListInformation)this.cache).objective() == objective;
    }

    public void resetHearts() {
        this.healthStates.clear();
    }

    public class_2960 getLatencyBucket(int latency) {
        if (latency < 0) {
            return PING_UNKNOWN_SPRITE;
        }
        if (latency < 150) {
            return PING_5_SPRITE;
        }
        if (latency < 300) {
            return PING_4_SPRITE;
        }
        if (latency < 600) {
            return PING_3_SPRITE;
        }
        if (latency < 1000) {
            return PING_2_SPRITE;
        }
        return PING_1_SPRITE;
    }

    @Override
    protected boolean shouldForceBlending() {
        return true;
    }

    @Override
    protected TabListInformation createCache(class_310 minecraft, class_327 font) {
        BakedComponent baked;
        List lines;
        int playerCount;
        class_355 playerTabOverlay = minecraft.field_1705.method_1750();
        PlayerTabOverlayExt ext = (PlayerTabOverlayExt)playerTabOverlay;
        class_269 scoreboard = minecraft.field_1687.method_8428();
        class_266 objective = scoreboard.method_1189(class_8646.field_45156);
        int screenWidth = minecraft.method_22683().method_4486();
        class_2561 header = ext.getHeader();
        class_2561 footer = ext.getFooter();
        List<class_640> players = minecraft.field_1724 == null ? List.of() : minecraft.field_1724.field_3944.method_45732().stream().sorted(PLAYER_COMPARATOR).limit(80L).toList();
        List blinking = (List)this.getVariable("blinking");
        int maxNameWidth = 0;
        int baseScoreWidth = 0;
        HashMap<UUID, BakedComponent> names = new HashMap<UUID, BakedComponent>();
        HashMap<UUID, Integer> scoreValues = new HashMap<UUID, Integer>();
        HashMap<UUID, BakedComponent> scores = new HashMap<UUID, BakedComponent>();
        int extraWidth = font.method_1727(" ");
        for (class_640 playerInfo : players) {
            class_2561 name = playerTabOverlay.method_1918(playerInfo);
            BakedComponent baked2 = new BakedComponent(name);
            names.put(playerInfo.method_2966().getId(), baked2);
            maxNameWidth = Math.max(maxNameWidth, baked2.width);
            if (objective == null) continue;
            class_9022 numberFormat = objective.method_55380((class_9022)class_9025.field_47568);
            class_9015 scoreHolder = class_9015.method_55420((GameProfile)playerInfo.method_2966());
            class_9013 readOnlyScoreInfo = scoreboard.method_55430(scoreHolder, objective);
            if (readOnlyScoreInfo != null) {
                scoreValues.put(playerInfo.method_2966().getId(), readOnlyScoreInfo.method_55397());
            }
            if (objective.method_1118() == class_274.class_275.field_1471) continue;
            class_5250 score = class_9013.method_55398((class_9013)readOnlyScoreInfo, (class_9022)numberFormat);
            BakedComponent bakedScore = new BakedComponent((class_2561)score);
            scores.put(playerInfo.method_2966().getId(), bakedScore);
            int scoreWidth = bakedScore.width;
            baseScoreWidth = Math.max(baseScoreWidth, scoreWidth > 0 ? extraWidth + scoreWidth : 0);
        }
        int playersPerColumn = playerCount = players.size();
        int columns = 1;
        while (playersPerColumn > 20) {
            playersPerColumn = (playerCount + ++columns - 1) / columns;
        }
        int maxScoreWidth = 0;
        if (objective != null) {
            maxScoreWidth = objective.method_1118() == class_274.class_275.field_1471 ? 90 : baseScoreWidth;
        }
        boolean showSkins = minecraft.method_1542() || minecraft.method_1562().method_48296().method_10771();
        int columnWidth = Math.min(columns * ((showSkins ? 9 : 0) + maxNameWidth + maxScoreWidth + 13), screenWidth - 50) / columns;
        int left = screenWidth / 2 - (columnWidth * columns + (columns - 1) * 5) / 2;
        int width = columnWidth * columns + (columns - 1) * 5;
        ArrayList<BakedComponent> headerLines = null;
        ArrayList<BakedComponent> footerLines = null;
        if (header != null) {
            lines = font.method_1728((class_5348)header, screenWidth - 50);
            if (!lines.isEmpty()) {
                headerLines = new ArrayList<BakedComponent>();
            }
            for (class_5481 line : lines) {
                baked = new BakedComponent(line, font);
                width = Math.max(width, baked.width);
                headerLines.add(baked);
            }
        }
        if (footer != null) {
            lines = font.method_1728((class_5348)footer, screenWidth - 50);
            if (!lines.isEmpty()) {
                footerLines = new ArrayList<BakedComponent>();
            }
            for (class_5481 line : lines) {
                baked = new BakedComponent(line, font);
                width = Math.max(width, baked.width);
                footerLines.add(baked);
            }
        }
        return new TabListInformation(headerLines, footerLines, players, blinking, names, scoreValues, scores, columnWidth, maxNameWidth, maxScoreWidth, width, left, playersPerColumn, showSkins, objective);
    }

    @Override
    protected void render(class_332 graphics, TabListInformation cache, class_310 minecraft, int screenWidth, int screenHeight, class_327 font, float partialTicks, boolean dynamic) {
        class_269 scoreboard = minecraft.field_1687.method_8428();
        class_266 objective = scoreboard.method_1189(class_8646.field_45156);
        int width = cache.width();
        int left = cache.left();
        int playersPerColumn = cache.playersPerColumn();
        int columnWidth = cache.columnWidth();
        int height = 10;
        if (cache.header() != null) {
            if (!dynamic) {
                int n = screenWidth / 2 - width / 2 - 1;
                int n2 = screenWidth / 2 + width / 2 + 1;
                int n3 = cache.header().size();
                Objects.requireNonNull(font);
                graphics.method_25294(n, height - 1, n2, height + n3 * 9, Integer.MIN_VALUE);
            }
            for (BakedComponent line : cache.header()) {
                if (line.shouldDraw(dynamic)) {
                    line.draw(graphics, font, screenWidth / 2 - line.width / 2, height, -1);
                }
                Objects.requireNonNull(font);
                if ((height += 9) < screenHeight) continue;
                return;
            }
            ++height;
        }
        if (!dynamic) {
            graphics.method_25294(screenWidth / 2 - width / 2 - 1, height - 1, screenWidth / 2 + width / 2 + 1, height + playersPerColumn * 9, Integer.MIN_VALUE);
        }
        int playerCount = cache.players().size();
        int highlightBackground = minecraft.field_1690.method_19344(0x20FFFFFF);
        for (int index = 0; index < playerCount; ++index) {
            int scoreX;
            int scoreWidth;
            BakedComponent name;
            if (height >= screenHeight) {
                return;
            }
            int column = index / playersPerColumn;
            int row = index % playersPerColumn;
            int x = left + column * columnWidth + column * 5;
            int y = height + row * 9;
            if (!dynamic) {
                graphics.method_25294(x, y, x + columnWidth, y + 8, highlightBackground);
            }
            if (index >= cache.players().size()) continue;
            class_640 playerInfo = cache.players().get(index);
            GameProfile profile = playerInfo.method_2966();
            if (cache.showSkins()) {
                if (!dynamic) {
                    class_1657 player = minecraft.field_1687.method_18470(profile.getId());
                    boolean upsideDown = player != null && class_922.method_38563((class_1309)player);
                    class_7532.method_44445((class_332)graphics, (class_2960)playerInfo.method_52810().comp_1626(), (int)x, (int)y, (int)8, (boolean)true, (boolean)upsideDown);
                }
                x += 9;
            }
            if ((name = cache.names().get(playerInfo.method_2966().getId())).shouldDraw(dynamic)) {
                name.draw(graphics, font, x, y, playerInfo.method_2958() == class_1934.field_9219 ? -1862270977 : -1);
            }
            if (objective != null && playerInfo.method_2958() != class_1934.field_9219 && (scoreWidth = (scoreX = x + cache.maxNameWidth() + 1) + cache.maxScoreWidth()) - scoreX > 5 && cache.blinking().contains(playerInfo.method_2966().getId()) == dynamic) {
                this.renderTablistScore(objective, cache.scores().get(playerInfo.method_2966().getId()), cache.scoreValues().get(playerInfo.method_2966().getId()), y, scoreX, scoreWidth, profile.getId(), graphics, font);
            }
            if (dynamic) continue;
            this.renderPingIcon(graphics, columnWidth, x - (cache.showSkins() ? 9 : 0), y, this.getLatencyBucket(playerInfo.method_2959()));
        }
        if (cache.footer() != null) {
            if ((height += playersPerColumn * 9 + 1) >= screenHeight) {
                return;
            }
            if (!dynamic) {
                int n = screenWidth / 2 - width / 2 - 1;
                int n4 = screenWidth / 2 + width / 2 + 1;
                int n5 = cache.footer().size();
                Objects.requireNonNull(font);
                graphics.method_25294(n, height - 1, n4, height + n5 * 9, Integer.MIN_VALUE);
            }
            for (BakedComponent line : cache.footer()) {
                if (line.shouldDraw(dynamic)) {
                    line.draw(graphics, font, screenWidth / 2 - line.width / 2, height, -1);
                }
                Objects.requireNonNull(font);
                height += 9;
            }
        }
    }

    private void renderPingIcon(class_332 graphics, int x, int offset, int y, class_2960 latency) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        graphics.method_52706(latency, offset + x - 11, y, 10, 8);
        graphics.method_51448().method_22909();
    }

    private void renderTablistScore(class_266 objective, BakedComponent component, Integer score, int y, int x, int width, UUID playerId, class_332 graphics, class_327 font) {
        if (objective.method_1118() == class_274.class_275.field_1471) {
            this.renderTablistHearts(y, x, width, playerId, graphics, score, font);
        } else {
            component.draw(graphics, font, width - component.width, y, 0xFFFFFF);
        }
    }

    private void renderTablistHearts(int y, int x, int width, UUID playerId, class_332 graphics, int health, class_327 font) {
        TabListInformation.HealthState healthState = this.healthStates.computeIfAbsent(playerId, id -> new TabListInformation.HealthState(health));
        int guiTicks = class_310.method_1551().field_1705.method_1738();
        int displayedHearts = class_3532.method_38788((int)Math.max(health, healthState.displayedValue()), (int)2);
        int totalHearts = Math.max(health, Math.max(healthState.displayedValue(), 20)) / 2;
        boolean blinking = healthState.isBlinking(guiTicks);
        if (displayedHearts > 0) {
            int heartOffset = class_3532.method_15375((float)Math.min((float)(width - x - 4) / (float)totalHearts, 9.0f));
            if (heartOffset <= 3) {
                float pctHealth = class_3532.method_15363((float)((float)health / 20.0f), (float)0.0f, (float)1.0f);
                int heart = (int)((1.0f - pctHealth) * 255.0f) << 16 | (int)(pctHealth * 255.0f) << 8;
                float hearts = (float)health / 2.0f;
                class_5250 text = class_2561.method_43469((String)"multiplayer.player.list.hp", (Object[])new Object[]{Float.valueOf(hearts)});
                class_5250 trueText = width - font.method_27525((class_5348)text) >= x ? text : class_2561.method_43470((String)("" + hearts));
                graphics.method_27535(font, (class_2561)trueText, (width + x - font.method_27525((class_5348)trueText)) / 2, y, heart);
            } else {
                int heart;
                class_2960 texture = blinking ? HEART_CONTAINER_BLINKING_SPRITE : HEART_CONTAINER_SPRITE;
                for (heart = displayedHearts; heart < totalHearts; ++heart) {
                    graphics.method_52706(texture, x + heart * heartOffset, y, 9, 9);
                }
                for (heart = 0; heart < displayedHearts; ++heart) {
                    graphics.method_52706(texture, x + heart * heartOffset, y, 9, 9);
                    if (blinking) {
                        if (heart * 2 + 1 < healthState.displayedValue()) {
                            graphics.method_52706(HEART_FULL_BLINKING_SPRITE, x + heart * heartOffset, y, 9, 9);
                        }
                        if (heart * 2 + 1 == healthState.displayedValue()) {
                            graphics.method_52706(HEART_HALF_BLINKING_SPRITE, x + heart * heartOffset, y, 9, 9);
                        }
                    }
                    if (heart * 2 + 1 < health) {
                        graphics.method_52706(heart >= 10 ? HEART_ABSORBING_FULL_BLINKING_SPRITE : HEART_FULL_SPRITE, x + heart * heartOffset, y, 9, 9);
                    }
                    if (heart * 2 + 1 != health) continue;
                    graphics.method_52706(heart >= 10 ? HEART_ABSORBING_HALF_BLINKING_SPRITE : HEART_HALF_SPRITE, x + heart * heartOffset, y, 9, 9);
                }
            }
        }
    }
}

