/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.render.cache.scoreboard;

import com.noxcrew.noxesium.feature.render.cache.ElementCache;
import com.noxcrew.noxesium.feature.render.cache.scoreboard.ScoreboardInformation;
import com.noxcrew.noxesium.feature.render.font.BakedComponent;
import com.noxcrew.noxesium.feature.render.font.BakedComponentBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8646;
import net.minecraft.class_9011;
import net.minecraft.class_9022;
import net.minecraft.class_9025;

public class ScoreboardCache
extends ElementCache<ScoreboardInformation> {
    private static final Comparator<class_9011> SCORE_DISPLAY_ORDER = Comparator.comparing(class_9011::comp_2128).reversed().thenComparing(class_9011::comp_2127, String.CASE_INSENSITIVE_ORDER);
    private static ScoreboardCache instance;
    private static final int RIGHT = 3;

    public static ScoreboardCache getInstance() {
        if (instance == null) {
            instance = new ScoreboardCache();
        }
        return instance;
    }

    public boolean isPlayerRelevant(String player) {
        if (this.cache == null) {
            return false;
        }
        return ((ScoreboardInformation)this.cache).players().contains(player);
    }

    public boolean isTeamRelevant(String team) {
        if (this.cache == null) {
            return false;
        }
        return ((ScoreboardInformation)this.cache).teams().contains(team);
    }

    public boolean isObjectiveRelevant(class_266 objective) {
        if (this.cache == null || ((ScoreboardInformation)this.cache).objective() == null) {
            return false;
        }
        return ((ScoreboardInformation)this.cache).objective() == objective;
    }

    @Override
    protected ScoreboardInformation createCache(class_310 minecraft, class_327 font) {
        class_8646 displaySlot;
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return ScoreboardInformation.EMPTY;
        }
        class_269 scoreboard = player.method_7327();
        class_266 objective = null;
        class_268 localPlayerTeam = scoreboard.method_1164(player.method_5820());
        if (localPlayerTeam != null && (displaySlot = class_8646.method_52622((class_124)localPlayerTeam.method_1202())) != null) {
            objective = scoreboard.method_1189(displaySlot);
        }
        if (objective == null) {
            objective = scoreboard.method_1189(class_8646.field_45157);
        }
        if (objective == null) {
            return ScoreboardInformation.EMPTY;
        }
        class_9022 numberFormat = objective.method_55380((class_9022)class_9025.field_47567);
        ArrayList<String> players = new ArrayList<String>();
        ArrayList<String> teams = new ArrayList<String>();
        players.add(player.method_5820());
        if (localPlayerTeam != null) {
            teams.add(localPlayerTeam.method_1197());
        }
        ArrayList<class_9011> scores = new ArrayList<class_9011>(scoreboard.method_1184(objective));
        scores.sort(SCORE_DISPLAY_ORDER.reversed());
        ArrayList<BakedComponent> lines = new ArrayList<BakedComponent>();
        ArrayList<BakedComponent> numbers = new ArrayList<BakedComponent>();
        int lowerLimit = scores.size() - 15;
        BakedComponentBuilder headerBuilder = new BakedComponentBuilder(objective.method_1114(), font);
        headerBuilder.shadow = false;
        BakedComponent baked = headerBuilder.build();
        int extraWidth = font.method_1727(": ");
        int maxWidth = baked.width;
        for (int index = scores.size() - 1; index >= lowerLimit && index >= 0; --index) {
            class_9011 score = (class_9011)scores.get(index);
            if (score.method_55385()) {
                --lowerLimit;
                continue;
            }
            class_268 playerTeam = scoreboard.method_1164(score.comp_2127());
            players.add(score.comp_2127());
            if (playerTeam != null) {
                teams.add(playerTeam.method_1197());
            }
            class_5250 text = class_268.method_1142((class_270)playerTeam, (class_2561)score.method_55387());
            BakedComponentBuilder lineTextBuilder = new BakedComponentBuilder((class_2561)text, font);
            lineTextBuilder.shadow = false;
            BakedComponent bakedText = lineTextBuilder.build();
            lines.add(0, bakedText);
            class_5250 component = score.method_55386(numberFormat);
            BakedComponentBuilder numberTextBuilder = new BakedComponentBuilder((class_2561)component, font);
            numberTextBuilder.forceRenderCharactersSeparate = true;
            numberTextBuilder.shadow = false;
            BakedComponent bakedNumber = numberTextBuilder.build();
            maxWidth = Math.max(maxWidth, bakedText.width + (bakedNumber.width > 0 ? bakedNumber.width + extraWidth : 0));
            numbers.add(0, bakedNumber);
        }
        return new ScoreboardInformation(objective, players, teams, baked, lines, numbers, maxWidth);
    }

    @Override
    protected void render(class_332 graphics, ScoreboardInformation cache, class_310 minecraft, int screenWidth, int screenHeight, class_327 font, float partialTicks, boolean dynamic) {
        int height = cache.lines().size() * 9;
        int bottom = screenHeight / 2 + height / 3;
        int left = screenWidth - cache.maxWidth() - 3;
        int backgroundRight = screenWidth - 3 + 2;
        int headerTop = bottom - cache.lines().size() * 9;
        if (!dynamic) {
            int darkerBackground = minecraft.field_1690.method_19345(0.4f);
            graphics.method_25294(left - 2, headerTop - 9 - 1, backgroundRight, headerTop - 1, darkerBackground);
            int background = minecraft.field_1690.method_19345(0.3f);
            graphics.method_25294(left - 2, bottom, backgroundRight, headerTop - 1, background);
        }
        if (cache.header().shouldDraw(dynamic)) {
            cache.header().draw(graphics, font, left + cache.maxWidth() / 2 - cache.header().width / 2, headerTop - 9, -1);
        }
        for (int line = 1; line <= cache.lines().size(); ++line) {
            BakedComponent num;
            BakedComponent text = cache.lines().get(line - 1);
            int lineTop = bottom - line * 9;
            if (text.shouldDraw(dynamic)) {
                text.draw(graphics, font, left, lineTop, -1);
            }
            if (cache.numbers().size() < line || !(num = cache.numbers().get(line - 1)).shouldDraw(dynamic)) continue;
            num.draw(graphics, font, backgroundRight - num.width, lineTop, -1);
        }
    }
}

