/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.render.cache.chat;

import com.noxcrew.noxesium.feature.render.cache.ElementCache;
import com.noxcrew.noxesium.feature.render.cache.chat.ChatInformation;
import com.noxcrew.noxesium.feature.render.font.BakedComponent;
import com.noxcrew.noxesium.mixin.performance.render.ext.ChatComponentExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7591;

public class ChatCache
extends ElementCache<ChatInformation> {
    private static ChatCache instance;
    public static int lastTick;
    public static int mouseX;
    public static int mouseY;

    public static ChatCache getInstance() {
        if (instance == null) {
            instance = new ChatCache();
        }
        return instance;
    }

    public ChatCache() {
        this.registerVariable("fading", (minecraft, partialTicks) -> {
            class_338 chatOverlay = minecraft.field_1705.method_1743();
            ChatComponentExt chatExt = (ChatComponentExt)chatOverlay;
            boolean focused = chatExt.invokeIsChatFocused();
            ArrayList<class_303.class_7590> messages = new ArrayList<class_303.class_7590>(chatExt.getTrimmedMessages());
            if (messages.isEmpty()) {
                return List.of();
            }
            ArrayList<Integer> fading = new ArrayList<Integer>();
            int index = 0;
            for (class_303.class_7590 line : messages) {
                ++index;
                int ticksSinceMessageSend = lastTick - line.comp_895();
                double d = focused ? 1.0 : ChatComponentExt.invokeGetTimeFactor(ticksSinceMessageSend);
                double timeFactor = d;
                if (!(timeFactor < 1.0)) continue;
                fading.add(index - 1);
            }
            return fading;
        });
    }

    @Override
    protected ChatInformation createCache(class_310 minecraft, class_327 font) {
        class_338 chatOverlay = minecraft.field_1705.method_1743();
        ChatComponentExt chatExt = (ChatComponentExt)chatOverlay;
        if (chatExt.invokeIsChatHidden() || chatExt.getTrimmedMessages().isEmpty()) {
            return ChatInformation.EMPTY;
        }
        long queueSize = minecraft.method_44714().method_44944();
        ArrayList<BakedComponent> lines = new ArrayList<BakedComponent>();
        boolean focused = chatExt.invokeIsChatFocused();
        ArrayList<class_303.class_7590> messages = new ArrayList<class_303.class_7590>(chatExt.getTrimmedMessages());
        List fading = (List)this.getVariable("fading");
        for (class_303.class_7590 line : messages) {
            BakedComponent baked = new BakedComponent(line.comp_896(), font);
            lines.add(baked);
        }
        return new ChatInformation(messages, chatExt.getChatScrollbarPos(), chatExt.getNewMessageSinceScroll(), focused, new BakedComponent((class_2561)class_2561.method_43469((String)"chat.queue", (Object[])new Object[]{queueSize}), font), lines, fading);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void render(class_332 graphics, ChatInformation cache, class_310 minecraft, int screenWidth, int screenHeight, class_327 font, float partialTicks, boolean dynamic) {
        class_338 chatOverlay = minecraft.field_1705.method_1743();
        ChatComponentExt chatExt = (ChatComponentExt)chatOverlay;
        int messageCount = cache.trimmedMessages().size();
        int linesPerPage = chatOverlay.method_1813();
        boolean focused = cache.focused();
        float scale = (float)chatOverlay.method_1814();
        int scaledWidth = class_3532.method_15386((float)((float)chatOverlay.method_1811() / scale));
        int height = graphics.method_51443();
        class_4587 pose = graphics.method_51448();
        try {
            int lineBottom;
            int backgroundAlpha;
            int alpha;
            pose.method_22903();
            pose.method_22905(scale, scale, 1.0f);
            pose.method_46416(4.0f, 0.0f, 0.0f);
            int scaledHeight = class_3532.method_15375((float)((float)(height - 40) / scale));
            int highlightedMessage = chatExt.invokeGetMessageEndIndexAt(chatExt.invokeScreenToChatX(mouseX), chatExt.invokeScreenToChatY(mouseY));
            double opacity = (Double)minecraft.field_1690.method_42542().method_41753() * (double)0.9f + (double)0.1f;
            double backgroundOpacity = (Double)minecraft.field_1690.method_42550().method_41753();
            double lineSpacing = (Double)minecraft.field_1690.method_42546().method_41753();
            int lineHeight = chatExt.invokeGetLineHeight();
            int lineSize = (int)Math.round(-8.0 * (lineSpacing + 1.0) + 4.0 * lineSpacing);
            int shownLineCount = 0;
            for (int currentLine = 0; currentLine + cache.chatScrollbarPos() < messageCount && currentLine < linesPerPage; ++currentLine) {
                int ticksSinceMessageSend;
                int messageIndex = currentLine + cache.chatScrollbarPos();
                class_303.class_7590 line = cache.trimmedMessages().get(messageIndex);
                if (line == null || (ticksSinceMessageSend = lastTick - line.comp_895()) >= 200 && !focused) continue;
                double timeFactor = focused ? 1.0 : ChatComponentExt.invokeGetTimeFactor(ticksSinceMessageSend);
                alpha = (int)(255.0 * timeFactor * opacity);
                backgroundAlpha = (int)(255.0 * timeFactor * backgroundOpacity);
                ++shownLineCount;
                if (alpha <= 3) continue;
                lineBottom = scaledHeight - currentLine * lineHeight;
                int lineDrawTop = lineBottom + lineSize;
                pose.method_22903();
                pose.method_46416(0.0f, 0.0f, 50.0f);
                class_7591 guiMessageTag = line.comp_897();
                if (cache.fading().contains(messageIndex) == dynamic) {
                    graphics.method_25294(-4, lineBottom - lineHeight, scaledWidth + 4 + 4, lineBottom, backgroundAlpha << 24);
                    if (guiMessageTag != null) {
                        int tagColor = guiMessageTag.comp_899() | alpha << 24;
                        graphics.method_25294(-4, lineBottom - lineHeight, -2, lineBottom, tagColor);
                    }
                }
                if (dynamic && guiMessageTag != null && messageIndex == highlightedMessage && guiMessageTag.comp_900() != null) {
                    int tagIconLeft = cache.lines().get((int)messageIndex).width + 4;
                    Objects.requireNonNull(font);
                    int tagIconTop = lineDrawTop + 9;
                    int drawTop = tagIconTop - guiMessageTag.comp_900().field_39767 - 1;
                    guiMessageTag.comp_900().method_44712(graphics, tagIconLeft, drawTop);
                }
                if (cache.fading().contains(messageIndex) ? dynamic : cache.lines().get(messageIndex).shouldDraw(dynamic)) {
                    pose.method_46416(0.0f, 0.0f, 50.0f);
                    cache.lines().get(messageIndex).draw(graphics, font, 0, lineDrawTop, 0xFFFFFF + (alpha << 24));
                }
                pose.method_22909();
            }
            if (!dynamic) {
                long queueSize = minecraft.method_44714().method_44944();
                if (queueSize > 0L) {
                    int queueColor = (int)(128.0 * opacity);
                    int queueBackgroundColor = (int)(255.0 * backgroundOpacity);
                    pose.method_22903();
                    pose.method_46416(0.0f, (float)scaledHeight, 50.0f);
                    graphics.method_25294(-2, 0, scaledWidth + 4, 9, queueBackgroundColor << 24);
                    pose.method_46416(0.0f, 0.0f, 50.0f);
                    cache.queueSize().draw(graphics, font, 0, 1, 0xFFFFFF + (queueColor << 24));
                    pose.method_22909();
                }
                if (focused) {
                    int drawnFocusedTop = messageCount * lineHeight;
                    int theoryFocusedTop = shownLineCount * lineHeight;
                    int scrollHeight = cache.chatScrollbarPos() * theoryFocusedTop / messageCount - scaledHeight;
                    alpha = theoryFocusedTop * theoryFocusedTop / drawnFocusedTop;
                    if (drawnFocusedTop != theoryFocusedTop) {
                        backgroundAlpha = scrollHeight > 0 ? 170 : 96;
                        int z = cache.newMessageSinceScroll() ? 0xCC3333 : 0x3333AA;
                        lineBottom = scaledWidth + 4;
                        graphics.method_51737(lineBottom, -scrollHeight, lineBottom + 2, -scrollHeight - alpha, 100, z + (backgroundAlpha << 24));
                        graphics.method_51737(lineBottom + 2, -scrollHeight, lineBottom + 1, -scrollHeight - alpha, 100, 0xCCCCCC + (backgroundAlpha << 24));
                    }
                }
            }
        }
        finally {
            pose.method_22909();
        }
    }

    static {
        lastTick = 0;
        mouseX = 0;
        mouseY = 0;
    }
}

