/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.render.cache.bossbar;

import com.noxcrew.noxesium.feature.render.cache.ElementCache;
import com.noxcrew.noxesium.feature.render.cache.bossbar.BossBar;
import com.noxcrew.noxesium.feature.render.cache.bossbar.BossBarInformation;
import com.noxcrew.noxesium.feature.render.font.BakedComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1259;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_337;
import net.minecraft.class_345;
import net.minecraft.class_3532;

public class BossBarCache
extends ElementCache<BossBarInformation> {
    private static BossBarCache instance;
    private static final int HEIGHT = 12;
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 5;
    private static final class_2960[] BAR_BACKGROUND_SPRITES;
    private static final class_2960[] BAR_PROGRESS_SPRITES;
    private static final class_2960[] OVERLAY_BACKGROUND_SPRITES;
    private static final class_2960[] OVERLAY_PROGRESS_SPRITES;

    public static BossBarCache getInstance() {
        if (instance == null) {
            instance = new BossBarCache();
        }
        return instance;
    }

    public BossBarCache() {
        this.registerVariable("progress", (minecraft, partialTicks) -> {
            class_337 overlay = minecraft.field_1705.method_1740();
            if (overlay.field_2060.isEmpty()) {
                return Map.of();
            }
            HashMap progress = new HashMap();
            for (Map.Entry entry : overlay.field_2060.entrySet()) {
                progress.put(entry.getKey(), Float.valueOf(((class_345)entry.getValue()).method_5412()));
            }
            return progress;
        });
    }

    @Override
    protected BossBarInformation createCache(class_310 minecraft, class_327 font) {
        class_337 overlay = minecraft.field_1705.method_1740();
        if (overlay.field_2060.isEmpty()) {
            return BossBarInformation.EMPTY;
        }
        Map progress = (Map)this.getVariable("progress");
        ArrayList<BossBar> bars = new ArrayList<BossBar>();
        for (Map.Entry entry : overlay.field_2060.entrySet()) {
            class_345 bar = (class_345)entry.getValue();
            bars.add(new BossBar(new BakedComponent(bar.method_5414(), font), bar.method_5415(), bar.method_5420(), ((Float)progress.get(entry.getKey())).floatValue()));
        }
        return new BossBarInformation(bars);
    }

    @Override
    protected boolean shouldForceBlending() {
        return true;
    }

    @Override
    protected void render(class_332 graphics, BossBarInformation cache, class_310 minecraft, int screenWidth, int screenHeight, class_327 font, float partialTicks, boolean dynamic) {
        int currentHeight = 12;
        for (BossBar bossbar : cache.bars()) {
            if (!dynamic) {
                int barLeft = screenWidth / 2 - 91;
                this.drawBar(graphics, barLeft, currentHeight, bossbar, 182, BAR_BACKGROUND_SPRITES, OVERLAY_BACKGROUND_SPRITES);
                int progress = class_3532.method_53063((float)bossbar.progress(), (int)0, (int)182);
                if (progress > 0) {
                    this.drawBar(graphics, barLeft, currentHeight, bossbar, progress, BAR_PROGRESS_SPRITES, OVERLAY_PROGRESS_SPRITES);
                }
            }
            if (bossbar.name().shouldDraw(dynamic)) {
                int x = screenWidth / 2 - bossbar.name().width / 2;
                int y = currentHeight - 9;
                bossbar.name().draw(graphics, font, x, y, 0xFFFFFF);
            }
            if ((currentHeight += 19) < screenHeight / 3) continue;
            break;
        }
    }

    private void drawBar(class_332 guiGraphics, int x, int y, BossBar bossBar, int targetWidth, class_2960[] bars, class_2960[] overlays) {
        guiGraphics.method_52708(bars[bossBar.color().ordinal()], 182, 5, 0, 0, x, y, targetWidth, 5);
        if (bossBar.overlay() != class_1259.class_1261.field_5795) {
            guiGraphics.method_52708(overlays[bossBar.overlay().ordinal() - 1], 182, 5, 0, 0, x, y, targetWidth, 5);
        }
    }

    static {
        BAR_BACKGROUND_SPRITES = new class_2960[]{new class_2960("boss_bar/pink_background"), new class_2960("boss_bar/blue_background"), new class_2960("boss_bar/red_background"), new class_2960("boss_bar/green_background"), new class_2960("boss_bar/yellow_background"), new class_2960("boss_bar/purple_background"), new class_2960("boss_bar/white_background")};
        BAR_PROGRESS_SPRITES = new class_2960[]{new class_2960("boss_bar/pink_progress"), new class_2960("boss_bar/blue_progress"), new class_2960("boss_bar/red_progress"), new class_2960("boss_bar/green_progress"), new class_2960("boss_bar/yellow_progress"), new class_2960("boss_bar/purple_progress"), new class_2960("boss_bar/white_progress")};
        OVERLAY_BACKGROUND_SPRITES = new class_2960[]{new class_2960("boss_bar/notched_6_background"), new class_2960("boss_bar/notched_10_background"), new class_2960("boss_bar/notched_12_background"), new class_2960("boss_bar/notched_20_background")};
        OVERLAY_PROGRESS_SPRITES = new class_2960[]{new class_2960("boss_bar/notched_6_progress"), new class_2960("boss_bar/notched_10_progress"), new class_2960("boss_bar/notched_12_progress"), new class_2960("boss_bar/notched_20_progress")};
    }
}

