/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.render.cache;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.noxcrew.noxesium.feature.render.cache.ElementBuffer;
import com.noxcrew.noxesium.feature.render.cache.ElementInformation;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public abstract class ElementCache<T extends ElementInformation>
implements Closeable {
    public static boolean hasDrawnSomething = false;
    public static boolean allowBlendChanges = true;
    private static final Set<ElementCache<?>> caches = new HashSet();
    private final Map<String, BiFunction<class_310, Float, Object>> variables = new HashMap<String, BiFunction<class_310, Float, Object>>();
    private final Map<String, Object> values = new HashMap<String, Object>();
    private ElementBuffer buffer;
    private boolean needsRedraw = true;
    protected T cache = null;

    public static Collection<ElementCache<?>> getAllCaches() {
        return caches;
    }

    public ElementCache() {
        caches.add(this);
    }

    public void registerVariable(String name, BiFunction<class_310, Float, Object> function) {
        Preconditions.checkState((!this.variables.containsKey(name) ? 1 : 0) != 0, (Object)("Variable called " + name + " already exists"));
        this.variables.put(name, function);
    }

    protected abstract T createCache(class_310 var1, class_327 var2);

    protected ElementBuffer createBuffer() {
        return new ElementBuffer(true);
    }

    protected boolean hasDynamicLayer() {
        return true;
    }

    protected boolean shouldForceBlending() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(class_332 graphics, int screenWidth, int screenHeight, float partialTicks, class_310 minecraft) {
        T cache = this.getCache(minecraft, partialTicks);
        if (cache.isEmpty()) {
            return;
        }
        try {
            graphics.method_51452();
            ElementBuffer buffer = this.getBuffer(graphics, cache);
            if (buffer.isValid() && !buffer.isEmpty()) {
                buffer.draw();
            }
            if (this.hasDynamicLayer()) {
                this.render(graphics, cache, minecraft, screenWidth, screenHeight, minecraft.field_1772, partialTicks, true);
            }
        }
        finally {
            graphics.method_51452();
        }
    }

    protected abstract void render(class_332 var1, T var2, class_310 var3, int var4, int var5, class_327 var6, float var7, boolean var8);

    public <V> V getVariable(String name) {
        if (!this.values.containsKey(name)) {
            return (V)this.variables.get(name).apply(class_310.method_1551(), Float.valueOf(0.0f));
        }
        return (V)this.values.get(name);
    }

    public T getCache(class_310 minecraft, float partialTicks) {
        if (!this.variables.isEmpty()) {
            for (Map.Entry<String, BiFunction<class_310, Float, Object>> variable : this.variables.entrySet()) {
                Object newValue;
                Object currentValue = this.values.get(variable.getKey());
                if (Objects.equals(currentValue, newValue = variable.getValue().apply(minecraft, Float.valueOf(partialTicks))) && currentValue != null) continue;
                this.clearCache();
                for (Map.Entry<String, BiFunction<class_310, Float, Object>> otherVariable : this.variables.entrySet()) {
                    if (Objects.equals(variable.getKey(), otherVariable.getKey())) {
                        this.values.put(variable.getKey(), newValue);
                        continue;
                    }
                    this.values.put(otherVariable.getKey(), otherVariable.getValue().apply(minecraft, Float.valueOf(partialTicks)));
                }
            }
        }
        if (this.cache == null) {
            this.cache = this.createCache(minecraft, minecraft.field_1772);
        }
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementBuffer getBuffer(class_332 graphics, T cache) {
        RenderSystem.assertOnRenderThread();
        class_310 minecraft = class_310.method_1551();
        if (this.buffer == null) {
            this.buffer = this.createBuffer();
        }
        if (this.buffer.resize(minecraft.method_22683())) {
            this.needsRedraw = true;
        }
        if (this.needsRedraw && this.buffer.isValid()) {
            class_276 target = this.buffer.getTarget();
            try {
                target.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
                target.method_1230(class_310.field_1703);
                target.method_1235(false);
                this.buffer.setEmpty(false);
                hasDrawnSomething = false;
                if (this.shouldForceBlending()) {
                    ElementCache.withBlend(() -> {
                        RenderSystem.enableBlend();
                        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                    }, () -> this.render(graphics, cache, minecraft, minecraft.method_22683().method_4486(), minecraft.method_22683().method_4502(), minecraft.field_1772, 0.0f, false));
                } else {
                    this.render(graphics, cache, minecraft, minecraft.method_22683().method_4486(), minecraft.method_22683().method_4502(), minecraft.field_1772, 0.0f, false);
                }
            }
            finally {
                graphics.method_51452();
                this.needsRedraw = false;
                target.method_1240();
                minecraft.method_1522().method_1235(true);
            }
        }
        return this.buffer;
    }

    public void clearCache() {
        this.cache = null;
        this.values.clear();
        this.needsRedraw = true;
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
    }

    public static void withBlend(Runnable configure, Runnable runnable) {
        boolean currentBlend = GlStateManager.BLEND.field_5045.field_5051;
        int srcRgb = GlStateManager.BLEND.field_5049;
        int dstRgb = GlStateManager.BLEND.field_5048;
        int srcAlpha = GlStateManager.BLEND.field_5047;
        int dstAlpha = GlStateManager.BLEND.field_5046;
        configure.run();
        allowBlendChanges = false;
        runnable.run();
        allowBlendChanges = true;
        if (currentBlend) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        GlStateManager._blendFuncSeparate((int)srcRgb, (int)dstRgb, (int)srcAlpha, (int)dstAlpha);
    }
}

