/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium;

import com.google.common.base.Preconditions;
import com.noxcrew.noxesium.NoxesiumConfig;
import com.noxcrew.noxesium.NoxesiumModule;
import com.noxcrew.noxesium.api.protocol.ClientSettings;
import com.noxcrew.noxesium.feature.render.NoxesiumReloadListener;
import com.noxcrew.noxesium.feature.rule.ServerRuleModule;
import com.noxcrew.noxesium.feature.skull.SkullFontModule;
import com.noxcrew.noxesium.feature.sounds.NoxesiumSoundModule;
import com.noxcrew.noxesium.network.NoxesiumPackets;
import com.noxcrew.noxesium.network.serverbound.ServerboundClientInformationPacket;
import com.noxcrew.noxesium.network.serverbound.ServerboundClientSettingsPacket;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3264;
import org.jetbrains.annotations.NotNull;

public class NoxesiumMod
implements ClientModInitializer {
    public static final int VERSION = 4;
    public static final String BUKKIT_COMPOUND_ID = "PublicBukkitValues";
    public static final String NAMESPACE = "noxesium";
    public static final String IMMOVABLE_TAG = new class_2960("noxesium", "immovable").toString();
    private static NoxesiumMod instance;
    private final Map<Class<? extends NoxesiumModule>, NoxesiumModule> modules = new HashMap<Class<? extends NoxesiumModule>, NoxesiumModule>();
    private int currentMaxProtocol = 4;
    private final NoxesiumConfig config = NoxesiumConfig.load();

    public static NoxesiumMod getInstance() {
        return instance;
    }

    public NoxesiumConfig getConfig() {
        return this.config;
    }

    public void registerModule(NoxesiumModule module) {
        this.modules.put(module.getClass(), module);
    }

    @NotNull
    public <T extends NoxesiumModule> T getModule(Class<T> clazz) {
        return (T)((NoxesiumModule)Preconditions.checkNotNull((Object)this.modules.get(clazz), (Object)("Could not get module " + clazz.getSimpleName())));
    }

    public int getMaxProtocolVersion() {
        return this.currentMaxProtocol;
    }

    public void setServerVersion(int maxProtocolVersion) {
        this.currentMaxProtocol = maxProtocolVersion;
    }

    public void onInitializeClient() {
        instance = this;
        this.registerModule(new ServerRuleModule());
        this.registerModule(new SkullFontModule());
        this.registerModule(new NoxesiumSoundModule());
        C2SPlayChannelEvents.REGISTER.register((ignored1, ignored2, ignored3, channels) -> {
            if (!channels.contains(NoxesiumPackets.SERVER_CLIENT_INFO.getId())) {
                return;
            }
            if (class_310.method_1551().method_1562() != null) {
                new ServerboundClientInformationPacket(4).send();
                NoxesiumMod.syncGuiScale();
                this.modules.values().forEach(NoxesiumModule::onJoinServer);
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((ignored1, ignored2) -> {
            this.currentMaxProtocol = 4;
            this.modules.values().forEach(NoxesiumModule::onQuitServer);
        });
        NoxesiumPackets.registerPackets("universal");
        this.modules.values().forEach(NoxesiumModule::onStartup);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new NoxesiumReloadListener());
    }

    public static void syncGuiScale() {
        if (class_310.method_1551().method_1562() == null) {
            return;
        }
        class_1041 window = class_310.method_1551().method_22683();
        class_315 options = class_310.method_1551().field_1690;
        new ServerboundClientSettingsPacket(new ClientSettings(((Integer)options.method_42474().method_41753()).intValue(), window.method_4495(), window.method_4486(), window.method_4502(), class_310.method_1551().method_1573(), ((Boolean)options.method_42446().method_41753()).booleanValue(), ((Double)options.method_48191().method_41753()).doubleValue())).send();
    }
}

