/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium;

import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class NoxesiumMixinPlugin
implements IMixinConfigPlugin {
    private static final String PREFIX = "com.noxcrew.noxesium.mixin.";
    private boolean isUsingSodium;
    private boolean isUsingIris;
    private boolean isUsingChime;

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!mixinClassName.startsWith(PREFIX)) {
            return false;
        }
        return switch (mixinClassName.substring(PREFIX.length())) {
            case "beacon.SodiumWorldRendererMixin" -> {
                if (this.isUsingSodium && !this.isUsingIris) {
                    yield true;
                }
                yield false;
            }
            case "performance.model.SodiumMixinItemRendererMixin" -> this.isUsingSodium;
            case "performance.SodiumVideoSettingsMenuMixin" -> this.isUsingSodium;
            case "performance.model.ItemOverridesMixin" -> {
                if (!this.isUsingChime) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public void onLoad(String mixinPackage) {
        this.isUsingSodium = FabricLoader.getInstance().isModLoaded("sodium");
        this.isUsingIris = FabricLoader.getInstance().isModLoaded("iris");
        this.isUsingChime = FabricLoader.getInstance().isModLoaded("chime");
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

