/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.noxcrew.noxesium.util.CompatibilityReferences;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class NoxesiumConfig {
    public static Boolean experimentalPatchesHotkey = null;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean showFpsOverlay = false;
    public boolean enableExperimentalPerformancePatches = false;

    public boolean areExperimentalPatchesAvailable() {
        return !CompatibilityReferences.isUsingFeatherClient();
    }

    public boolean hasConfiguredPerformancePatches() {
        return this.areExperimentalPatchesAvailable() && this.enableExperimentalPerformancePatches;
    }

    public boolean shouldDisableExperimentalPerformancePatches() {
        if (this.hasConfiguredPerformancePatches()) {
            if (experimentalPatchesHotkey != null) {
                return experimentalPatchesHotkey == false;
            }
            return false;
        }
        return true;
    }

    public static NoxesiumConfig load() {
        Path file = NoxesiumConfig.getConfigFile();
        if (Files.exists(file, new LinkOption[0])) {
            NoxesiumConfig noxesiumConfig;
            FileReader reader = new FileReader(file.toFile());
            try {
                noxesiumConfig = (NoxesiumConfig)GSON.fromJson((Reader)reader, NoxesiumConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            reader.close();
            return noxesiumConfig;
        }
        return new NoxesiumConfig();
    }

    public void save() {
        try {
            Files.writeString(NoxesiumConfig.getConfigFile(), (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static Path getConfigFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("noxesium-config.json");
    }
}

